/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.analyzer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.wsdl.WSDLException;
import org.eclipse.wst.wsi.internal.core.ToolInfo;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSIFileNotFoundException;
import org.eclipse.wst.wsi.internal.core.analyzer.Analyzer;
import org.eclipse.wst.wsi.internal.core.analyzer.AnalyzerContext;
import org.eclipse.wst.wsi.internal.core.analyzer.ServiceReference;
import org.eclipse.wst.wsi.internal.core.log.LogReader;
import org.eclipse.wst.wsi.internal.core.log.MessageEntryHandler;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertionsReader;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.EnvelopeValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.MessageValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.UDDIValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.WSDLValidator;
import org.eclipse.wst.wsi.internal.core.report.ArtifactReference;
import org.eclipse.wst.wsi.internal.core.report.Report;
import org.eclipse.wst.wsi.internal.core.report.ReportArtifact;
import org.eclipse.wst.wsi.internal.core.report.ReportContext;
import org.eclipse.wst.wsi.internal.core.report.ReportWriter;
import org.eclipse.wst.wsi.internal.core.report.impl.DefaultReporter;
import org.eclipse.wst.wsi.internal.core.util.ArtifactType;
import org.eclipse.wst.wsi.internal.core.util.WSIProperties;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.eclipse.wst.wsi.internal.core.xml.XMLDocumentCache;

public class BasicProfileAnalyzer
extends Analyzer {
    public static final String TOOL_NAME = "Analyzer";
    protected WSDLDocument wsdlDocument = null;

    public BasicProfileAnalyzer(String[] args) throws WSIException {
        super(args, new ToolInfo(TOOL_NAME));
        new XMLDocumentCache();
    }

    public BasicProfileAnalyzer(String[] args, boolean validate) throws WSIException {
        super(args, new ToolInfo(TOOL_NAME), validate);
        new XMLDocumentCache();
    }

    public BasicProfileAnalyzer(List analyzerConfigList) throws WSIException {
        super(analyzerConfigList, new ToolInfo(TOOL_NAME));
        new XMLDocumentCache();
    }

    public BasicProfileAnalyzer(List analyzerConfigList, String wsdlURI) throws WSIException {
        super(analyzerConfigList, new ToolInfo(TOOL_NAME));
        new XMLDocumentCache();
        try {
            if (wsdlURI != null) {
                this.wsdlDocument = new WSDLDocument(wsdlURI);
            }
        }
        catch (WSDLException we) {
            throw new WSIException(we.getMessage(), we);
        }
    }

    public int validateConformance() throws WSIException {
        int statusCode = 0;
        Report report = null;
        ReportArtifact reportArtifact = null;
        String wsdlURI = null;
        this.analyzerContext = new AnalyzerContext(new ServiceReference(this.getAnalyzerConfig()));
        try {
            ProfileAssertionsReader profileAssertionsReader = this.documentFactory.newProfileAssertionsReader();
            this.profileAssertions = profileAssertionsReader.readProfileAssertions(this.getAnalyzerConfig().getTestAssertionsDocumentLocation());
            report = this.documentFactory.newReport();
            report.setLocation(this.getAnalyzerConfig().getReportLocation());
            ReportContext reportContext = new ReportContext("WS-I Basic Profile Conformance Report.", this.profileAssertions, this);
            report.setReportContext(reportContext);
            ReportWriter reportWriter = this.documentFactory.newReportWriter();
            reportWriter.setWriter(this.getAnalyzerConfig().getReportLocation());
            this.reporter = new DefaultReporter(report, reportWriter);
            this.reporter.startReport();
            reportArtifact = this.setCurrentArtifact(ArtifactType.ARTIFACT_TYPE_DISCOVERY);
            wsdlURI = this.validateUDDI(reportArtifact, this.factory.newUDDIValidator());
            if (wsdlURI == null && this.getAnalyzerConfig().isWSDLReferenceSet()) {
                wsdlURI = this.getAnalyzerConfig().getWSDLLocation();
            }
            this.reporter.endCurrentArtifact();
            reportArtifact = this.setCurrentArtifact(ArtifactType.ARTIFACT_TYPE_DESCRIPTION);
            this.wsdlDocument = this.validateWSDL(reportArtifact, this.factory.newWSDLValidator(), wsdlURI, this.wsdlDocument);
            if (this.wsdlDocument == null && this.getAnalyzerConfig().isWSDLReferenceSet()) {
                throw new WSIException(this.messageList.getMessage("config05", "WSDL document was either not found or could not be processed."));
            }
            this.reporter.endCurrentArtifact();
            reportArtifact = this.setCurrentArtifact(ArtifactType.ARTIFACT_TYPE_MESSAGE);
            this.validateMessages(reportArtifact, this.factory.newMessageValidator(), this.wsdlDocument);
            this.reporter.endCurrentArtifact();
            if (!this.profileAssertions.getTADName().equals("Basic Profile Test Assertions")) {
                reportArtifact = this.setCurrentArtifact(ArtifactType.ARTIFACT_TYPE_ENVELOPE);
                this.validateEnvelopes(reportArtifact, this.factory.newEnvelopeValidator(), this.wsdlDocument);
                this.reporter.endCurrentArtifact();
            }
            this.reporter.finishReport();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            String message = this.messageList.getMessage("error03", "The conformance validation process failed.");
            if (this.reporter != null) {
                pw.println(message);
                pw.println(String.valueOf(this.messageList.getMessage("exception01", "Exception: ")) + e.getClass().getName());
                e.printStackTrace(pw);
                this.reporter.finishReportWithError(sw.toString());
            }
            if (e instanceof WSIException) {
                throw (WSIException)e;
            }
            throw new WSIException(message, e);
        }
        if (report != null) {
            statusCode = report.getSummaryResult().equals("passed") ? 0 : 1;
        }
        return statusCode;
    }

    private String validateUDDI(ReportArtifact reportArtifact, UDDIValidator uddiValidator) throws WSIException {
        String wsdlURI = null;
        uddiValidator.init(this.analyzerContext, this.profileAssertions.getArtifact("discovery"), reportArtifact, this.getAnalyzerConfig().getUDDIReference(), this.reporter);
        if (this.getAnalyzerConfig().isUDDIReferenceSet()) {
            wsdlURI = uddiValidator.validate();
            uddiValidator.cleanup();
        } else {
            uddiValidator.setAllMissingInput();
        }
        return wsdlURI;
    }

    private WSDLDocument validateWSDL(ReportArtifact reportArtifact, WSDLValidator wsdlValidator, String wsdlURI, WSDLDocument document) throws WSIException {
        WSDLDocument returnWSDLDocument = null;
        wsdlValidator.init(this.analyzerContext, this.profileAssertions.getArtifact("description"), reportArtifact, wsdlURI, document, this.reporter);
        if (wsdlURI != null || document != null) {
            returnWSDLDocument = wsdlValidator.validate();
            wsdlValidator.cleanup();
        } else {
            wsdlValidator.setAllMissingInput();
        }
        return returnWSDLDocument;
    }

    private void validateMessages(ReportArtifact reportArtifact, MessageValidator messageValidator, WSDLDocument document) throws WSIException {
        messageValidator.init(this.analyzerContext, this.profileAssertions.getArtifact("message"), reportArtifact, document, this.reporter);
        if (this.getAnalyzerConfig().getLogLocation() != null) {
            LogReader logReader = this.documentFactory.newLogReader();
            MessageProcessor messageProcessor = new MessageProcessor(messageValidator);
            logReader.readLog(this.getAnalyzerConfig().getLogLocation(), (MessageEntryHandler)messageProcessor);
            messageValidator.cleanup();
        } else {
            messageValidator.setAllMissingInput();
        }
    }

    private void validateEnvelopes(ReportArtifact reportArtifact, EnvelopeValidator envelopeValidator, WSDLDocument document) throws WSIException {
        envelopeValidator.init(this.analyzerContext, this.profileAssertions.getArtifact("envelope"), reportArtifact, document, this.reporter);
        if (this.getAnalyzerConfig().getLogLocation() != null) {
            LogReader logReader = this.documentFactory.newLogReader();
            EnvelopeProcessor envelopeProcessor = new EnvelopeProcessor(envelopeValidator);
            logReader.readLog(this.getAnalyzerConfig().getLogLocation(), (MessageEntryHandler)envelopeProcessor);
            envelopeValidator.cleanup();
        } else {
            envelopeValidator.setAllMissingInput();
        }
    }

    public static void main(String[] args) throws IOException {
        int statusCode;
        block6: {
            statusCode = 0;
            BasicProfileAnalyzer analyzer = null;
            try {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", WSIProperties.getProperty("javax.xml.parsers.DocumentBuilderFactory"));
                System.setProperty("org.uddi4j.TransportClassName", WSIProperties.getProperty("org.uddi4j.TransportClassName"));
                analyzer = new BasicProfileAnalyzer(args);
                statusCode = ((Analyzer)analyzer).validateConformance();
                analyzer.printMessage("created01", null, "Conformance report has been created.");
            }
            catch (Exception e) {
                String messageData;
                String defaultMessage;
                String messageID;
                statusCode = 1;
                if (e instanceof WSIFileNotFoundException || e instanceof IllegalArgumentException) {
                    messageID = "error01";
                    defaultMessage = "Analyzer Error:";
                    messageData = e.getMessage();
                } else {
                    messageID = "error02";
                    defaultMessage = "Analyzer Stopped By Exception:";
                    messageData = e.toString();
                }
                if (analyzer != null) {
                    analyzer.printMessage(messageID, messageData, defaultMessage);
                } else {
                    Analyzer.staticPrintMessage(messageID, messageData, defaultMessage);
                }
                if (analyzer == null || analyzer.getAnalyzerConfig() == null || !analyzer.getAnalyzerConfig().getVerboseOption()) break block6;
                BasicProfileAnalyzer.dump(e);
            }
        }
        System.exit(statusCode);
    }

    protected ReportArtifact setCurrentArtifact(ArtifactType artifactType) throws WSIException {
        ReportArtifact reportArtifact = this.reporter.createArtifact();
        reportArtifact.setType(artifactType);
        this.reporter.setCurrentArtifact(reportArtifact);
        return reportArtifact;
    }

    public static void dump(Throwable t) {
        while (t instanceof WSIException) {
            Throwable nested = ((WSIException)t).getTargetException();
            if (nested == null) break;
            t = nested;
        }
        t.printStackTrace();
    }

    class EnvelopeProcessor
    implements MessageEntryHandler {
        EnvelopeValidator envelopeValidator = null;

        EnvelopeProcessor(EnvelopeValidator envelopeValidator) {
            this.envelopeValidator = envelopeValidator;
        }

        public void processArtifactReference(ArtifactReference artifactReference) throws WSIException {
            BasicProfileAnalyzer.this.reporter.addArtifactReference(artifactReference);
        }

        public void processLogEntry(EntryContext entryContext) throws WSIException {
            this.envelopeValidator.validate(entryContext);
        }
    }

    class MessageProcessor
    implements MessageEntryHandler {
        MessageValidator messageValidator = null;

        MessageProcessor(MessageValidator messageValidator) {
            this.messageValidator = messageValidator;
        }

        public void processArtifactReference(ArtifactReference artifactReference) throws WSIException {
            BasicProfileAnalyzer.this.reporter.addArtifactReference(artifactReference);
        }

        public void processLogEntry(EntryContext entryContext) throws WSIException {
            this.messageValidator.validate(entryContext);
        }
    }
}

