/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client.connector.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

final class AutoReadHttpURLConnection
extends HttpURLConnection {
    private static final Log LOGGER;
    private static final int DEFAULT_CHUNK_SIZE = 16384;
    private HttpURLConnection delegate;
    private InputStream streamBuffer;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;

    static {
        Factory factory = new Factory("AutoReadHttpURLConnection.java", Class.forName("org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getHeaderField-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-int:-thePosition:--java.lang.String-"), 321);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getHeaderField-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-java.lang.String:-theName:--java.lang.String-"), 329);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setIfModifiedSince-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-long:-isModifiedSince:--void-"), 449);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setRequestProperty-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-java.lang.String:java.lang.String:-theKey:theValue:--void-"), 457);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setUseCaches-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-boolean:-isUsingCaches:--void-"), 465);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setRequestMethod-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-java.lang.String:-theMethod:-java.net.ProtocolException:-void-"), 521);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getHeaderFieldDate-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-java.lang.String:long:-theName:theDefaultValue:--long-"), 337);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getHeaderFieldInt-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-java.lang.String:int:-theName:theDefaultValue:--int-"), 345);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getHeaderFieldKey-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-int:-thePosition:--java.lang.String-"), 353);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getRequestProperty-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-java.lang.String:-theKey:--java.lang.String-"), 393);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setAllowUserInteraction-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-boolean:-hasInteraction:--void-"), 417);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setDefaultUseCaches-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-boolean:-isUsingDefaultCache:--void-"), 425);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setDoInput-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-boolean:-isInput:--void-"), 433);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setDoOutput-org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection-boolean:-isOutput:--void-"), 441);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = LogFactory.getLog((Class)clazz);
    }

    AutoReadHttpURLConnection(HttpURLConnection theConnection) {
        super(null);
        this.delegate = theConnection;
    }

    public synchronized InputStream getInputStream() throws IOException {
        try {
            if (this.streamBuffer == null) {
                LOGGER.debug((Object)("Original connection = " + this.delegate));
                InputStream is = this.delegate.getInputStream();
                this.streamBuffer = this.getBufferedInputStream(is);
            }
        }
        catch (IOException e) {
            this.logErrorStream(this.delegate.getErrorStream());
            throw e;
        }
        return this.streamBuffer;
    }

    private void logErrorStream(InputStream theErrorStream) throws IOException {
        if (theErrorStream != null) {
            String buffer;
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(theErrorStream));
            while ((buffer = errorStream.readLine()) != null) {
                LOGGER.debug((Object)("ErrorStream [" + buffer + "]"));
            }
        }
    }

    private InputStream getBufferedInputStream(InputStream theInputStream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(16384);
        this.copy(theInputStream, os);
        ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
        return bais;
    }

    private void copy(InputStream theInputStream, OutputStream theOutputStream) throws IOException {
        LOGGER.debug((Object)("Content-Length : [" + this.delegate.getContentLength() + "]"));
        if (theInputStream != null && this.delegate.getContentLength() != 0) {
            int count;
            byte[] buf = new byte[16384];
            while (-1 != (count = theInputStream.read(buf))) {
                this.printReadLogs(count, buf);
                theOutputStream.write(buf, 0, count);
            }
        }
    }

    private void printReadLogs(int theCount, byte[] theBuffer) {
        StringBuffer prefix = new StringBuffer();
        int i = 0;
        while (i < theCount) {
            if (theBuffer[i] == 10) {
                prefix.append("\\r");
            } else if (theBuffer[i] == 13) {
                prefix.append("\\n");
            } else {
                prefix.append((char)theBuffer[i]);
            }
            ++i;
        }
        LOGGER.debug((Object)("Read [" + theCount + "]: [" + prefix + "]"));
    }

    public void connect() throws IOException {
        this.delegate.connect();
    }

    public boolean getAllowUserInteraction() {
        return this.delegate.getAllowUserInteraction();
    }

    public Object getContent() throws IOException {
        return this.delegate.getContent();
    }

    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public int getContentLength() {
        return this.delegate.getContentLength();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public long getDate() {
        return this.delegate.getDate();
    }

    public boolean getDefaultUseCaches() {
        return this.delegate.getDefaultUseCaches();
    }

    public boolean getDoInput() {
        return this.delegate.getDoInput();
    }

    public boolean getDoOutput() {
        return this.delegate.getDoOutput();
    }

    public long getExpiration() {
        return this.delegate.getExpiration();
    }

    public String getHeaderField(int n) {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        return (String)AutoReadHttpURLConnection.getHeaderField_aroundBody1$advice(this, n2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getHeaderField(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2);
        return (String)AutoReadHttpURLConnection.getHeaderField_aroundBody3$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public long getHeaderFieldDate(String string, long l) {
        String string2 = string;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2, (Object)Conversions.longObject((long)l2));
        return Conversions.longValue((Object)AutoReadHttpURLConnection.getHeaderFieldDate_aroundBody5$advice(this, string2, l2, joinPoint, LogAspect.aspectOf(), null, joinPoint));
    }

    public int getHeaderFieldInt(String string, int n) {
        String string2 = string;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2));
        return Conversions.intValue((Object)AutoReadHttpURLConnection.getHeaderFieldInt_aroundBody7$advice(this, string2, n2, joinPoint, LogAspect.aspectOf(), null, joinPoint));
    }

    public String getHeaderFieldKey(int n) {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        return (String)AutoReadHttpURLConnection.getHeaderFieldKey_aroundBody9$advice(this, n2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public long getIfModifiedSince() {
        return this.delegate.getIfModifiedSince();
    }

    public long getLastModified() {
        return this.delegate.getLastModified();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public Permission getPermission() throws IOException {
        return this.delegate.getPermission();
    }

    public String getRequestProperty(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2);
        return (String)AutoReadHttpURLConnection.getRequestProperty_aroundBody11$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public boolean getUseCaches() {
        return this.delegate.getUseCaches();
    }

    public void setAllowUserInteraction(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        AutoReadHttpURLConnection.setAllowUserInteraction_aroundBody13$advice(this, bl2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void setDefaultUseCaches(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        AutoReadHttpURLConnection.setDefaultUseCaches_aroundBody15$advice(this, bl2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void setDoInput(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        AutoReadHttpURLConnection.setDoInput_aroundBody17$advice(this, bl2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void setDoOutput(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        AutoReadHttpURLConnection.setDoOutput_aroundBody19$advice(this, bl2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void setIfModifiedSince(long l) {
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        AutoReadHttpURLConnection.setIfModifiedSince_aroundBody21$advice(this, l2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void setRequestProperty(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string3, (Object)string4);
        AutoReadHttpURLConnection.setRequestProperty_aroundBody23$advice(this, string3, string4, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void setUseCaches(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        AutoReadHttpURLConnection.setUseCaches_aroundBody25$advice(this, bl2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void disconnect() {
        this.delegate.disconnect();
    }

    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    public String getRequestMethod() {
        return this.delegate.getRequestMethod();
    }

    public int getResponseCode() throws IOException {
        return this.delegate.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.delegate.getResponseMessage();
    }

    public void setRequestMethod(String string) throws ProtocolException {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2);
        AutoReadHttpURLConnection.setRequestMethod_aroundBody27$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public boolean usingProxy() {
        return this.delegate.usingProxy();
    }

    private static final String getHeaderField_aroundBody0(AutoReadHttpURLConnection autoReadHttpURLConnection, int n, JoinPoint joinPoint) {
        return autoReadHttpURLConnection.delegate.getHeaderField(n);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getHeaderField_aroundBody1$advice(AutoReadHttpURLConnection this_, int ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            String string = AutoReadHttpURLConnection.getHeaderField_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append((Object)string);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return string;
        }
        void var11_11 = logger;
        return AutoReadHttpURLConnection.getHeaderField_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
    }

    private static final String getHeaderField_aroundBody2(AutoReadHttpURLConnection autoReadHttpURLConnection, String string, JoinPoint joinPoint) {
        return autoReadHttpURLConnection.delegate.getHeaderField(string);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getHeaderField_aroundBody3$advice(AutoReadHttpURLConnection this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            String string = AutoReadHttpURLConnection.getHeaderField_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append((Object)string);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return string;
        }
        void var11_11 = logger;
        return AutoReadHttpURLConnection.getHeaderField_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
    }

    private static final long getHeaderFieldDate_aroundBody4(AutoReadHttpURLConnection autoReadHttpURLConnection, String string, long l, JoinPoint joinPoint) {
        return autoReadHttpURLConnection.delegate.getHeaderFieldDate(string, l);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getHeaderFieldDate_aroundBody5$advice(AutoReadHttpURLConnection this_, String ajc_aroundClosure, long thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void exitString;
        void logger;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(logAspect, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            Object object = Conversions.longObject((long)AutoReadHttpURLConnection.getHeaderFieldDate_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)logger));
            StringBuffer stringBuffer = new StringBuffer(joinPoint2.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(object);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return object;
        }
        void var13_12 = exitString;
        return Conversions.longObject((long)AutoReadHttpURLConnection.getHeaderFieldDate_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)logger));
    }

    private static final int getHeaderFieldInt_aroundBody6(AutoReadHttpURLConnection autoReadHttpURLConnection, String string, int n, JoinPoint joinPoint) {
        return autoReadHttpURLConnection.delegate.getHeaderFieldInt(string, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getHeaderFieldInt_aroundBody7$advice(AutoReadHttpURLConnection this_, String ajc_aroundClosure, int thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            Object object = Conversions.intObject((int)AutoReadHttpURLConnection.getHeaderFieldInt_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target));
            StringBuffer stringBuffer = new StringBuffer(joinPoint2.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(object);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return object;
        }
        void var12_12 = result;
        return Conversions.intObject((int)AutoReadHttpURLConnection.getHeaderFieldInt_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target));
    }

    private static final String getHeaderFieldKey_aroundBody8(AutoReadHttpURLConnection autoReadHttpURLConnection, int n, JoinPoint joinPoint) {
        return autoReadHttpURLConnection.delegate.getHeaderFieldKey(n);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getHeaderFieldKey_aroundBody9$advice(AutoReadHttpURLConnection this_, int ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            String string = AutoReadHttpURLConnection.getHeaderFieldKey_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append((Object)string);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return string;
        }
        void var11_11 = logger;
        return AutoReadHttpURLConnection.getHeaderFieldKey_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
    }

    private static final String getRequestProperty_aroundBody10(AutoReadHttpURLConnection autoReadHttpURLConnection, String string, JoinPoint joinPoint) {
        return autoReadHttpURLConnection.delegate.getRequestProperty(string);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getRequestProperty_aroundBody11$advice(AutoReadHttpURLConnection this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            String string = AutoReadHttpURLConnection.getRequestProperty_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append((Object)string);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return string;
        }
        void var11_11 = logger;
        return AutoReadHttpURLConnection.getRequestProperty_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint);
    }

    private static final void setAllowUserInteraction_aroundBody12(AutoReadHttpURLConnection autoReadHttpURLConnection, boolean bl, JoinPoint joinPoint) {
        autoReadHttpURLConnection.delegate.setAllowUserInteraction(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setAllowUserInteraction_aroundBody13$advice(AutoReadHttpURLConnection this_, boolean ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AutoReadHttpURLConnection.setAllowUserInteraction_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AutoReadHttpURLConnection.setAllowUserInteraction_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setDefaultUseCaches_aroundBody14(AutoReadHttpURLConnection autoReadHttpURLConnection, boolean bl, JoinPoint joinPoint) {
        autoReadHttpURLConnection.delegate.setDefaultUseCaches(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setDefaultUseCaches_aroundBody15$advice(AutoReadHttpURLConnection this_, boolean ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AutoReadHttpURLConnection.setDefaultUseCaches_aroundBody14(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AutoReadHttpURLConnection.setDefaultUseCaches_aroundBody14(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setDoInput_aroundBody16(AutoReadHttpURLConnection autoReadHttpURLConnection, boolean bl, JoinPoint joinPoint) {
        autoReadHttpURLConnection.delegate.setDoInput(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setDoInput_aroundBody17$advice(AutoReadHttpURLConnection this_, boolean ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AutoReadHttpURLConnection.setDoInput_aroundBody16(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AutoReadHttpURLConnection.setDoInput_aroundBody16(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setDoOutput_aroundBody18(AutoReadHttpURLConnection autoReadHttpURLConnection, boolean bl, JoinPoint joinPoint) {
        autoReadHttpURLConnection.delegate.setDoOutput(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setDoOutput_aroundBody19$advice(AutoReadHttpURLConnection this_, boolean ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AutoReadHttpURLConnection.setDoOutput_aroundBody18(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AutoReadHttpURLConnection.setDoOutput_aroundBody18(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setIfModifiedSince_aroundBody20(AutoReadHttpURLConnection autoReadHttpURLConnection, long l, JoinPoint joinPoint) {
        autoReadHttpURLConnection.delegate.setIfModifiedSince(l);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setIfModifiedSince_aroundBody21$advice(AutoReadHttpURLConnection this_, long ajc_aroundClosure, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            AutoReadHttpURLConnection.setIfModifiedSince_aroundBody20(this_, ajc_aroundClosure, (JoinPoint)target);
            Object var9_9 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_9;
        }
        void var11_10 = result;
        AutoReadHttpURLConnection.setIfModifiedSince_aroundBody20(this_, ajc_aroundClosure, (JoinPoint)target);
        return null;
    }

    private static final void setRequestProperty_aroundBody22(AutoReadHttpURLConnection autoReadHttpURLConnection, String string, String string2, JoinPoint joinPoint) {
        autoReadHttpURLConnection.delegate.setRequestProperty(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setRequestProperty_aroundBody23$advice(AutoReadHttpURLConnection this_, String ajc_aroundClosure, String thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            AutoReadHttpURLConnection.setRequestProperty_aroundBody22(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        void var11_11 = result;
        AutoReadHttpURLConnection.setRequestProperty_aroundBody22(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }

    private static final void setUseCaches_aroundBody24(AutoReadHttpURLConnection autoReadHttpURLConnection, boolean bl, JoinPoint joinPoint) {
        autoReadHttpURLConnection.delegate.setUseCaches(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setUseCaches_aroundBody25$advice(AutoReadHttpURLConnection this_, boolean ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AutoReadHttpURLConnection.setUseCaches_aroundBody24(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AutoReadHttpURLConnection.setUseCaches_aroundBody24(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setRequestMethod_aroundBody26(AutoReadHttpURLConnection autoReadHttpURLConnection, String string, JoinPoint joinPoint) {
        autoReadHttpURLConnection.delegate.setRequestMethod(string);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setRequestMethod_aroundBody27$advice(AutoReadHttpURLConnection this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AutoReadHttpURLConnection.setRequestMethod_aroundBody26(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AutoReadHttpURLConnection.setRequestMethod_aroundBody26(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }
}

