/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.preferences.ui;

import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.Lexer;
import org.eclipse.wst.javascript.core.internal.jsparser.node.EOF;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TBlank;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TCommenttok;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TErrorChar;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TStringLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedComment;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedStringLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.Token;
import org.eclipse.wst.javascript.ui.internal.common.style.LineStyleProviderForJavaScript;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocumentRegion;

public class TokenParser
implements RegionParser {
    private PushbackReader fPushBackReader = null;
    private List regions = null;

    public IStructuredDocumentRegion getDocumentRegions() {
        Lexer lexer = new Lexer(this.fPushBackReader);
        Token token = null;
        ContextRegion region = null;
        BasicStructuredDocumentRegion node = new BasicStructuredDocumentRegion();
        int start = -1;
        int textLength = 0;
        int length = 0;
        boolean useSame = false;
        this.regions = new ArrayList();
        try {
            token = lexer.next();
        }
        catch (Exception exception) {}
        while (token != null && !(token instanceof EOF)) {
            useSame = false;
            start = token.getLPOffset();
            textLength = length = token.toString().length();
            String type = "DEFAULT";
            if (token instanceof TStringLiteral) {
                type = "LITERAL";
            } else if (!(token instanceof TBlank)) {
                if (token instanceof TCommenttok) {
                    type = "COMMENT";
                } else if (token instanceof TUnterminatedComment) {
                    type = "UNFINISHED_COMMENT";
                } else if (token instanceof TUnterminatedStringLiteral) {
                    type = "UNFINISHED_COMMENT";
                } else if (token instanceof TErrorChar) {
                    type = "UNFINISHED_COMMENT";
                } else if (this.isKeyword(token.getText())) {
                    type = "KEYWORD";
                }
            }
            boolean bl = useSame = useSame || region != null && region.getType() == type;
            if (useSame && region != null) {
                region.setLength(region.getLength() + length);
                region.setTextLength(region.getLength());
            } else {
                if (region != null) {
                    this.regions.add(region);
                }
                region = new ContextRegion(type, start, textLength, length);
                node.addRegion((ITextRegion)region);
            }
            try {
                token = lexer.next();
            }
            catch (Exception exception) {}
        }
        this.regions.add(region);
        node.setStart(0);
        node.setLength(region.getStart() + region.getLength());
        node.setEnded(true);
        return node;
    }

    public List getRegions() {
        if (this.regions == null) {
            this.getDocumentRegions();
        }
        return this.regions;
    }

    protected boolean isKeyword(String text) {
        String[] keywords = LineStyleProviderForJavaScript.keywords;
        int i = 0;
        while (i < keywords.length) {
            if (keywords[i].equals(text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void reset(Reader reader) {
        this.reset(reader, 0);
    }

    public void reset(Reader reader, int offset) {
        this.fPushBackReader = new PushbackReader(reader);
    }

    public void reset(String s) {
        this.reset(new StringReader(s));
    }

    public void reset(String input, int offset) {
        this.reset(new StringReader(input), offset);
    }

    public RegionParser newInstance() {
        return new TokenParser();
    }
}

