/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.Vector;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementAction;
import org.eclipse.wst.wsdl.ui.internal.actions.BaseNodeAction;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddWSISchemaImportAction
extends BaseNodeAction {
    protected Definition definition;
    protected Element definitionElement;
    protected String namespace;
    protected String location;
    protected String elementDeclarationNamespacePrefix;

    public AddWSISchemaImportAction(Definition definition, String namespace, String location) {
        this.definition = definition;
        this.namespace = namespace;
        this.location = location;
        this.definitionElement = WSDLEditorUtil.getInstance().getElementForObject(definition);
    }

    public Node getNode() {
        return this.definitionElement;
    }

    public String getUndoDescription() {
        return Messages.getString("_UI_ACTION_ADD_IMPORT");
    }

    protected Element getOrCreateTypesElement() {
        Element typesElement = null;
        if (this.definition.getTypes() == null) {
            if (this.definitionElement != null) {
                AddElementAction addTypesAction = new AddElementAction("", "icons/xsd_obj.gif", this.definitionElement, this.definitionElement.getPrefix(), "types");
                addTypesAction.setComputeTopLevelRefChild(true);
                addTypesAction.run();
                typesElement = addTypesAction.getNewElement();
                AddWSISchemaImportAction.format(typesElement);
            }
        } else {
            typesElement = WSDLEditorUtil.getInstance().getElementForObject(this.definition.getTypes());
        }
        return typesElement;
    }

    protected Element getImportHolderElement(Element typesElement) {
        Element importHolderElement = null;
        NodeList nodeList = typesElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && "schema".equals((element = (Element)node).getLocalName()) && element.getAttribute("targetNamespace") == null) {
                importHolderElement = element;
                break;
            }
            ++i;
        }
        return importHolderElement;
    }

    public Element getOrCreateImportHolderElement(Element typesElement) {
        Element importHolderElement = this.getImportHolderElement(typesElement);
        if (importHolderElement == null) {
            AddElementAction addImportHolderAction = new AddElementAction("", "icons/xsd_obj.gif", typesElement, "xsd", "schema"){

                protected void addAttributes(Element newElement) {
                    newElement.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                }
            };
            addImportHolderAction.run();
            importHolderElement = addImportHolderAction.getNewElement();
            AddWSISchemaImportAction.format(importHolderElement);
        }
        return importHolderElement;
    }

    protected boolean importNotAlreadyExists() {
        Element typesElement;
        Element schemaElement;
        boolean notExists = true;
        if (this.definition.getTypes() != null && (schemaElement = this.getImportHolderElement(typesElement = WSDLEditorUtil.getInstance().getElementForObject(this.definition.getTypes()))) != null) {
            Node node = schemaElement.getFirstChild();
            Vector<Node> schemaChildren = new Vector<Node>();
            if (node != null) {
                Node child = node;
                if (!(child instanceof TextImpl)) {
                    schemaChildren.addElement(child);
                }
                while (child.getNextSibling() != null) {
                    if ((child = child.getNextSibling()) instanceof TextImpl) continue;
                    schemaChildren.addElement(child);
                }
                int index = 0;
                while (index < schemaChildren.size()) {
                    Element schemaChild = (Element)schemaChildren.elementAt(index);
                    String schemaLocation = schemaChild.getAttribute("schemaLocation");
                    String schemaNamespace = schemaChild.getAttribute("namespace");
                    if (schemaLocation != null && this.namespace != null && schemaLocation.equals(this.location) && schemaNamespace.equals(this.namespace)) {
                        notExists = false;
                        break;
                    }
                    ++index;
                }
            }
        }
        return notExists;
    }

    public void run() {
        if (this.definitionElement != null && this.importNotAlreadyExists()) {
            this.beginRecording();
            this.performAddElement();
            this.endRecording();
        }
    }

    public void performAddElement() {
        try {
            Element typesElement = this.getOrCreateTypesElement();
            Element importHolderElement = this.getOrCreateImportHolderElement(typesElement);
            AddElementAction addImportAction = new AddElementAction("", "icons/xsd_obj.gif", importHolderElement, importHolderElement.getPrefix(), "import"){

                protected void addAttributes(Element newElement) {
                    newElement.setAttribute("namespace", AddWSISchemaImportAction.this.namespace);
                    newElement.setAttribute("schemaLocation", AddWSISchemaImportAction.this.location);
                }
            };
            addImportAction.run();
            Element newElement = addImportAction.getNewElement();
            AddWSISchemaImportAction.format(newElement);
        }
        catch (Exception exception) {}
    }

    public void setElementDeclarationNamespacePrefix(String nsPrefix) {
        this.elementDeclarationNamespacePrefix = nsPrefix;
    }

    protected static void format(Node parentNode) {
        if (parentNode instanceof IDOMNode) {
            FormatProcessorXML formatProcessorXML = new FormatProcessorXML();
            formatProcessorXML.formatNode((Node)((IDOMNode)parentNode));
        }
    }
}

