/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.apache.xerces.util.XMLChar;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNameCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.RefactoringSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewTypeDialog;
import org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListDialogDelegate;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDAttributeDeclarationSection
extends RefactoringSection {
    protected Text nameText;
    protected CCombo typeCombo;
    boolean isAttributeReference;
    static /* synthetic */ Class class$0;

    protected void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        String typeLabel = org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_TYPE;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_NAME);
        nameLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        this.nameText.setLayoutData((Object)data);
        this.applyAllListeners((Control)this.nameText);
        this.createRenameHyperlink(this.composite);
        this.getWidgetFactory().createCLabel(this.composite, typeLabel);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.typeCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.typeCombo.setLayoutData((Object)data);
        this.typeCombo.addSelectionListener((SelectionListener)this);
    }

    private void fillTypesCombo() {
        String currentTypeName;
        ComponentSpecification ret;
        IEditorPart editor = this.getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDTypeReferenceEditManager manager = (XSDTypeReferenceEditManager)editor.getAdapter((Class)clazz);
        ComponentSpecification[] items = manager.getQuickPicks();
        this.typeCombo.removeAll();
        this.typeCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE);
        this.typeCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW);
        int i = 0;
        while (i < items.length) {
            this.typeCombo.add(items[i].getName());
            ++i;
        }
        XSDAttributeDeclaration namedComponent = ((XSDAttributeDeclaration)this.input).getResolvedAttributeDeclaration();
        XSDTypeDefinition namedComponentType = namedComponent.getType();
        if (namedComponentType != null && (ret = this.getComponentSpecFromQuickPickForValue(currentTypeName = namedComponentType.getQName((XSDConcreteComponent)this.xsdSchema), manager)) == null) {
            this.typeCombo.add(currentTypeName);
        }
    }

    private ComponentSpecification getComponentSpecFromQuickPickForValue(String value, ComponentReferenceEditManager editManager) {
        ComponentSpecification[] quickPicks;
        if (editManager != null && (quickPicks = editManager.getQuickPicks()) != null) {
            int i = 0;
            while (i < quickPicks.length) {
                ComponentSpecification componentSpecification = quickPicks[i];
                if (value.equals(componentSpecification.getName())) {
                    return componentSpecification;
                }
                ++i;
            }
        }
        return null;
    }

    public void refresh() {
        XSDAttributeDeclaration namedComponent;
        String name;
        super.refresh();
        this.setListenerEnabled(false);
        this.nameText.setText("");
        if (this.input instanceof XSDAttributeDeclaration && (name = (namedComponent = ((XSDAttributeDeclaration)this.input).getResolvedAttributeDeclaration()).getName()) != null) {
            this.nameText.setText(name);
        }
        this.typeCombo.setText("");
        if (this.input != null && this.input instanceof XSDAttributeDeclaration) {
            boolean isAnonymous;
            XSDAttributeDeclaration xsdAttribute = ((XSDAttributeDeclaration)this.input).getResolvedAttributeDeclaration();
            this.isAttributeReference = ((XSDAttributeDeclaration)this.input).isAttributeDeclarationReference();
            XSDSimpleTypeDefinition typeDef = xsdAttribute.getTypeDefinition();
            boolean bl = isAnonymous = xsdAttribute.getAnonymousTypeDefinition() != null;
            if (isAnonymous) {
                this.typeCombo.setText("**anonymous**");
            } else {
                this.fillTypesCombo();
                String typeName = "";
                if (typeDef != null) {
                    typeName = typeDef.getQName((XSDConcreteComponent)this.xsdSchema);
                    if (typeName == null) {
                        typeName = "";
                    }
                    this.typeCombo.setText(typeName);
                } else {
                    this.typeCombo.setText(org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_NO_TYPE);
                }
            }
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.typeCombo) {
            IEditorPart editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
            String selection = this.typeCombo.getText();
            IComponentDialog dialog = null;
            if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE)) {
                dialog = manager.getBrowseDialog();
                ((XSDSearchListDialogDelegate)dialog).showComplexTypes(false);
            } else if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW)) {
                dialog = manager.getNewDialog();
                ((NewTypeDialog)dialog).allowComplexType(false);
            }
            if (dialog != null) {
                if (dialog.createAndOpen() == 0) {
                    ComponentSpecification newValue = dialog.getSelectedComponent();
                    manager.modifyComponentReference(this.input, newValue);
                }
            } else {
                ComponentSpecification newValue = this.getComponentSpecFromQuickPickForValue(selection, manager);
                if (newValue != null) {
                    manager.modifyComponentReference(this.input, newValue);
                }
            }
        }
        super.doWidgetSelected(e);
    }

    protected void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.widget == this.nameText) {
            if (!this.nameText.getEditable()) {
                return;
            }
            String newValue = this.nameText.getText().trim();
            if (this.input instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration namedComponent = ((XSDAttributeDeclaration)this.input).getResolvedAttributeDeclaration();
                if (!this.validateSection()) {
                    return;
                }
                UpdateNameCommand command = null;
                String oldName = namedComponent.getName();
                if (!newValue.equals(oldName)) {
                    command = new UpdateNameCommand(Messages._UI_ACTION_RENAME, (XSDNamedComponent)namedComponent, newValue);
                }
                if (command != null && this.getCommandStack() != null) {
                    this.getCommandStack().execute((Command)command);
                }
                if (this.isAttributeReference) {
                    XSDAttributeDeclaration attrRef = (XSDAttributeDeclaration)this.input;
                    String qname = attrRef.getResolvedAttributeDeclaration().getQName();
                    attrRef.getElement().setAttribute("ref", qname);
                }
            }
        }
    }

    protected boolean validateSection() {
        if (this.nameText == null || this.nameText.isDisposed()) {
            return true;
        }
        this.setErrorMessage(null);
        String name = this.nameText.getText().trim();
        if (name.length() < 1 || !XMLChar.isValidNCName((String)name)) {
            this.setErrorMessage(Messages._UI_ERROR_INVALID_NAME);
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.removeListeners((Control)this.nameText);
        }
        if (this.typeCombo != null && !this.typeCombo.isDisposed()) {
            this.typeCombo.removeSelectionListener((SelectionListener)this);
        }
        super.dispose();
    }
}

