/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.ui.internal.IDropAction;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.TransferBuilder;

public class ExtendedEditorDropTargetAdapter
extends DropTargetAdapter {
    private Point caret = null;
    private String[] editorIds;
    private int orgOffset = 0;
    private IEditorPart targetEditor = null;
    private ITextViewer textViewer = null;
    private Transfer[] transfers = null;
    private boolean useProxy;

    public ExtendedEditorDropTargetAdapter() {
        this(false);
    }

    public ExtendedEditorDropTargetAdapter(boolean useProxy) {
        this.useProxy = useProxy;
    }

    protected boolean doDrop(Transfer transfer, DropTargetEvent event) {
        TransferBuilder tb = new TransferBuilder(this.useProxy);
        IDropAction[] as = null;
        as = this.editorIds != null && this.editorIds.length > 0 ? tb.getDropActions(this.editorIds, transfer) : tb.getDropActions(this.getTargetEditor().getClass().getName(), transfer);
        int i = 0;
        while (i < as.length) {
            IDropAction da = as[i];
            Transfer actualTransfer = transfer instanceof TransferBuilder.TransferProxyForDelayLoading ? ((TransferBuilder.TransferProxyForDelayLoading)transfer).getTransferClass() : transfer;
            if (actualTransfer instanceof FileTransfer) {
                if (event.data == null) {
                    Logger.log(4, "No data in DropTargetEvent from " + event.widget);
                    return false;
                }
                String[] strs = (String[])event.data;
                boolean[] bs = new boolean[strs.length];
                int c = 0;
                int j = 0;
                while (j < strs.length) {
                    bs[j] = false;
                    if (da.isSupportedData(strs[j])) {
                        event.data = new String[]{strs[j]};
                        if (!da.run(event, this.targetEditor)) {
                            bs[j] = true;
                            ++c;
                        }
                    } else {
                        bs[j] = true;
                        ++c;
                    }
                    ++j;
                }
                if (c == 0) {
                    return true;
                }
                int k = 0;
                String[] rests = new String[c];
                int j2 = 0;
                while (j2 < strs.length) {
                    if (bs[j2]) {
                        rests[k++] = strs[j2];
                    }
                    ++j2;
                }
                event.data = rests;
            } else if (da.isSupportedData(event.data) && da.run(event, this.targetEditor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dragEnter(DropTargetEvent event) {
        this.caret = null;
        TransferData data = null;
        Transfer[] ts = this.getTransfers();
        int i = 0;
        while (i < ts.length) {
            int j = 0;
            while (j < event.dataTypes.length) {
                if (ts[i].isSupportedType(event.dataTypes[j])) {
                    data = event.dataTypes[j];
                    break;
                }
                ++j;
            }
            if (data != null) {
                event.currentDataType = data;
                break;
            }
            ++i;
        }
        if (this.textViewer != null) {
            this.orgOffset = this.textViewer.getTextWidget().getCaretOffset();
        }
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.textViewer != null) {
            StyledText st = this.textViewer.getTextWidget();
            st.setCaretOffset(this.orgOffset);
            st.redraw();
            st.update();
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.operations &= 0xFFFFFFFD;
        event.detail = 1;
        if (this.textViewer != null) {
            Point newCaret;
            Point pt = this.toControl(new Point(event.x, event.y));
            StyledText st = this.textViewer.getTextWidget();
            Rectangle ca = st.getClientArea();
            int margin = st.getLineHeight();
            if (pt.y < margin) {
                st.invokeAction(0x1000001);
            } else if (pt.y > ca.height - margin) {
                st.invokeAction(0x1000002);
            }
            int offset = this.getDropOffset(st, pt);
            if (offset != st.getCaretOffset()) {
                st.setCaretOffset(offset);
                st.setSelection(offset);
            }
            if ((newCaret = st.getLocationAtOffset(offset)).equals((Object)this.caret)) {
                return;
            }
            Caret ct = st.getCaret();
            Point size = ct.getSize();
            GC gc = new GC((Drawable)st);
            gc.setLineWidth(size.x);
            if (this.caret != null) {
                Color originalForeground = gc.getForeground();
                gc.setForeground(st.getBackground());
                gc.drawRectangle(this.caret.x, this.caret.y, size.x, size.y);
                gc.setForeground(originalForeground);
            }
            st.redraw();
            st.update();
            this.caret = newCaret;
            if (ct.getImage() != null) {
                gc.drawImage(ct.getImage(), this.caret.x, this.caret.y);
            } else {
                gc.drawLine(this.caret.x, this.caret.y, this.caret.x, this.caret.y + size.y);
            }
            gc.dispose();
        }
    }

    public void drop(DropTargetEvent event) {
        if (event.operations == 0) {
            return;
        }
        if (this.textViewer != null) {
            Point pt = this.toControl(new Point(event.x, event.y));
            StyledText st = this.textViewer.getTextWidget();
            int offset = this.getDropOffset(st, pt);
            if (offset != st.getCaretOffset()) {
                st.setCaretOffset(offset);
            }
            this.textViewer.setSelectedRange(offset, 0);
        }
        Transfer[] ts = this.getTransfers();
        int i = 0;
        while (i < ts.length) {
            if (ts[i].isSupportedType(event.currentDataType) && this.doDrop(ts[i], event)) break;
            ++i;
        }
    }

    protected int getDropOffset(DropTargetEvent event) {
        Point pt = this.getTextViewer().getTextWidget().toControl(new Point(event.x, event.y));
        StyledText st = this.textViewer.getTextWidget();
        return this.getDropOffset(st, pt);
    }

    /*
     * Unable to fully structure code
     */
    private int getDropOffset(StyledText st, Point pt) {
        block10: {
            offset = st.getCaretOffset();
            try {
                offset = st.getOffsetAtLocation(pt);
                break block10;
            }
            catch (IllegalArgumentException v0) {
                found = false;
                p = new Point(pt.x > 0 ? pt.x : 0, pt.y);
                ** while (p.x > -1)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    offset = st.getOffsetAtLocation(p);
                    if (this.textViewer != null && this.textViewer.getDocument() != null) {
                        lineInfo = null;
                        try {
                            lineInfo = this.textViewer.getDocument().getLineInformationOfOffset(offset);
                        }
                        catch (BadLocationException v1) {}
                        if (lineInfo != null) {
                            offset = lineInfo.getOffset() + lineInfo.getLength();
                        }
                    }
                    found = true;
                    break;
                }
                catch (IllegalArgumentException v2) {
                    --p.x;
                }
                continue;
            }
lbl24:
            // 2 sources

            if (!found) {
                offset = st.getCharCount();
            }
        }
        return offset;
    }

    public IEditorPart getTargetEditor() {
        return this.targetEditor;
    }

    public ITextViewer getTextViewer() {
        return this.textViewer;
    }

    public Transfer[] getTransfers() {
        if (this.transfers == null) {
            TransferBuilder tb = new TransferBuilder(this.useProxy);
            this.transfers = this.editorIds == null || this.editorIds.length == 0 ? tb.getDropTargetTransfers(this.getTargetEditor().getClass().getName()) : tb.getDropTargetTransfers(this.editorIds);
        }
        return this.transfers;
    }

    public void setTargetEditor(IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void setTargetIDs(String[] ids) {
        this.editorIds = ids;
    }

    public void setTextViewer(ITextViewer textViewer) {
        this.textViewer = textViewer;
    }

    private Point toControl(Point point) {
        return this.textViewer != null ? this.textViewer.getTextWidget().toControl(point) : point;
    }
}

