/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.dali.core.internal.PersistenceBuilder;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.internal.utility.iterators.CloneIterator;
import org.eclipse.dali.internal.utility.iterators.CompositeIterator;
import org.eclipse.dali.internal.utility.iterators.FilteringIterator;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.internal.utility.iterators.TreeIterator;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceContainer;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.impl.PersistenceContainerImpl;
import org.eclipse.dali.orm.impl.PersistenceModelManager;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;

public class PersistenceProjectImpl
extends PersistenceContainerImpl
implements PersistenceProject {
    private IJavaProject javaProject;
    private boolean constructed = false;

    public PersistenceProjectImpl() {
        super(null);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.PERSISTENCE_PROJECT;
    }

    public void configure() throws CoreException {
        PersistenceBuilder.addBuilderToProject(this.getProject());
        ProjectUtilities.addToBuildSpec((String)"org.eclipse.wst.validation.validationbuilder", (IProject)this.getProject());
    }

    public void deconfigure() throws CoreException {
        ProjectUtilities.removeFromBuildSpec((String)"org.eclipse.wst.validation.validationbuilder", (IProject)this.getProject());
        PersistenceBuilder.removeBuilderFromProject(this.getProject());
        PersistenceBuilder.deleteAuditMarkers(this.getProject());
    }

    public IProject getProject() {
        return (IProject)this.resource;
    }

    public void setProject(IProject project) {
        this.resource = project;
        this.javaProject = JavaCore.create((IProject)project);
        PersistenceModelManager.instance().getPersistenceModel().getProjects().add((Object)this);
    }

    public void buildResources() {
        this.buildInternalResources();
        this.setConstructed(true);
    }

    private synchronized void setConstructed(boolean constructed) {
        this.constructed = constructed;
    }

    private synchronized boolean isConstructed() {
        return this.constructed;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public Iterator persistenceFiles() {
        return new FilteringIterator((Iterator)new TreeIterator((Object)this, new TreeIterator.Midwife(){

            public Iterator children(Object next) {
                return next instanceof PersistenceContainer ? new CloneIterator((Collection)((PersistenceContainer)next).getPersistenceResources()) : NullIterator.instance();
            }
        })){

            protected boolean accept(Object o) {
                return o instanceof PersistenceFile;
            }
        };
    }

    public Iterator mappedTypes() {
        return new FilteringIterator((Iterator)new CompositeIterator((Iterator)new TransformationIterator(this.persistenceFiles()){

            protected Object transform(Object next) {
                return ((PersistenceFile)next).getPersistentTypes().iterator();
            }
        })){

            protected boolean accept(Object o) {
                return ((PersistentType)o).getTypeMapping().isMapped();
            }
        };
    }

    public String getConnectionName() {
        try {
            return this.getProject().getPersistentProperty(new QualifiedName("org.eclipse.dali.core", "connectionInfoProperty"));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void setConnectionName(String connectionInfoName) {
        try {
            this.getProject().setPersistentProperty(new QualifiedName("org.eclipse.dali.core", "connectionInfoProperty"), connectionInfoName);
        }
        catch (CoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Connection getConnection() {
        return PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNamed(this.getConnectionName());
    }

    public String getSchemaName() {
        try {
            return this.getProject().getPersistentProperty(new QualifiedName("org.eclipse.dali.core", "schemaProperty"));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void setSchemaName(String schemaName) {
        try {
            this.getProject().setPersistentProperty(new QualifiedName("org.eclipse.dali.core", "schemaProperty"), schemaName);
        }
        catch (CoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Schema getSchema() {
        return this.getConnection().getDatabase().schemaNamed(this.getSchemaName());
    }

    public PersistenceProject getPersistenceProject() {
        return this;
    }
}

