/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;

public class JavaPersistentTypeModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaPersistentTypeModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaPersistentTypeModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    public void testAddFields() throws Exception {
        JavaPersistentTypeModelAdapterTests.assertNotNull((Object)JavaPersistentTypeModelAdapter.persistentAttributeFor((PersistentType)this.testClassType, (IMember)this.project.getTestClassField()));
        JavaPersistentTypeModelAdapterTests.assertTrue((this.testClassType.getPersistentAttributes().size() == 2 ? 1 : 0) != 0);
        this.project.getTestClassType().createField("private int testField2;", (IJavaElement)this.project.getTestClassField(), false, null);
        JavaPersistentTypeModelAdapterTests.assertTrue((this.testClassType.getPersistentAttributes().size() == 3 ? 1 : 0) != 0);
    }

    public void testRenameFields() throws JavaModelException {
        try {
            this.project.getTestClassField().rename("newName", false, null);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        JavaPersistentTypeModelAdapterTests.assertTrue((boolean)((PersistentAttribute)this.testClassType.getPersistentAttributes().get(1)).getName().equals("newName"));
        JavaPersistentTypeModelAdapterTests.assertTrue((this.testClassType.getPersistentAttributes().size() == 2 ? 1 : 0) != 0);
    }

    public void testTransientField() throws JavaModelException {
        try {
            this.project.getTestClassType().createField("private transient int newField;", null, false, null);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        JavaPersistentTypeModelAdapterTests.assertTrue((boolean)((PersistentAttribute)this.testClassType.getPersistentAttributes().get(1)).getName().equals("testField"));
        JavaPersistentTypeModelAdapterTests.assertTrue((this.testClassType.getPersistentAttributes().size() == 2 ? 1 : 0) != 0);
    }
}

