/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.BasicMapping;
import org.eclipse.dali.orm.FetchType;
import org.eclipse.dali.orm.Optional;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.adapters.IBasicMappingModelAdapter;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.BooleanAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.IJavaDefaultAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaBasicMappingModelAdapter
extends JavaAttributeMappingModelAdapter
implements IBasicMappingModelAdapter,
IJavaDefaultAttributeMappingModelAdapter {
    private EnumAnnotationElementAdapter fetchTypeAdapter = new EnumAnnotationElementAdapter(this.buildFetchTypeInfo());
    private BooleanAnnotationElementAdapter optionalAdapter = new BooleanAnnotationElementAdapter(this.buildOptionalInfo());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public IColumnModelAdapter createColumnModelAdapter() {
        return new JavaColumnModelAdapter();
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildFetchTypeInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String fetchType) {
                if (fetchType == null) {
                    return;
                }
                if (fetchType.equals("EAGER")) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setFetchType(FetchType.EAGER_LITERAL);
                } else if (fetchType.equals("LAZY")) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setFetchType(FetchType.LAZY_LITERAL);
                } else if (fetchType.equals(FetchType.DEFAULT_LITERAL.getName())) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setFetchType(FetchType.DEFAULT_LITERAL);
                }
            }

            public String persValue() {
                FetchType fetchType = JavaBasicMappingModelAdapter.this.getBasicMapping().getFetchType();
                if (((Object)((Object)fetchType)).equals((Object)FetchType.EAGER_LITERAL)) {
                    return "EAGER";
                }
                if (((Object)((Object)fetchType)).equals((Object)FetchType.LAZY_LITERAL)) {
                    return "LAZY";
                }
                return FetchType.DEFAULT_LITERAL.getName();
            }

            public String enumClassName() {
                return "FetchType";
            }

            public String annotationElementName() {
                return "fetch";
            }

            public String annotationName() {
                return JavaBasicMappingModelAdapter.this.attributeMappingName();
            }

            public Member member() {
                return JavaBasicMappingModelAdapter.this.getAttribute();
            }

            public String defaultValue() {
                return FetchType.DEFAULT_LITERAL.getName();
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildOptionalInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                if (newValue == null) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setOptional(Optional.DEFAULT_LITERAL);
                } else if (newValue.equalsIgnoreCase("true")) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setOptional(Optional.YES_LITERAL);
                } else if (newValue.equalsIgnoreCase("false")) {
                    JavaBasicMappingModelAdapter.this.getBasicMapping().setOptional(Optional.NO_LITERAL);
                }
            }

            public String persValue() {
                switch (JavaBasicMappingModelAdapter.this.getBasicMapping().getOptional().getValue()) {
                    case 1: {
                        return "true";
                    }
                    case 2: {
                        return "false";
                    }
                }
                return null;
            }

            public String annotationElementName() {
                return "optional";
            }

            public String annotationName() {
                return "Basic";
            }

            public Member member() {
                return JavaBasicMappingModelAdapter.this.getAttribute();
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    protected AttributeMapping buildAttributeMapping(boolean isDefault) {
        return OrmFactory.eINSTANCE.createBasicMapping(this, isDefault);
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersFetchType(astRoot);
        this.updatePersOptional(astRoot);
        this.updatePersColumn(astRoot);
    }

    private void updatePersFetchType(CompilationUnit astRoot) {
        this.fetchTypeAdapter.updatePersElement(astRoot);
    }

    private void updatePersOptional(CompilationUnit astRoot) {
        this.optionalAdapter.updatePersElement(astRoot);
    }

    private void updatePersColumn(CompilationUnit astRoot) {
        this.getColumnModelAdapter().updatePersModel(astRoot);
    }

    public void defaultChanged() {
        this.updateJavaDefault();
    }

    public void fetchTypeChanged() {
        this.updateJavaFetchType();
    }

    public void optionalChanged() {
        this.updateJavaOptional();
    }

    private void updateJavaDefault() {
        boolean persDefault;
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        boolean javaDefault = this.javaPersistentAttributeType(astRoot) == null;
        if (javaDefault == (persDefault = this.getBasicMapping().isDefault())) {
            return;
        }
        if (persDefault) {
            this.removeAnnotation("Basic");
        } else {
            this.addMappingAnnotation("Basic");
        }
    }

    private void updateJavaFetchType() {
        this.fetchTypeAdapter.updateJavaElement();
    }

    private void updateJavaOptional() {
        this.optionalAdapter.updateJavaElement();
    }

    private BasicMapping getBasicMapping() {
        return (BasicMapping)this.getAttributeMapping();
    }

    private JavaColumnModelAdapter getColumnModelAdapter() {
        return (JavaColumnModelAdapter)this.getBasicMapping().getColumn().getModelAdapter();
    }

    public String attributeMappingName() {
        return "Basic";
    }

    public boolean defaultApplies(Attribute attribute) {
        IType type;
        String[][] resolvedType;
        if (attribute.isPrimitiveType()) {
            return true;
        }
        String typeName = Signature.getSignatureSimpleName((String)attribute.getTypeSignature());
        try {
            resolvedType = attribute.getJDTMember().getDeclaringType().resolveType(typeName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        if (resolvedType == null || resolvedType.length > 1) {
            return false;
        }
        String packageName = resolvedType[0][0];
        String fullyQualifiedTypeName = String.valueOf(packageName) + "." + typeName;
        if (this.isPrimitiveWrapperType(fullyQualifiedTypeName)) {
            return true;
        }
        if (this.isOtherJavaType(fullyQualifiedTypeName)) {
            return true;
        }
        try {
            type = attribute.getJDTMember().getCompilationUnit().getJavaProject().findType(fullyQualifiedTypeName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        if (type == null) {
            return false;
        }
        if (this.isEnumType(type)) {
            return true;
        }
        return this.implementsSerializable(type);
    }

    private boolean isPrimitiveWrapperType(String fullyQualifiedTypeName) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz.getName())) {
            return true;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz2.getName())) {
            return true;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz3.getName())) {
            return true;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz4.getName())) {
            return true;
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz5.getName())) {
            return true;
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz6.getName())) {
            return true;
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz7.getName())) {
            return true;
        }
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz8.getName())) {
            return true;
        }
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return fullyQualifiedTypeName.equals(clazz9.getName());
    }

    private boolean isOtherJavaType(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName.equals("java.lang.String")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.math.BigInteger")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.math.BigDecimal")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.util.Date")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.util.Calendar")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.sql.Date")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.sql.Time")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.sql.Timestamp")) {
            return true;
        }
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz.getName())) {
            return true;
        }
        Class<?> clazz2 = class$10;
        if (clazz2 == null) {
            try {
                clazz2 = class$10 = Class.forName("[Ljava.lang.Byte;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz2.getName())) {
            return true;
        }
        Class<?> clazz3 = class$11;
        if (clazz3 == null) {
            try {
                clazz3 = class$11 = Class.forName("[C");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (fullyQualifiedTypeName.equals(clazz3.getName())) {
            return true;
        }
        Class<?> clazz4 = class$12;
        if (clazz4 == null) {
            try {
                clazz4 = class$12 = Class.forName("[Ljava.lang.Character;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return fullyQualifiedTypeName.equals(clazz4.getName());
    }

    private boolean isEnumType(IType type) {
        try {
            return type.isEnum();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean implementsSerializable(IType type) {
        ITypeHierarchy hierarchy;
        try {
            hierarchy = type.newSupertypeHierarchy(null, null);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        IType[] allSuperInterfaces = hierarchy.getAllSuperInterfaces(type);
        int i = 0;
        while (i < allSuperInterfaces.length) {
            IType superInterface = allSuperInterfaces[i];
            if (superInterface.getFullyQualifiedName().equals("java.io.Serializable")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

