/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dali.core.Basic;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.PersistentAttributeFlavor;
import org.eclipse.dali.core.adapters.IPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.IPersistentAttributeModelAdapter;
import org.eclipse.dali.core.adapters.java.IJavaDefaultPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.edit.BasicItemProvider;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.PersistentAttributeItemProvider;
import org.eclipse.dali.ui.views.EmptyComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.NullMappingComposite;
import org.eclipse.dali.ui.views.ScrolledPageContent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class MappingComposite
extends Composite
implements IPersistenceComposite {
    private PersistentAttribute persistentAttribute;
    private PersistentAttributeItemProvider persistentAttributeItemProvider;
    private BasicItemProvider basicMappingTypeItemProvider;
    private ComboViewer persistentAttributeTypeCombo;
    private PageBook mappingPageBook;
    private IPersistenceComposite visibleMappingComposite;
    private EditingDomain editingDomain;
    private DaliItemProviderAdapterFactory adapterFactory;
    private INotifyChangedListener mappingListener;
    private INotifyChangedListener mappingTypeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.persistentAttributeItemProvider = (PersistentAttributeItemProvider)adapterFactory.createPersistentAttributeAdapter();
        this.basicMappingTypeItemProvider = (BasicItemProvider)adapterFactory.createBasicAdapter();
        this.initializeLayout(adapterFactory);
    }

    private void initializeLayout(DaliItemProviderAdapterFactory adapterFactory) {
        this.setLayout((Layout)new FillLayout());
        ScrolledPageContent pageContent = new ScrolledPageContent(this);
        GridLayout layout = new GridLayout(2, false);
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        Label mappingTypeLabel = new Label(composite, 16384);
        mappingTypeLabel.setText("Map As:");
        this.persistentAttributeTypeCombo = this.buildMappingTypeCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.persistentAttributeTypeCombo.getCombo().setLayoutData((Object)gridData);
        this.mappingPageBook = new PageBook(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.mappingPageBook.setLayoutData((Object)gridData);
    }

    private ComboViewer buildMappingTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IConfigurationElement) {
                    return ((IConfigurationElement)element).getAttribute("label");
                }
                return (String)element;
            }
        });
        viewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (((IConfigurationElement)element).getDeclaringExtension().getExtensionPointUniqueIdentifier().equals("org.eclipse.dali.ui.defaultMappings")) {
                    return 0;
                }
                return 1;
            }
        });
        viewer.add((Object[])this.mappingChoices());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MappingComposite.this.persistentAttributeTypeChanged(event);
            }
        });
        return viewer;
    }

    private IConfigurationElement[] mappingChoices() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dali.ui.mappings");
    }

    private IConfigurationElement[] defaultMappingChoices() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dali.ui.defaultMappings");
    }

    private IConfigurationElement configurationElementFor(String flavorName) {
        IConfigurationElement[] elements = this.mappingChoices();
        String flavorNameExtensionAttribute = ((IPersistentAttributeModelAdapter)this.persistentAttribute.getModelAdapter()).flavorNameExtensionAttribute();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String elementFlavorName = element.getAttribute(flavorNameExtensionAttribute);
            if (elementFlavorName != null && elementFlavorName.equals(flavorName)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private IConfigurationElement defaultConfigurationElementFor(PersistentAttribute persistentAttribute) {
        if (persistentAttribute.getModelAdapter() instanceof JavaPersistentAttributeModelAdapter) {
            IConfigurationElement[] elements = this.defaultMappingChoices();
            int i = 0;
            while (i < elements.length) {
                IJavaDefaultPersistentAttributeFlavorModelAdapter adapter;
                IConfigurationElement element = elements[i];
                try {
                    adapter = (IJavaDefaultPersistentAttributeFlavorModelAdapter)element.createExecutableExtension("javaModelAdapter");
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                if (adapter.defaultApplies(((JavaPersistentAttributeModelAdapter)persistentAttribute.getModelAdapter()).getAttribute())) {
                    return element;
                }
                ++i;
            }
        }
        return null;
    }

    private void persistentAttributeTypeChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof StructuredSelection) {
            IConfigurationElement selection = (IConfigurationElement)((StructuredSelection)event.getSelection()).getFirstElement();
            if (selection == null) {
                return;
            }
            boolean defaultSelected = selection.getDeclaringExtension().getExtensionPointUniqueIdentifier().equals("org.eclipse.dali.ui.defaultMappings");
            this.persistentAttribute.setFlavorKey(selection.getAttribute("key"), defaultSelected);
        }
    }

    public void populate(EObject mapping) {
        if (this.persistentAttribute != null) {
            this.persistentAttribute.eAdapters().remove((Object)this.persistentAttributeItemProvider);
            this.persistentAttribute.getFlavor().eAdapters().remove((Object)this.basicMappingTypeItemProvider);
            this.persistentAttributeItemProvider.removeListener(this.getMappingListener());
            this.basicMappingTypeItemProvider.removeListener(this.getMappingTypeListener());
        }
        this.persistentAttribute = (PersistentAttribute)mapping;
        if (this.persistentAttribute == null) {
            this.populate((PersistentAttributeFlavor)null);
            return;
        }
        this.persistentAttributeItemProvider.addListener(this.getMappingListener());
        this.basicMappingTypeItemProvider.addListener(this.getMappingTypeListener());
        this.persistentAttribute.eAdapters().add((Object)this.persistentAttributeItemProvider);
        this.persistentAttribute.getFlavor().eAdapters().add((Object)this.basicMappingTypeItemProvider);
        this.populate(this.persistentAttribute.getFlavor());
    }

    private void populate(PersistentAttributeFlavor persistentAttributeType) {
        if (persistentAttributeType == null) {
            return;
        }
        IConfigurationElement configurationElement = null;
        this.replaceDefaultMappingChoice();
        if (persistentAttributeType.isDefault()) {
            configurationElement = this.defaultConfigurationElementFor(this.persistentAttribute);
        } else {
            String flavorName = ((IPersistentAttributeFlavorModelAdapter)persistentAttributeType.getModelAdapter()).flavorName();
            configurationElement = this.configurationElementFor(flavorName);
        }
        IPersistenceComposite persistenceComposite = null;
        if (configurationElement != null) {
            this.persistentAttributeTypeCombo.setSelection((ISelection)new StructuredSelection((Object)configurationElement));
            IMappingCompositeBuilder mappingCompositeBuilder = null;
            try {
                mappingCompositeBuilder = (IMappingCompositeBuilder)configurationElement.createExecutableExtension("compositeClassBuilder");
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            persistenceComposite = mappingCompositeBuilder.buildMappingComposite((Composite)this.mappingPageBook, this.editingDomain, this.adapterFactory);
            if (this.visibleMappingComposite != null && this.visibleMappingComposite.getClass().equals(persistenceComposite.getClass())) {
                persistenceComposite = this.visibleMappingComposite;
            }
        } else {
            persistenceComposite = new NullMappingComposite((Composite)this.mappingPageBook);
            new EmptyComposite((Composite)this.mappingPageBook, "");
            this.persistentAttributeTypeCombo.setSelection(null);
        }
        if (this.visibleMappingComposite != null) {
            this.visibleMappingComposite.populate(null);
        }
        this.visibleMappingComposite = persistenceComposite;
        this.mappingPageBook.showPage((Control)this.visibleMappingComposite);
        this.visibleMappingComposite.populate((EObject)this.persistentAttribute);
    }

    private void replaceDefaultMappingChoice() {
        IConfigurationElement element = (IConfigurationElement)this.persistentAttributeTypeCombo.getElementAt(0);
        if (element.getDeclaringExtension().getExtensionPointUniqueIdentifier().equals("org.eclipse.dali.ui.defaultMappings")) {
            this.persistentAttributeTypeCombo.remove((Object)element);
        }
        if ((element = this.defaultConfigurationElementFor(this.persistentAttribute)) != null) {
            this.persistentAttributeTypeCombo.add((Object)element);
        }
    }

    private INotifyChangedListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(PersistentAttribute.class) == 1) {
                        PersistentAttributeFlavor persistentAttributeType = (PersistentAttributeFlavor)notification.getNewValue();
                        Display.getDefault().asyncExec(new Runnable(this, persistentAttributeType){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ PersistentAttributeFlavor val$persistentAttributeType;
                            {
                                this.this$1 = var1_1;
                                this.val$persistentAttributeType = persistentAttributeFlavor;
                            }

                            public void run() {
                                MappingComposite.access$1(4.access$0(this.this$1), this.val$persistentAttributeType);
                            }
                        });
                    }
                }

                static /* synthetic */ MappingComposite access$0(4 var0) {
                    return var0.MappingComposite.this;
                }
            };
        }
        return this.mappingListener;
    }

    private INotifyChangedListener getMappingTypeListener() {
        if (this.mappingTypeListener == null) {
            this.mappingTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    if (((ViewerNotification)notification).getElement() instanceof Basic && notification.getFeatureID(Basic.class) == 1) {
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                MappingComposite.access$1(6.access$0(this.this$1), MappingComposite.access$2(6.access$0(this.this$1)).getFlavor());
                            }
                        });
                    }
                }

                static /* synthetic */ MappingComposite access$0(6 var0) {
                    return var0.MappingComposite.this;
                }
            };
        }
        return this.mappingTypeListener;
    }

    public boolean setFocus() {
        super.setFocus();
        return this.persistentAttributeTypeCombo.getCombo().setFocus();
    }

    static /* synthetic */ void access$1(MappingComposite mappingComposite, PersistentAttributeFlavor persistentAttributeFlavor) {
        mappingComposite.populate(persistentAttributeFlavor);
    }

    static /* synthetic */ PersistentAttribute access$2(MappingComposite mappingComposite) {
        return mappingComposite.persistentAttribute;
    }
}

