/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.gemini.web.core.WebApplication;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.osgi.framework.Bundle;

final class WebAppClassLoaderDelegateHook
implements ClassLoaderDelegateHook {
    private static final Object DELEGATION_IN_PROGRESS_MARKER = new Object();
    private final ConcurrentHashMap<Bundle, ClassLoader> webAppClassLoaders = new ConcurrentHashMap();
    private final ThreadLocal<Object> delegationInProgress = new ThreadLocal();

    WebAppClassLoaderDelegateHook() {
    }

    void addWebApplication(WebApplication webApplication, Bundle bundle) {
        this.webAppClassLoaders.put(bundle, webApplication.getClassLoader());
    }

    void removeWebApplication(Bundle bundle) {
        this.webAppClassLoaders.remove(bundle);
    }

    public Class<?> postFindClass(String name, BundleClassLoader classLoader, BundleData data) throws ClassNotFoundException {
        block7: {
            if (this.delegationInProgress.get() == null) {
                try {
                    this.delegationInProgress.set(DELEGATION_IN_PROGRESS_MARKER);
                    ClassLoader webAppClassLoader = this.webAppClassLoaders.get(classLoader.getBundle());
                    if (webAppClassLoader == null) break block7;
                    try {
                        Class<?> clazz = webAppClassLoader.loadClass(name);
                        return clazz;
                    }
                    catch (Throwable throwable) {
                    }
                }
                finally {
                    this.delegationInProgress.set(null);
                }
            }
        }
        return null;
    }

    public String postFindLibrary(String name, BundleClassLoader classLoader, BundleData data) {
        return null;
    }

    public URL postFindResource(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        block7: {
            if (this.delegationInProgress.get() == null) {
                try {
                    this.delegationInProgress.set(DELEGATION_IN_PROGRESS_MARKER);
                    ClassLoader webAppClassLoader = this.webAppClassLoaders.get(classLoader.getBundle());
                    if (webAppClassLoader == null) break block7;
                    try {
                        URL uRL = webAppClassLoader.getResource(name);
                        return uRL;
                    }
                    catch (Throwable throwable) {
                    }
                }
                finally {
                    this.delegationInProgress.set(null);
                }
            }
        }
        return null;
    }

    public Enumeration<URL> postFindResources(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        block8: {
            if (this.delegationInProgress.get() == null) {
                try {
                    this.delegationInProgress.set(DELEGATION_IN_PROGRESS_MARKER);
                    ClassLoader webAppClassLoader = this.webAppClassLoaders.get(classLoader.getBundle());
                    if (webAppClassLoader == null) break block8;
                    try {
                        Enumeration<URL> resources = webAppClassLoader.getResources(name);
                        if (resources.hasMoreElements()) {
                            Enumeration<URL> enumeration = resources;
                            return enumeration;
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
                finally {
                    this.delegationInProgress.set(null);
                }
            }
        }
        return null;
    }

    public Class<?> preFindClass(String name, BundleClassLoader classLoader, BundleData data) throws ClassNotFoundException {
        return null;
    }

    public String preFindLibrary(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        return null;
    }

    public URL preFindResource(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        return null;
    }

    public Enumeration<URL> preFindResources(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        return null;
    }
}

