/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.bundle;

import java.io.File;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriver;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriverBundleListener;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriverManifestTransformer;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact;
import org.eclipse.virgo.kernel.osgi.framework.ManifestTransformer;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFramework;
import org.eclipse.virgo.kernel.osgi.framework.PackageAdminUtil;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.core.BundleStarter;
import org.eclipse.virgo.nano.core.BundleUtils;
import org.eclipse.virgo.nano.core.KernelException;
import org.eclipse.virgo.nano.core.Signal;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.Assert;
import org.eclipse.virgo.nano.shim.serviceability.TracingService;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;

final class StandardBundleDriver
implements BundleDriver {
    private static final String SYNTHETIC_CONTEXT_SUFFIX = "-synthetic.context";
    private final Object monitor = new Object();
    private final BundleStarter bundleStarter;
    private final TracingService tracingService;
    private final PackageAdminUtil packageAdminUtil;
    private final BundleContext bundleContext;
    private final OsgiFramework osgi;
    private final ArtifactStateMonitor artifactStateMonitor;
    private volatile BundleThreadContextManager threadContextManager;
    private volatile StandardBundleInstallArtifact installArtifact;
    private volatile BundleDriverBundleListener bundleListener;
    private Bundle bundle;
    private final String applicationTraceName;

    StandardBundleDriver(OsgiFramework osgiFramework, BundleContext bundleContext, BundleStarter bundleStarter, TracingService tracingService, PackageAdminUtil packageAdminUtil, String scopeName, ArtifactStateMonitor artifactStateMonitor) {
        this.osgi = osgiFramework;
        this.bundleContext = bundleContext;
        this.tracingService = tracingService;
        this.packageAdminUtil = packageAdminUtil;
        this.bundleStarter = bundleStarter;
        this.applicationTraceName = scopeName;
        this.artifactStateMonitor = artifactStateMonitor;
    }

    public void setInstallArtifact(StandardBundleInstallArtifact installArtifact) {
        this.installArtifact = installArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundle(Bundle bundle) {
        BundleDriverBundleListener bundleListener = null;
        Object object = this.monitor;
        synchronized (object) {
            if (this.bundle == null) {
                this.bundle = bundle;
                if (this.bundle != null) {
                    bundleListener = this.bundleListener = new BundleDriverBundleListener(this.installArtifact, this.bundle, this.artifactStateMonitor);
                }
            }
        }
        if (bundleListener != null) {
            this.bundleContext.addBundleListener(bundleListener);
        }
    }

    public void syncStart() throws KernelException {
        this.pushThreadContext();
        try {
            try {
                this.bundleStarter.start(this.obtainLocalBundle(), null);
            }
            catch (BundleException be) {
                throw new KernelException("BundleException", (Throwable)be);
            }
        }
        finally {
            this.popThreadContext();
        }
    }

    @Override
    public void pushThreadContext() {
        this.ensureThreadContextManager();
        this.threadContextManager.pushThreadContext();
    }

    @Override
    public void popThreadContext() {
        this.threadContextManager.popThreadContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureThreadContextManager() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.threadContextManager == null) {
                this.threadContextManager = new BundleThreadContextManager(this.osgi, this.getThreadContextBundle(), this.applicationTraceName, this.tracingService);
            }
        }
    }

    private Bundle getThreadContextBundle() {
        PlanInstallArtifact scopedAncestor;
        if (this.installArtifact != null && (scopedAncestor = this.installArtifact.getScopedAncestor()) != null) {
            String syntheticContextBundleSymbolicName = String.valueOf(this.installArtifact.getScopeName()) + SYNTHETIC_CONTEXT_SUFFIX;
            for (GraphNode scopedPlanChild : scopedAncestor.getGraph().getChildren()) {
                InstallArtifact scopedPlanChildArtifact = (InstallArtifact)scopedPlanChild.getValue();
                if (!(scopedPlanChildArtifact instanceof BundleInstallArtifact) || !syntheticContextBundleSymbolicName.equals(scopedPlanChildArtifact.getName())) continue;
                BundleInstallArtifact syntheticContextBundleArtifact = (BundleInstallArtifact)scopedPlanChildArtifact;
                return syntheticContextBundleArtifact.getBundle();
            }
        }
        return this.bundle;
    }

    @Override
    public void start(AbortableSignal signal) throws DeploymentException {
        block7: {
            Bundle bundle = this.obtainLocalBundle();
            if (!BundleUtils.isFragmentBundle((Bundle)bundle)) {
                this.pushThreadContext();
                try {
                    try {
                        this.startBundle(bundle, signal);
                        break block7;
                    }
                    catch (DeploymentException e) {
                        StandardBundleDriver.signalFailure((Signal)signal, e);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        StandardBundleDriver.signalFailure((Signal)signal, e);
                        throw e;
                    }
                }
                finally {
                    this.popThreadContext();
                }
            }
            StandardBundleDriver.signalSuccessfulCompletion((Signal)signal);
        }
    }

    private void startBundle(Bundle bundle, AbortableSignal signal) throws DeploymentException {
        this.bundleListener.addSolicitedStart(bundle);
        try {
            try {
                this.bundleStarter.start(bundle, signal);
            }
            catch (BundleException e) {
                throw new DeploymentException("BundleException", (Throwable)e);
            }
        }
        finally {
            this.bundleListener.removeSolicitedStart(bundle);
        }
    }

    protected static void signalFailure(Signal signal, Throwable e) {
        if (signal != null) {
            signal.signalFailure(e);
        }
    }

    private static void signalSuccessfulCompletion(Signal signal) {
        if (signal != null) {
            signal.signalSuccessfulCompletion();
        }
    }

    public void syncStart(int options) throws KernelException {
        Bundle bundle = this.obtainLocalBundle();
        if (!BundleUtils.isFragmentBundle((Bundle)bundle)) {
            this.pushThreadContext();
            try {
                try {
                    this.bundleStarter.start(this.obtainLocalBundle(), options, null);
                }
                catch (BundleException be) {
                    throw new KernelException("BundleException", (Throwable)be);
                }
            }
            finally {
                this.popThreadContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle obtainLocalBundle() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.bundle == null) {
                throw new IllegalStateException("bundle not set");
            }
            return this.bundle;
        }
    }

    @Override
    public boolean update(BundleManifest bundleManifest, File location) throws DeploymentException {
        this.updateBundle(bundleManifest, location);
        this.refreshBundle();
        return true;
    }

    private void updateBundle(BundleManifest bundleManifest, File location) throws DeploymentException {
        if (!StandardBundleDriver.isFragment(bundleManifest)) {
            Bundle bundle = this.obtainLocalBundle();
            Assert.isTrue((bundle.getState() == 2 || bundle.getState() == 4 ? 1 : 0) != 0, (String)"A bundle cannot be updated unless is in INSTALLED or RESOLVED state", (Object[])new Object[0]);
            try {
                this.osgi.update(bundle, (ManifestTransformer)new BundleDriverManifestTransformer(bundleManifest), location);
            }
            catch (BundleException e) {
                throw new DeploymentException("Failed to update bundle '" + bundle + "'.", (Throwable)e);
            }
        }
    }

    private static boolean isFragment(BundleManifest bundleManifest) {
        return bundleManifest.getFragmentHost().getBundleSymbolicName() != null;
    }

    @Override
    public void refreshBundle() throws DeploymentException {
        Bundle bundle = this.obtainLocalBundle();
        this.packageAdminUtil.synchronouslyRefreshPackages(new Bundle[]{bundle});
    }

    @Override
    public void stop() throws DeploymentException {
        this.pushThreadContext();
        try {
            try {
                this.obtainLocalBundle().stop();
            }
            catch (BundleException e) {
                throw new DeploymentException("stop failed", (Throwable)e);
            }
        }
        finally {
            this.popThreadContext();
        }
    }

    @Override
    public void uninstall() throws DeploymentException {
        Bundle bundle = this.obtainLocalBundle();
        this.pushThreadContext();
        try {
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                throw new DeploymentException("uninstall failed", (Throwable)e);
            }
        }
        finally {
            this.popThreadContext();
        }
        BundleDriverBundleListener localBundleListener = this.bundleListener;
        this.bundleListener = null;
        if (localBundleListener != null) {
            this.bundleContext.removeBundleListener((BundleListener)localBundleListener);
        }
        this.packageAdminUtil.synchronouslyRefreshPackages(new Bundle[]{bundle});
    }

    @Override
    public void trackStart(AbortableSignal signal) {
        this.bundleStarter.trackStart(this.obtainLocalBundle(), signal);
    }
}

