/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.interceptor.Interceptor;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorsManager {
    private List<Class<?>> enabledInterceptors = new CopyOnWriteArrayList();
    private final WebBeansContext webBeansContext;
    private final BeanManagerImpl manager;

    public InterceptorsManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.manager = webBeansContext.getBeanManagerImpl();
    }

    public void addNewInterceptor(Class<?> interceptorClazz) {
        Asserts.nullCheckForClass(interceptorClazz, "interceptorClazz can not be null");
        if (!this.enabledInterceptors.contains(interceptorClazz)) {
            this.enabledInterceptors.add(interceptorClazz);
        }
    }

    public int compare(Class<?> src, Class<?> target) {
        Asserts.assertNotNull(src, "src parameter can not be  null");
        Asserts.assertNotNull(target, "target parameter can not be null");
        int srcIndex = this.enabledInterceptors.indexOf(src);
        int targetIndex = this.enabledInterceptors.indexOf(target);
        if (srcIndex == -1 || targetIndex == -1) {
            throw new IllegalArgumentException("One of the compare class of the list : [" + src.getName() + "," + target.getName() + "]" + " is not contained in the enabled interceptors list!");
        }
        if (srcIndex == targetIndex) {
            return 0;
        }
        if (srcIndex < targetIndex) {
            return -1;
        }
        return 1;
    }

    public boolean isInterceptorEnabled(Class<?> interceptorClazz) {
        Asserts.nullCheckForClass(interceptorClazz, "interceptorClazz can not be null");
        return this.enabledInterceptors.contains(interceptorClazz);
    }

    public void validateInterceptorClasses() {
        for (Class<?> interceptorClass : this.enabledInterceptors) {
            AnnotatedType<?> annotatedType = this.webBeansContext.getAnnotatedElementFactory().getAnnotatedType(interceptorClass);
            if (annotatedType.isAnnotationPresent(Interceptor.class) || this.manager.containsCustomInterceptorClass(interceptorClass)) continue;
            throw new WebBeansConfigurationException("Given class : " + interceptorClass + " is not a interceptor class");
        }
    }
}

