/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.serviceability.dump.internal;

import java.io.File;
import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.virgo.kernel.serviceability.dump.internal.StateWriter;
import org.eclipse.virgo.kernel.serviceability.dump.internal.SystemStateAccessor;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.PathReference;
import org.eclipse.virgo.util.io.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResolutionStateDumper {
    private static final String ENTRY_NAME_STATE = "state/";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SystemStateAccessor systemStateAccessor;
    private final StateWriter stateWriter;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public ResolutionStateDumper(SystemStateAccessor systemStateAccessor, StateWriter stateWriter) {
        this.systemStateAccessor = systemStateAccessor;
        this.stateWriter = stateWriter;
    }

    public void dump(File outputFile) {
        try {
            ResolutionStateDumper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            this.dump(outputFile, this.systemStateAccessor.getSystemState());
            ResolutionStateDumper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ResolutionStateDumper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public void dump(File outputFile, State state) {
        try {
            block14: {
                ResolutionStateDumper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                File outdir = new File(this.getTmpDir(), "resolve-" + System.currentTimeMillis());
                if (outdir.mkdirs()) {
                    try {
                        this.stateWriter.writeState(state, outdir);
                    }
                    catch (IOException e) {
                        this.logger.error("Unable to write resolver state.", (Throwable)e);
                    }
                } else {
                    throw new RuntimeException("Unable to create temporary directory '" + outdir.getAbsolutePath() + "'.");
                }
                try {
                    try {
                        this.zipStateDirectory(outputFile, outdir);
                    }
                    catch (IOException e) {
                        this.logger.error("Unable to create ZIP of state dump", (Throwable)e);
                        if (!new PathReference(outdir).delete(true)) {
                            this.logger.warn("Temporary state directory '%s' was not removed after use.", (Object)outdir.getAbsolutePath());
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (!new PathReference(outdir).delete(true)) {
                        this.logger.warn("Temporary state directory '%s' was not removed after use.", (Object)outdir.getAbsolutePath());
                    }
                    throw throwable;
                }
                if (!new PathReference(outdir).delete(true)) {
                    this.logger.warn("Temporary state directory '%s' was not removed after use.", (Object)outdir.getAbsolutePath());
                }
            }
            ResolutionStateDumper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ResolutionStateDumper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void zipStateDirectory(File outputFile, File dumpDir) throws IOException {
        try {
            ResolutionStateDumper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            PathReference output = new PathReference(outputFile);
            PathReference toZip = new PathReference(dumpDir);
            ZipUtils.zipTo((PathReference)toZip, (PathReference)output, (String)ENTRY_NAME_STATE);
            ResolutionStateDumper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            ResolutionStateDumper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private String getTmpDir() {
        String path = System.getProperty("java.io.tmpdir");
        return path;
    }

    static {
        Factory factory = new Factory("ResolutionStateDumper.java", Class.forName("org.eclipse.virgo.kernel.serviceability.dump.internal.ResolutionStateDumper"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dump", "org.eclipse.virgo.kernel.serviceability.dump.internal.ResolutionStateDumper", "java.io.File:", "outputFile:", "", "void"), 58);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dump", "org.eclipse.virgo.kernel.serviceability.dump.internal.ResolutionStateDumper", "java.io.File:org.eclipse.osgi.service.resolver.State:", "outputFile:state:", "", "void"), 68);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "zipStateDirectory", "org.eclipse.virgo.kernel.serviceability.dump.internal.ResolutionStateDumper", "java.io.File:java.io.File:", "outputFile:dumpDir:", "java.io.IOException:", "void"), 91);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.serviceability.dump.internal.ResolutionStateDumper");
    }
}

