/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.kernel.artifact.ArtifactSpecification;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ArtifactIdentityScoper;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ScopeNameFactory;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.math.OrderedPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ParPlanInstallArtifact
extends StandardPlanInstallArtifact {
    private static final ArrayList<ArtifactSpecification> EMPTY_ARTIFACT_SPECIFICATION_LIST = new ArrayList();
    private static final String META_INF_PATH = "//META-INF";
    private final Object monitor = new Object();
    private final InstallArtifactGraphFactory bundleInstallArtifactGraphFactory;
    private final InstallArtifactGraphFactory configInstallArtifactGraphFactory;
    private final ArtifactStorageFactory artifactStorageFactory;
    private final ArtifactIdentityDeterminer artifactIdentityDeterminer;
    private final List<GraphNode<InstallArtifact>> childInstallArtifacts;
    private final InstallArtifactGraphFactory planInstallArtifactGraphFactory;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParPlanInstallArtifact.class);

    public ParPlanInstallArtifact(@NonNull ArtifactIdentity identity, @NonNull ArtifactStorage artifactStorage, @NonNull ArtifactStateMonitor artifactStateMonitor, @NonNull ScopeServiceRepository scopeServiceRepository, @NonNull ScopeFactory scopeFactory, @NonNull EventLogger eventLogger, @NonNull InstallArtifactGraphFactory bundleInstallArtifactGraphFactory, @NonNull InstallArtifactRefreshHandler refreshHandler, String repositoryName, @NonNull InstallArtifactGraphFactory configInstallArtifactGraphFactory, @NonNull ArtifactStorageFactory artifactStorageFactory, @NonNull ArtifactIdentityDeterminer artifactIdentityDeterminer, @NonNull InstallArtifactGraphFactory planInstallArtifactGraphFactory) throws DeploymentException {
        super(identity, true, true, PlanDescriptor.Provisioning.AUTO, artifactStorage, artifactStateMonitor, scopeServiceRepository, scopeFactory, eventLogger, refreshHandler, repositoryName, EMPTY_ARTIFACT_SPECIFICATION_LIST);
        this.artifactStorageFactory = artifactStorageFactory;
        this.configInstallArtifactGraphFactory = configInstallArtifactGraphFactory;
        this.bundleInstallArtifactGraphFactory = bundleInstallArtifactGraphFactory;
        this.planInstallArtifactGraphFactory = planInstallArtifactGraphFactory;
        this.artifactIdentityDeterminer = artifactIdentityDeterminer;
        List<OrderedPair<ArtifactIdentity, ArtifactFSEntry>> childArtifacts = this.findChildArtifacts(artifactStorage.getArtifactFS());
        this.childInstallArtifacts = this.createChildInstallArtifacts(childArtifacts);
    }

    private List<OrderedPair<ArtifactIdentity, ArtifactFSEntry>> findChildArtifacts(ArtifactFS artifactFS) throws DeploymentException {
        ArrayList<OrderedPair<ArtifactIdentity, ArtifactFSEntry>> childArtifacts = new ArrayList<OrderedPair<ArtifactIdentity, ArtifactFSEntry>>();
        ArtifactFSEntry entry = artifactFS.getEntry("/");
        ArtifactFSEntry[] children = entry.getChildren();
        if (children.length == 0) {
            throw new DeploymentException("Failed to find child artifacts in par " + artifactFS);
        }
        String scopeName = ScopeNameFactory.createScopeName(this.getName(), this.getVersion());
        ArtifactFSEntry[] artifactFSEntryArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactFSEntry child = artifactFSEntryArray[n2];
            String name = child.getPath();
            if (!META_INF_PATH.equals(name)) {
                ArtifactIdentity artifactIdentity = this.artifactIdentityDeterminer.determineIdentity(child.getArtifactFS().getFile(), scopeName);
                if (artifactIdentity != null) {
                    ArtifactIdentity scopedIdentity = ArtifactIdentityScoper.scopeArtifactIdentity(artifactIdentity);
                    childArtifacts.add((OrderedPair<ArtifactIdentity, ArtifactFSEntry>)new OrderedPair((Object)scopedIdentity, (Object)child));
                } else {
                    LOGGER.warn("Skipping entry " + name + " as it is not of a recognized type");
                }
            }
            ++n2;
        }
        return childArtifacts;
    }

    List<GraphNode<InstallArtifact>> createChildInstallArtifacts(List<OrderedPair<ArtifactIdentity, ArtifactFSEntry>> childArtifacts) throws DeploymentException {
        ArrayList<GraphNode<InstallArtifact>> childInstallArtifacts = new ArrayList<GraphNode<InstallArtifact>>();
        for (OrderedPair<ArtifactIdentity, ArtifactFSEntry> childArtifact : childArtifacts) {
            GraphNode<InstallArtifact> subGraph = null;
            ArtifactIdentity identity = (ArtifactIdentity)childArtifact.getFirst();
            ArtifactFSEntry artifactFs = (ArtifactFSEntry)childArtifact.getSecond();
            ArtifactStorage childArtifactStorage = this.createArtifactStorage(artifactFs, identity);
            if ("bundle".equals(identity.getType())) {
                subGraph = this.bundleInstallArtifactGraphFactory.constructInstallArtifactGraph(identity, childArtifactStorage, null, null);
            } else if ("configuration".equals(identity.getType())) {
                subGraph = this.configInstallArtifactGraphFactory.constructInstallArtifactGraph(identity, childArtifactStorage, null, null);
            } else if ("plan".equals(identity.getType())) {
                subGraph = this.planInstallArtifactGraphFactory.constructInstallArtifactGraph(identity, childArtifactStorage, null, null);
            }
            if (subGraph == null) {
                LOGGER.warn("Skipping " + identity + " as " + identity.getType() + " artifacts are not supported within a PAR");
                continue;
            }
            childInstallArtifacts.add(subGraph);
        }
        return childInstallArtifacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginInstall() throws DeploymentException {
        ArrayList<GraphNode<InstallArtifact>> children;
        super.beginInstall();
        Object object = this.monitor;
        synchronized (object) {
            children = new ArrayList<GraphNode<InstallArtifact>>(this.childInstallArtifacts);
        }
        for (GraphNode graphNode : children) {
            ((AbstractInstallArtifact)graphNode.getValue()).beginInstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGraph(GraphNode<InstallArtifact> graph) throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            super.setGraph(graph);
            List children = graph.getChildren();
            for (GraphNode<InstallArtifact> child : this.childInstallArtifacts) {
                if (ParPlanInstallArtifact.isChildPresent(children, child)) continue;
                graph.addChild(child);
            }
        }
    }

    private static boolean isChildPresent(List<GraphNode<InstallArtifact>> children, GraphNode<InstallArtifact> newChild) {
        InstallArtifact newChildValue = (InstallArtifact)newChild.getValue();
        for (GraphNode<InstallArtifact> child : children) {
            InstallArtifact childValue = (InstallArtifact)child.getValue();
            if (!ParPlanInstallArtifact.equalIdentities(childValue, newChildValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean equalIdentities(InstallArtifact ia1, InstallArtifact ia2) {
        ArtifactIdentity id1 = ((AbstractInstallArtifact)ia1).getIdentity();
        ArtifactIdentity id2 = ((AbstractInstallArtifact)ia2).getIdentity();
        return id1.equals(id2);
    }

    private ArtifactStorage createArtifactStorage(ArtifactFSEntry artifactFSEntry, ArtifactIdentity artifactIdentity) {
        ArtifactStorage innerStorage = this.artifactStorageFactory.create(artifactFSEntry.getArtifactFS().getFile(), artifactIdentity);
        ArtifactStorage outerStorage = this.artifactStorage;
        return new DelegatingArtifactStorage(innerStorage, outerStorage);
    }

    @Override
    public boolean refresh(String symbolicName) throws DeploymentException {
        return super.refresh(symbolicName);
    }

    @Override
    protected boolean doRefresh(String symbolicName) throws DeploymentException {
        InstallArtifact childToRefresh = this.findChild(symbolicName);
        if (childToRefresh == null) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_FAILED, new Object[]{symbolicName, this.getType(), this.getName(), this.getVersion()});
            throw new DeploymentException("Refresh failed: child '" + symbolicName + "' not found in " + this.getType() + "(" + this.getName() + ", " + this.getVersion() + ")");
        }
        return childToRefresh.refresh();
    }

    private InstallArtifact findChild(String symbolicName) {
        InstallArtifact childToRefresh = null;
        List children = this.getGraph().getChildren();
        for (GraphNode child : children) {
            InstallArtifact childInstallArtifact = (InstallArtifact)child.getValue();
            String childName = childInstallArtifact.getName();
            if (!childName.equals(symbolicName) && !childName.equals(String.valueOf(ScopeNameFactory.createScopeName(this.getName(), this.getVersion())) + "-" + symbolicName)) continue;
            childToRefresh = childInstallArtifact;
            break;
        }
        return childToRefresh;
    }

    private static final class DelegatingArtifactStorage
    implements ArtifactStorage {
        private final ArtifactStorage delegate;
        private final ArtifactStorage sourceStorage;

        private DelegatingArtifactStorage(ArtifactStorage delegate, ArtifactStorage sourceStorage) {
            this.delegate = delegate;
            this.sourceStorage = sourceStorage;
        }

        @Override
        public void delete() {
            this.delegate.delete();
        }

        @Override
        public ArtifactFS getArtifactFS() {
            return this.delegate.getArtifactFS();
        }

        @Override
        public void synchronize() {
            this.sourceStorage.synchronize();
            this.delegate.synchronize();
        }

        @Override
        public void synchronize(URI sourceUri) {
            this.delegate.synchronize(sourceUri);
        }

        @Override
        public void rollBack() {
            this.delegate.rollBack();
            this.sourceStorage.rollBack();
        }
    }
}

