/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.bundle.BasePackageHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleActivatorHeader;
import org.eclipse.pde.internal.core.text.bundle.FragmentHostHeader;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.BundleSourcePage;
import org.eclipse.pde.internal.ui.editor.text.JavaHyperlink;
import org.eclipse.pde.internal.ui.editor.text.ManifestElementHyperlink;
import org.eclipse.pde.internal.ui.editor.text.PackageHyperlink;
import org.eclipse.pde.internal.ui.editor.text.TranslationHyperlink;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportBundleHeader;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportLibraryHeader;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;

public class SpringBundleHyperlinkDetector
implements IHyperlinkDetector {
    private final PDESourcePage fSourcePage;

    public SpringBundleHyperlinkDetector(PDESourcePage page) {
        this.fSourcePage = page;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null) {
            return null;
        }
        IDocumentRange element = this.fSourcePage.getRangeElement(region.getOffset(), false);
        if (!(element instanceof ManifestHeader)) {
            return null;
        }
        ManifestHeader header = (ManifestHeader)element;
        if (!header.getModel().isEditable()) {
            return null;
        }
        String headerName = header.getName();
        if (region.getOffset() <= header.getOffset() + headerName.length()) {
            return null;
        }
        String[] translatable = ICoreConstants.TRANSLATABLE_HEADERS;
        int i = 0;
        while (i < translatable.length) {
            if (headerName.equals(translatable[i])) {
                String value = header.getValue();
                if (value == null || value.length() == 0 || value.charAt(0) != '%') break;
                IDocumentRange range = BundleSourcePage.getSpecificRange((IBundleModel)header.getModel(), (IManifestHeader)header, (String)value);
                return new IHyperlink[]{new TranslationHyperlink((IRegion)new Region(range.getOffset(), range.getLength()), value, (IModel)header.getModel())};
            }
            ++i;
        }
        if (header instanceof BundleActivatorHeader) {
            String target = ((BundleActivatorHeader)element).getClassName();
            if (target == null || target.length() == 0) {
                return null;
            }
            IDocumentRange range = BundleSourcePage.getSpecificRange((IBundleModel)header.getModel(), (IManifestHeader)header, (String)target);
            if (range == null) {
                return null;
            }
            return new IHyperlink[]{new JavaHyperlink((IRegion)new Region(range.getOffset(), range.getLength()), target, header.getModel().getUnderlyingResource())};
        }
        if (header instanceof BasePackageHeader || header instanceof RequireBundleHeader || header instanceof ImportBundleHeader || header instanceof ImportLibraryHeader || header instanceof FragmentHostHeader) {
            return this.matchLinkFor(header, region.getOffset());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IHyperlink[] matchLinkFor(ManifestHeader header, int mainOffset) {
        IDocument doc = ((IEditingModel)header.getModel()).getDocument();
        try {
            String version;
            String match;
            String value = doc.get(header.getOffset(), header.getLength());
            int offset = mainOffset - header.getOffset();
            if (offset >= value.length()) {
                return null;
            }
            char c = value.charAt(offset);
            if (!this.elementChar(c, true)) {
                return null;
            }
            int downOffset = offset;
            c = value.charAt(--downOffset);
            while (c != ',' && c != ':' && downOffset > 0) {
                if (c == ';') return null;
                if (!this.elementChar(c, false)) {
                    return null;
                }
                c = value.charAt(--downOffset);
            }
            while (downOffset < offset && !this.elementChar(c, true)) {
                c = value.charAt(++downOffset);
            }
            int upOffset = offset;
            c = value.charAt(upOffset);
            int length = value.length();
            while (c != ';' && c != ',' && upOffset < length - 1) {
                if (!this.elementChar(c, false)) {
                    return null;
                }
                c = value.charAt(++upOffset);
            }
            if (c == ';' || c == ',') {
                --upOffset;
            }
            if ((match = value.substring(downOffset, upOffset + 1)).length() <= 0) return null;
            Region region = new Region(mainOffset - (offset - downOffset), match.length());
            if (header instanceof BasePackageHeader) {
                return new IHyperlink[]{new PackageHyperlink((IRegion)region, match, (BasePackageHeader)header)};
            }
            if (!(header instanceof RequireBundleHeader) && !(header instanceof ImportBundleHeader)) {
                if (!(header instanceof FragmentHostHeader)) return null;
            }
            if ((version = value.substring(upOffset + 1)).startsWith(";version=\"")) {
                version = version.substring(10);
                int lastindex = version.indexOf(34);
                version = version.substring(0, lastindex);
                return new IHyperlink[]{new BundleHyperlink((IRegion)region, match, version)};
            } else {
                if (!version.startsWith(";bundle-version=\"")) return new IHyperlink[]{new BundleHyperlink((IRegion)region, match, version)};
                version = version.substring(17);
                int lastindex = version.indexOf(34);
                version = version.substring(0, lastindex);
            }
            return new IHyperlink[]{new BundleHyperlink((IRegion)region, match, version)};
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private boolean elementChar(char c, boolean noWhitespace) {
        if (noWhitespace && Character.isWhitespace(c)) {
            return false;
        }
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '.' || Character.isWhitespace(c);
    }

    private IProject getProject() {
        return ((PDEFormEditor)this.fSourcePage.getEditor()).getCommonProject();
    }

    public class BundleHyperlink
    extends ManifestElementHyperlink {
        private final String version;

        public BundleHyperlink(IRegion region, String pluginID, String version) {
            super(region, pluginID);
            this.version = version;
        }

        protected void open2() {
            BundleManifestEditor.openBundleEditor(this.fElement, this.version, SpringBundleHyperlinkDetector.this.getProject());
        }
    }
}

