/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestOutlinePage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportBundleHeader;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportBundleObject;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportLibraryHeader;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportLibraryObject;

public class BundleManifestOutlinePage
extends ManifestOutlinePage {
    public BundleManifestOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    protected Object[] getChildren(Object parent) {
        PDEFormPage page;
        IBundleModel model;
        if (parent instanceof PDEFormPage && (model = this.getBundleModel(page = (PDEFormPage)parent)) != null && model.isValid()) {
            IBundle bundle = model.getBundle();
            if (page.getId().equals("bundle_dependencies")) {
                ArrayList<Object> list = new ArrayList<Object>();
                ImportPackageHeader packageHeader = (ImportPackageHeader)bundle.getManifestHeader("Import-Package");
                ImportBundleHeader bundleHeader = (ImportBundleHeader)bundle.getManifestHeader("Import-Bundle");
                ImportLibraryHeader libraryHeader = (ImportLibraryHeader)bundle.getManifestHeader("Import-Library");
                if (packageHeader != null && !packageHeader.isEmpty()) {
                    list.addAll(Arrays.asList(packageHeader.getPackages()));
                }
                if (bundleHeader != null && !bundleHeader.isEmpty()) {
                    list.addAll(Arrays.asList(bundleHeader.getImportedBundles()));
                }
                if (libraryHeader != null && !libraryHeader.isEmpty()) {
                    list.addAll(Arrays.asList(libraryHeader.getImportedLibraries()));
                }
                return list.toArray();
            }
        }
        return super.getChildren(parent);
    }

    protected String getParentPageId(Object item) {
        String pageId = null;
        if (item instanceof ImportPackageObject || item instanceof ImportBundleObject || item instanceof ImportLibraryObject) {
            pageId = "bundle_dependencies";
        }
        if (pageId != null) {
            return pageId;
        }
        return super.getParentPageId(item);
    }

    private IBundleModel getBundleModel(PDEFormPage page) {
        BundleInputContext context;
        InputContextManager manager = page.getPDEEditor().getContextManager();
        if (manager != null && (context = (BundleInputContext)manager.findContext("bundle-context")) != null) {
            return (IBundleModel)context.getModel();
        }
        return null;
    }

    public ILabelProvider createLabelProvider() {
        return new BasicLabelProvider(this){

            public String getText(Object obj) {
                if (obj instanceof ImportLibraryObject) {
                    return ((ImportLibraryObject)obj).getId();
                }
                if (obj instanceof ImportBundleObject) {
                    return ((ImportBundleObject)obj).getId();
                }
                return super.getText(obj);
            }

            public Image getImage(Object obj) {
                PDELabelProvider labelProvider = PDEPlugin.getDefault().getLabelProvider();
                if (obj instanceof ImportLibraryObject) {
                    return labelProvider.get(PDEPluginImages.DESC_JAR_LIB_OBJ);
                }
                if (obj instanceof ImportBundleObject) {
                    return labelProvider.get(PDEPluginImages.DESC_BUNDLE_OBJ);
                }
                return super.getImage(obj);
            }
        };
    }

    public class BasicLabelProvider
    extends LabelProvider {
        public String getText(Object obj) {
            if (obj instanceof IFormPage) {
                return ((IFormPage)obj).getTitle();
            }
            return PDEPlugin.getDefault().getLabelProvider().getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof IFormPage) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PAGE_OBJ);
            }
            return PDEPlugin.getDefault().getLabelProvider().getImage(obj);
        }
    }
}

