/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServerOptionsConverter;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;

@DataObject(generateConverter=true)
public class HttpServerOptions
extends NetServerOptions {
    public static final int DEFAULT_PORT = 80;
    public static final boolean DEFAULT_COMPRESSION_SUPPORTED = false;
    public static final int DEFAULT_MAX_WEBSOCKET_FRAME_SIZE = 65536;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final boolean DEFAULT_HANDLE_100_CONTINE_AUTOMATICALLY = false;
    private boolean compressionSupported;
    private int maxWebsocketFrameSize;
    private String websocketSubProtocols;
    private boolean handle100ContinueAutomatically;
    private int maxChunkSize;
    private int maxInitialLineLength;
    private int maxHeaderSize;

    public HttpServerOptions() {
        this.init();
        this.setPort(80);
    }

    public HttpServerOptions(HttpServerOptions other) {
        super(other);
        this.compressionSupported = other.isCompressionSupported();
        this.maxWebsocketFrameSize = other.getMaxWebsocketFrameSize();
        this.websocketSubProtocols = other.getWebsocketSubProtocols();
        this.handle100ContinueAutomatically = other.handle100ContinueAutomatically;
        this.maxChunkSize = other.getMaxChunkSize();
        this.maxInitialLineLength = other.getMaxInitialLineLength();
        this.maxHeaderSize = other.getMaxHeaderSize();
    }

    public HttpServerOptions(JsonObject json) {
        super(json);
        this.init();
        this.setPort(json.getInteger("port", 80));
        HttpServerOptionsConverter.fromJson(json, this);
    }

    private void init() {
        this.compressionSupported = false;
        this.maxWebsocketFrameSize = 65536;
        this.handle100ContinueAutomatically = false;
        this.maxChunkSize = 8192;
        this.maxInitialLineLength = 4096;
        this.maxHeaderSize = 8192;
    }

    @Override
    public HttpServerOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public HttpServerOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public HttpServerOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public HttpServerOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public HttpServerOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public HttpServerOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public HttpServerOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public HttpServerOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    @Override
    public HttpServerOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public HttpServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public HttpServerOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    @Override
    public HttpServerOptions setPfxKeyCertOptions(PfxOptions options) {
        return (HttpServerOptions)super.setPfxKeyCertOptions(options);
    }

    @Override
    public HttpServerOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (HttpServerOptions)super.setPemKeyCertOptions(options);
    }

    @Override
    public HttpServerOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    @Override
    public HttpServerOptions setPemTrustOptions(PemTrustOptions options) {
        return (HttpServerOptions)super.setPemTrustOptions(options);
    }

    @Override
    public HttpServerOptions setPfxTrustOptions(PfxOptions options) {
        return (HttpServerOptions)super.setPfxTrustOptions(options);
    }

    @Override
    public HttpServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public HttpServerOptions addCrlPath(String crlPath) throws NullPointerException {
        return (HttpServerOptions)super.addCrlPath(crlPath);
    }

    @Override
    public HttpServerOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (HttpServerOptions)super.addCrlValue(crlValue);
    }

    @Override
    public HttpServerOptions setAcceptBacklog(int acceptBacklog) {
        super.setAcceptBacklog(acceptBacklog);
        return this;
    }

    @Override
    public HttpServerOptions setPort(int port) {
        super.setPort(port);
        return this;
    }

    @Override
    public HttpServerOptions setHost(String host) {
        super.setHost(host);
        return this;
    }

    @Override
    @Deprecated
    public HttpServerOptions setClientAuthRequired(boolean clientAuthRequired) {
        super.setClientAuthRequired(clientAuthRequired);
        return this;
    }

    @Override
    public HttpServerOptions setClientAuth(ClientAuth clientAuth) {
        super.setClientAuth(clientAuth);
        return this;
    }

    public boolean isCompressionSupported() {
        return this.compressionSupported;
    }

    public HttpServerOptions setCompressionSupported(boolean compressionSupported) {
        this.compressionSupported = compressionSupported;
        return this;
    }

    public int getMaxWebsocketFrameSize() {
        return this.maxWebsocketFrameSize;
    }

    public HttpServerOptions setMaxWebsocketFrameSize(int maxWebsocketFrameSize) {
        this.maxWebsocketFrameSize = maxWebsocketFrameSize;
        return this;
    }

    public HttpServerOptions setWebsocketSubProtocols(String subProtocols) {
        this.websocketSubProtocols = subProtocols;
        return this;
    }

    public String getWebsocketSubProtocols() {
        return this.websocketSubProtocols;
    }

    public boolean isHandle100ContinueAutomatically() {
        return this.handle100ContinueAutomatically;
    }

    public HttpServerOptions setHandle100ContinueAutomatically(boolean handle100ContinueAutomatically) {
        this.handle100ContinueAutomatically = handle100ContinueAutomatically;
        return this;
    }

    public HttpServerOptions setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public HttpServerOptions setMaxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public HttpServerOptions setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpServerOptions that = (HttpServerOptions)o;
        if (this.compressionSupported != that.compressionSupported) {
            return false;
        }
        if (this.maxWebsocketFrameSize != that.maxWebsocketFrameSize) {
            return false;
        }
        if (this.handle100ContinueAutomatically != that.handle100ContinueAutomatically) {
            return false;
        }
        if (this.maxChunkSize != that.maxChunkSize) {
            return false;
        }
        if (this.maxInitialLineLength != that.maxInitialLineLength) {
            return false;
        }
        if (this.maxHeaderSize != that.maxHeaderSize) {
            return false;
        }
        return !(this.websocketSubProtocols == null ? that.websocketSubProtocols != null : !this.websocketSubProtocols.equals(that.websocketSubProtocols));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.compressionSupported ? 1 : 0);
        result = 31 * result + this.maxWebsocketFrameSize;
        result = 31 * result + (this.websocketSubProtocols != null ? this.websocketSubProtocols.hashCode() : 0);
        result = 31 * result + (this.handle100ContinueAutomatically ? 1 : 0);
        result = 31 * result + this.maxChunkSize;
        result = 31 * result + this.maxInitialLineLength;
        result = 31 * result + this.maxHeaderSize;
        return result;
    }
}

