/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VoidHandler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.HttpServerRequestImpl;
import io.vertx.core.http.impl.HttpServerResponseImpl;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.VertxNetHandler;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Queue;

class ServerConnection
extends ConnectionBase {
    private static final Logger log = LoggerFactory.getLogger(ServerConnection.class);
    private static final int CHANNEL_PAUSE_QUEUE_SIZE = 5;
    public static final String HANDLE_100_CONTINUE_PROP_NAME = "vertx.handle100Continue";
    private static final boolean HANDLE_100_CONTINUE = Boolean.getBoolean("vertx.handle100Continue");
    private final Queue<Object> pending = new ArrayDeque<Object>(8);
    private final String serverOrigin;
    private final HttpServerImpl server;
    private WebSocketServerHandshaker handshaker;
    private final HttpServerMetrics metrics;
    private Object requestMetric;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<ServerWebSocket> wsHandler;
    private HttpServerRequestImpl currentRequest;
    private HttpServerResponseImpl pendingResponse;
    private ServerWebSocketImpl ws;
    private ChannelFuture lastWriteFuture;
    private boolean channelPaused;
    private boolean paused;
    private boolean sentCheck;
    private long bytesRead;
    private long bytesWritten;
    private Object metric;

    ServerConnection(VertxInternal vertx, HttpServerImpl server, Channel channel, ContextImpl context, String serverOrigin, WebSocketServerHandshaker handshaker, HttpServerMetrics metrics) {
        super(vertx, channel, context, metrics);
        this.serverOrigin = serverOrigin;
        this.server = server;
        this.handshaker = handshaker;
        this.metrics = metrics;
    }

    @Override
    protected synchronized Object metric() {
        return this.metric;
    }

    synchronized void setMetric(Object metric) {
        this.metric = metric;
    }

    public synchronized void pause() {
        if (!this.paused) {
            this.paused = true;
        }
    }

    public synchronized void resume() {
        if (this.paused) {
            this.paused = false;
            this.checkNextTick();
        }
    }

    synchronized void handleMessage(Object msg) {
        if (this.paused || this.pendingResponse != null && msg instanceof HttpRequest || !this.pending.isEmpty()) {
            this.pending.add(msg);
            if (this.pending.size() == 5) {
                super.doPause();
                this.channelPaused = true;
            }
        } else {
            this.processMessage(msg);
        }
    }

    synchronized void responseComplete() {
        if (this.metrics.isEnabled()) {
            this.reportBytesWritten(this.bytesWritten);
            this.bytesWritten = 0L;
            this.metrics.responseEnd(this.requestMetric, this.pendingResponse);
        }
        this.pendingResponse = null;
        this.checkNextTick();
    }

    synchronized void requestHandler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
    }

    synchronized void wsHandler(Handler<ServerWebSocket> handler) {
        this.wsHandler = handler;
    }

    String getServerOrigin() {
        return this.serverOrigin;
    }

    Vertx vertx() {
        return this.vertx;
    }

    @Override
    public ChannelFuture writeToChannel(Object obj) {
        if (this.metrics.isEnabled()) {
            long bytes = this.getBytes(obj);
            if (bytes == -1L) {
                log.warn("Metrics could not be updated to include bytes written because of unknown object " + obj.getClass() + " being written.");
            } else {
                this.bytesWritten += bytes;
            }
        }
        this.lastWriteFuture = super.writeToChannel(obj);
        return this.lastWriteFuture;
    }

    ServerWebSocket upgrade(HttpServerRequest request, HttpRequest nettyReq) {
        if (this.ws != null) {
            return this.ws;
        }
        this.handshaker = this.server.createHandshaker(this.channel, nettyReq);
        if (this.handshaker == null) {
            throw new IllegalStateException("Can't upgrade this request");
        }
        this.ws = new ServerWebSocketImpl(this.vertx, request.uri(), request.path(), request.query(), request.headers(), this, this.handshaker.version() != WebSocketVersion.V00, null, this.server.options().getMaxWebsocketFrameSize());
        try {
            this.handshaker.handshake(this.channel, nettyReq);
        }
        catch (WebSocketHandshakeException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            log.error("Failed to generate shake response", e);
        }
        ChannelHandler handler = this.channel.pipeline().get(HttpChunkContentCompressor.class);
        if (handler != null) {
            this.channel.pipeline().remove(handler);
        }
        this.server.connectionMap().put(this.channel, this);
        return this.ws;
    }

    boolean isSSL() {
        return this.server.getSslHelper().isSSL();
    }

    NetSocket createNetSocket() {
        NetSocketImpl socket = new NetSocketImpl(this.vertx, this.channel, this.context, this.server.getSslHelper(), false, this.metrics, this.metric);
        HashMap<Channel, NetSocketImpl> connectionMap = new HashMap<Channel, NetSocketImpl>(1);
        connectionMap.put(this.channel, socket);
        this.endReadAndFlush();
        ChannelPipeline pipeline = this.channel.pipeline();
        ChannelHandler compressor = pipeline.get(HttpChunkContentCompressor.class);
        if (compressor != null) {
            pipeline.remove(compressor);
        }
        pipeline.remove("httpDecoder");
        if (pipeline.get("chunkedWriter") != null) {
            pipeline.remove("chunkedWriter");
        }
        this.channel.pipeline().replace("handler", "handler", (ChannelHandler)new VertxNetHandler(connectionMap){

            @Override
            public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) throws Exception {
                ServerConnection.this.server.removeChannel(ServerConnection.this.channel);
                super.exceptionCaught(chctx, t);
            }

            @Override
            public void channelInactive(ChannelHandlerContext chctx) throws Exception {
                ServerConnection.this.server.removeChannel(ServerConnection.this.channel);
                super.channelInactive(chctx);
            }

            @Override
            public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
                if (msg instanceof HttpContent) {
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
                super.channelRead(chctx, msg);
            }
        });
        if (this.lastWriteFuture == null) {
            this.channel.pipeline().remove("httpEncoder");
        } else {
            this.lastWriteFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ServerConnection.this.channel.pipeline().remove("httpEncoder");
                }
            });
        }
        return socket;
    }

    private void handleRequest(HttpServerRequestImpl req, HttpServerResponseImpl resp) {
        this.currentRequest = req;
        this.pendingResponse = resp;
        this.requestMetric = this.metrics.requestBegin(this.metric, req);
        if (this.requestHandler != null) {
            this.requestHandler.handle(req);
        }
    }

    private void handleChunk(Buffer chunk) {
        if (this.metrics.isEnabled()) {
            this.bytesRead += (long)chunk.length();
        }
        this.currentRequest.handleData(chunk);
    }

    private void handleEnd() {
        this.currentRequest.handleEnd();
        this.reportBytesRead(this.bytesRead);
        this.currentRequest = null;
        this.bytesRead = 0L;
    }

    @Override
    public synchronized void handleInterestedOpsChanged() {
        if (!this.isNotWritable()) {
            if (this.pendingResponse != null) {
                this.pendingResponse.handleDrained();
            } else if (this.ws != null) {
                this.ws.writable();
            }
        }
    }

    @Override
    public void close() {
        if (this.handshaker == null) {
            super.close();
        } else {
            this.endReadAndFlush();
            this.handshaker.close(this.channel, new CloseWebSocketFrame(1000, null));
        }
    }

    synchronized void handleWebsocketConnect(ServerWebSocketImpl ws) {
        if (this.wsHandler != null) {
            this.wsHandler.handle(ws);
            this.ws = ws;
        }
    }

    private synchronized void handleWsFrame(WebSocketFrameInternal frame) {
        if (this.ws != null) {
            this.ws.handleFrame(frame);
        }
    }

    @Override
    protected synchronized void handleClosed() {
        if (this.ws != null) {
            this.metrics.disconnected(this.ws.metric);
            this.ws.metric = null;
        }
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
        if (this.pendingResponse != null) {
            this.pendingResponse.handleClosed();
        }
    }

    @Override
    protected ContextImpl getContext() {
        return super.getContext();
    }

    @Override
    protected synchronized void handleException(Throwable t) {
        super.handleException(t);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(t);
        }
        if (this.pendingResponse != null) {
            this.pendingResponse.handleException(t);
        }
        if (this.ws != null) {
            this.ws.handleException(t);
        }
    }

    @Override
    protected void addFuture(Handler<AsyncResult<Void>> completionHandler, ChannelFuture future) {
        super.addFuture(completionHandler, future);
    }

    @Override
    protected boolean supportsFileRegion() {
        return super.supportsFileRegion() && this.channel.pipeline().get(HttpChunkContentCompressor.class) == null;
    }

    @Override
    protected ChannelFuture sendFile(RandomAccessFile file, long fileLength) throws IOException {
        return super.sendFile(file, fileLength);
    }

    private void processMessage(Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            DecoderResult result = ((HttpObject)msg).getDecoderResult();
            if (result.isFailure()) {
                this.channel.pipeline().fireExceptionCaught(result.cause());
                return;
            }
            if (HANDLE_100_CONTINUE && HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
                this.channel.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            HttpServerResponseImpl resp = new HttpServerResponseImpl(this.vertx, this, request);
            HttpServerRequestImpl req = new HttpServerRequestImpl(this, request, resp);
            this.handleRequest(req, resp);
        }
        if (msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            if (chunk.content().isReadable()) {
                Buffer buff = Buffer.buffer(chunk.content());
                this.handleChunk(buff);
            }
            if (msg instanceof LastHttpContent) {
                if (!this.paused) {
                    this.handleEnd();
                } else {
                    this.pending.add(LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        } else if (msg instanceof WebSocketFrameInternal) {
            WebSocketFrameInternal frame = (WebSocketFrameInternal)msg;
            this.handleWsFrame(frame);
        }
        this.checkNextTick();
    }

    private void checkNextTick() {
        if (!(this.pending.isEmpty() || this.sentCheck || this.paused || this.pendingResponse != null && !(this.pending.peek() instanceof HttpContent))) {
            this.sentCheck = true;
            this.vertx.runOnContext(new VoidHandler(){

                @Override
                public void handle() {
                    ServerConnection.this.sentCheck = false;
                    if (!ServerConnection.this.paused) {
                        Object msg = ServerConnection.this.pending.poll();
                        if (msg != null) {
                            ServerConnection.this.processMessage(msg);
                        }
                        if (ServerConnection.this.channelPaused && ServerConnection.this.pending.isEmpty()) {
                            ServerConnection.super.doResume();
                            ServerConnection.this.channelPaused = false;
                        }
                    }
                }
            });
        }
    }

    private long getBytes(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Buffer) {
            return ((Buffer)obj).length();
        }
        if (obj instanceof ByteBuf) {
            return ((ByteBuf)obj).readableBytes();
        }
        if (obj instanceof HttpContent) {
            return ((HttpContent)obj).content().readableBytes();
        }
        if (obj instanceof WebSocketFrame) {
            return ((WebSocketFrame)obj).binaryData().length();
        }
        if (obj instanceof FileRegion) {
            return ((FileRegion)obj).count();
        }
        if (obj instanceof ChunkedFile) {
            ChunkedFile file = (ChunkedFile)obj;
            return file.endOffset() - file.startOffset();
        }
        return -1L;
    }
}

