/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import java.util.UUID;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.sockjs.SockJSSocket;

public abstract class SockJSSocketBase
implements SockJSSocket {
    private final Handler<Message<Buffer>> writeHandler;
    protected final Vertx vertx;
    private final String writeHandlerID;

    protected SockJSSocketBase(Vertx vertx) {
        this.vertx = vertx;
        this.writeHandler = new Handler<Message<Buffer>>(){

            @Override
            public void handle(Message<Buffer> buff) {
                SockJSSocketBase.this.write(buff.body());
            }
        };
        this.writeHandlerID = UUID.randomUUID().toString();
        vertx.eventBus().registerLocalHandler(this.writeHandlerID, this.writeHandler);
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public void close() {
        this.vertx.eventBus().unregisterHandler(this.writeHandlerID, this.writeHandler);
    }
}

