/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVMEventHandlerUtils;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVirtualMachineStateProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.VMKernelEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class StateDumpContainerHandler
extends VMKernelEventHandler {
    private static final String TID_FIELD = "tid";
    private static final String VTID_FIELD = "vtid";
    private static final String PID_FIELD = "pid";
    private static final String VPID_FIELD = "vpid";
    private static final String PPID_FIELD = "ppid";
    private static final String VPPID_FIELD = "vppid";
    private static final String NAME_FIELD = "name";
    private static final String STATUS_FIELD = "status";
    private static final String NS_LEVEL_FIELD = "ns_level";
    private static final String NS_INUM_FIELD = "ns_inum";

    public StateDumpContainerHandler(IKernelAnalysisEventLayout layout, FusedVirtualMachineStateProvider sp) {
        super(layout, sp);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) {
        int layerNode = StateDumpContainerHandler.createLevels(ss, event);
        if (layerNode != -2) {
            StateDumpContainerHandler.fillLevel(ss, event, layerNode);
        }
    }

    public static int createLevels(ITmfStateSystemBuilder ss, ITmfEvent event) {
        int threadNode;
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        ITmfEventField content = event.getContent();
        Long tid = (Long)content.getFieldValue(Long.class, new String[]{TID_FIELD});
        Long vtid = (Long)content.getFieldValue(Long.class, new String[]{VTID_FIELD});
        Long nsLevel = (Long)content.getFieldValue(Long.class, new String[]{NS_LEVEL_FIELD});
        if (tid == null || vtid == null || nsLevel == null) {
            return -2;
        }
        long ts = event.getTimestamp().getValue();
        String hostId = event.getTrace().getHostId();
        String threadAttributeName = FusedVMEventHandlerUtils.buildThreadAttributeName(tid.intValue(), cpu);
        if (threadAttributeName == null) {
            return -2;
        }
        int layerQuark = threadNode = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getNodeThreads(ss), new String[]{hostId, threadAttributeName});
        int i = 0;
        while ((long)i < nsLevel) {
            layerQuark = ss.getQuarkRelativeAndAdd(layerQuark, new String[]{"VTID"});
            if ((long)(i + 1) == nsLevel) {
                ss.modifyAttribute(ts, (Object)vtid.intValue(), layerQuark);
            }
            ss.getQuarkRelativeAndAdd(layerQuark, new String[]{"VPPID"});
            int quark = ss.getQuarkRelativeAndAdd(layerQuark, new String[]{NS_LEVEL_FIELD});
            if (ss.queryOngoingState(quark).isNull()) {
                ss.modifyAttribute(ts, (Object)(i + 1), quark);
            }
            ++i;
        }
        return layerQuark;
    }

    public static void fillLevel(ITmfStateSystemBuilder ss, ITmfEvent event, int layerNode) {
        Long childNSInum;
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().getValue();
        String hostId = event.getTrace().getHostId();
        Long tid = (Long)content.getFieldValue(Long.class, new String[]{TID_FIELD});
        Long pid = (Long)content.getFieldValue(Long.class, new String[]{PID_FIELD});
        Long ppid = (Long)content.getFieldValue(Long.class, new String[]{PPID_FIELD});
        Long status = (Long)content.getFieldValue(Long.class, new String[]{STATUS_FIELD});
        String name = (String)content.getFieldValue(String.class, new String[]{NAME_FIELD});
        Long vtid = (Long)content.getFieldValue(Long.class, new String[]{VTID_FIELD});
        Long vpid = (Long)content.getFieldValue(Long.class, new String[]{VPID_FIELD});
        Long vppid = (Long)content.getFieldValue(Long.class, new String[]{VPPID_FIELD});
        Long nsLevel = (Long)content.getFieldValue(Long.class, new String[]{NS_LEVEL_FIELD});
        Long nsInum = (Long)content.getFieldValue(Long.class, new String[]{NS_INUM_FIELD});
        if (tid == null || pid == null || ppid == null || status == null || name == null || vtid == null || vpid == null || vppid == null || nsLevel == null || nsInum == null) {
            return;
        }
        String threadAttributeName = FusedVMEventHandlerUtils.buildThreadAttributeName(tid.intValue(), cpu);
        if (threadAttributeName == null) {
            return;
        }
        int threadNode = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getNodeThreads(ss), new String[]{hostId, threadAttributeName});
        int quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"ns_max_level"});
        if (ss.queryOngoingState(quark).isNull()) {
            ss.modifyAttribute(ts, (Object)(nsLevel.intValue() + 1), quark);
        }
        int maxLevel = ss.queryOngoingState(quark).unboxInt();
        quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Status"});
        int processStatus = 0;
        if (ss.queryOngoing(quark) == null) {
            switch (status.intValue()) {
                case 2: {
                    processStatus = 5;
                    break;
                }
                case 5: {
                    processStatus = 6;
                    break;
                }
                default: {
                    processStatus = 0;
                }
            }
            ss.modifyAttribute(ts, (Object)processStatus, quark);
        }
        if (ss.queryOngoing(quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Exec_name"})) == null) {
            ss.modifyAttribute(ts, (Object)name, quark);
        }
        String attributePpid = "PPID";
        if (nsLevel != 0L) {
            attributePpid = "VPPID";
        }
        if (ss.queryOngoing(quark = ss.getQuarkRelativeAndAdd(layerNode, new String[]{attributePpid})) == null) {
            int setPpid;
            int setVppid;
            if (vpid.equals(vtid)) {
                setVppid = vppid.intValue();
                setPpid = ppid.intValue();
            } else {
                setVppid = vpid.intValue();
                setPpid = pid.intValue();
            }
            ss.modifyAttribute(ts, (Object)setVppid, quark);
            if (nsLevel != 0L && ss.queryOngoing(quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"PPID"})) == null) {
                ss.modifyAttribute(ts, (Object)setPpid, quark);
            }
        }
        if (ss.queryOngoingState(quark = ss.getQuarkRelativeAndAdd(layerNode, new String[]{NS_LEVEL_FIELD})).isNull()) {
            ss.modifyAttribute(ts, (Object)nsLevel.intValue(), quark);
        }
        if (ss.queryOngoingState(quark = ss.getQuarkRelativeAndAdd(layerNode, new String[]{NS_INUM_FIELD})).isNull()) {
            ss.modifyAttribute(ts, (Object)nsInum, quark);
        }
        quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getMachinesNode(ss), new String[]{hostId, "Containers", Long.toString(nsInum)});
        quark = ss.getQuarkRelativeAndAdd(quark, new String[]{"Threads", String.valueOf(tid)});
        ss.modifyAttribute(ts, (Object)vtid.intValue(), quark);
        if (nsLevel != (long)(maxLevel - 1) && (childNSInum = Long.valueOf(ss.queryOngoingState(quark = ss.getQuarkRelativeAndAdd(layerNode, new String[]{"VTID", NS_INUM_FIELD})).unboxLong())) > 0L) {
            quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getMachinesNode(ss), new String[]{hostId, "Containers", Long.toString(childNSInum), "Parent"});
            ss.modifyAttribute(ss.getStartTime(), (Object)nsInum, quark);
        }
        if (nsLevel == 0L) {
            quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getMachinesNode(ss), new String[]{hostId, "Containers", Long.toString(nsInum), "Parent"});
            ss.modifyAttribute(ss.getStartTime(), (Object)-1L, quark);
        }
    }
}

