/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;

class CollectFileOverviewVisibility
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final ImmutableMap.Builder<StaticSourceFile, JSDocInfo.Visibility> builder = ImmutableMap.builder();

    CollectFileOverviewVisibility(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node script = root.getFirstChild(); script != null; script = script.getNext()) {
            Preconditions.checkState((boolean)script.isScript());
            this.visit(script);
        }
    }

    private void visit(Node scriptNode) {
        JSDocInfo jsDocInfo = scriptNode.getJSDocInfo();
        if (jsDocInfo == null) {
            return;
        }
        JSDocInfo.Visibility v = jsDocInfo.getVisibility();
        if (v == null) {
            return;
        }
        this.builder.put((Object)scriptNode.getStaticSourceFile(), (Object)v);
    }

    ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> getFileOverviewVisibilityMap() {
        return this.builder.build();
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.compiler.process(this);
    }
}

