/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.AllGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraph;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraphGroupBy;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.ICalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.FlameGraphContentProvider;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.FlameGraphPresentationProvider;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.SortOption;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.ui.symbols.SymbolProviderConfigDialog;
import org.eclipse.tracecompass.tmf.ui.symbols.TmfSymbolProviderUpdatedSignal;
import org.eclipse.tracecompass.tmf.ui.views.SaveImageUtil;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

@NonNullByDefault(value={})
public class FlameGraphView
extends TmfView {
    public static final String ID = String.valueOf(FlameGraphView.class.getPackage().getName()) + ".flamegraphView";
    private static final String SYMBOL_MAPPING_ICON_PATH = "icons/obj16/binaries_obj.gif";
    private static final @NonNull String GROUP_BY_ICON_PATH = "icons/etool16/group_by.gif";
    private static final String SORT_OPTION_KEY = "sort.option";
    private static final ImageDescriptor SORT_BY_NAME_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha.gif");
    private static final ImageDescriptor SORT_BY_NAME_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha_rev.gif");
    private static final ImageDescriptor SORT_BY_ID_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num.gif");
    private static final ImageDescriptor SORT_BY_ID_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num_rev.gif");
    private static final ImageDescriptor AGGREGATE_BY_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/group_by.gif");
    private TimeGraphViewer fTimeGraphViewer;
    private FlameGraphContentProvider fTimeGraphContentProvider;
    private TimeGraphPresentationProvider fPresentationProvider;
    private ITmfTrace fTrace;
    private static final @NonNull Logger LOGGER = Logger.getLogger(FlameGraphView.class.getName());
    private final @NonNull MenuManager fEventMenuManager = new MenuManager();
    private Action fAggregateByAction;
    private Action fSortByNameAction;
    private Action fSortByIdAction;
    private Action fConfigureSymbolsAction;
    private final Multimap<ITmfTrace, ISymbolProvider> fSymbolProviders = LinkedHashMultimap.create();
    private @Nullable ICallStackGroupDescriptor fGroupBy = null;
    private final Semaphore fLock = new Semaphore(1);
    private final AtomicInteger fDirty = new AtomicInteger();
    private Job fJob;

    public FlameGraphView() {
        super(ID);
    }

    protected FlameGraphView(String id) {
        super(id);
    }

    public void createPartControl(Composite parent) {
        ITmfTrace trace;
        super.createPartControl(parent);
        this.fTimeGraphViewer = new TimeGraphViewer(parent, 0);
        this.fTimeGraphContentProvider = new FlameGraphContentProvider();
        this.fPresentationProvider = new FlameGraphPresentationProvider();
        this.fTimeGraphViewer.setTimeGraphContentProvider((ITimeGraphContentProvider)this.fTimeGraphContentProvider);
        this.fTimeGraphViewer.setTimeGraphProvider((ITimeGraphPresentationProvider)this.fPresentationProvider);
        this.fTimeGraphViewer.setTimeFormat(Utils.TimeFormat.NUMBER);
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        this.contributeToActionBars();
        this.loadSortOption();
        TmfSignalManager.register((Object)((Object)this));
        this.getSite().setSelectionProvider(this.fTimeGraphViewer.getSelectionProvider());
        this.createTimeEventContextMenu();
        this.fTimeGraphViewer.getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TimeGraphControl timeGraphControl = FlameGraphView.this.getTimeGraphViewer().getTimeGraphControl();
                ISelection selection = timeGraphControl.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object object : ((IStructuredSelection)selection).toList()) {
                        if (!(object instanceof FlamegraphEvent)) continue;
                        FlamegraphEvent event = (FlamegraphEvent)((Object)object);
                        long startTime = event.getTime();
                        long endTime = startTime + event.getDuration();
                        FlameGraphView.this.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                        break;
                    }
                }
            }
        });
    }

    @VisibleForTesting
    public TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphViewer;
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.fTrace = signal.getTrace();
        Display.getDefault().asyncExec(() -> this.buildFlameGraph(this.getCallgraphModules(), null, null));
    }

    protected Iterable<ICallGraphProvider> getCallgraphModules() {
        ITmfTrace trace = this.fTrace;
        if (trace == null) {
            return null;
        }
        String analysisId = NonNullUtils.nullToEmptyString((Object)this.getViewSite().getSecondaryId());
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ICallGraphProvider.class);
        return StreamSupport.stream(modules.spliterator(), false).filter(m -> {
            if (m instanceof IAnalysisModule) {
                return ((IAnalysisModule)m).getId().equals(analysisId);
            }
            return true;
        }).collect(Collectors.toSet());
    }

    @VisibleForTesting
    public void buildFlameGraph(final Iterable<ICallGraphProvider> callGraphProviders, final @Nullable ITmfTimestamp selStart, final @Nullable ITmfTimestamp selEnd) {
        Job job = this.fJob;
        if (job != null) {
            job.cancel();
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (final TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:Building", new Object[0]).setCategory(this.getViewId()).build();){
            Collection symbolProviders;
            try {
                this.fLock.acquire();
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError(e.getMessage(), e);
                this.fLock.release();
            }
            ITmfTrace trace = this.fTrace;
            if (trace != null && (symbolProviders = this.fSymbolProviders.get((Object)trace)).isEmpty()) {
                symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(trace);
                symbolProviders.forEach(provider -> provider.loadConfiguration((IProgressMonitor)new NullProgressMonitor()));
                this.fSymbolProviders.putAll((Object)trace, (Iterable)symbolProviders);
            }
            if (!callGraphProviders.iterator().hasNext()) {
                this.fTimeGraphViewer.setInput(null);
                this.fLock.release();
                return;
            }
            for (ICallGraphProvider provider2 : callGraphProviders) {
                if (!(provider2 instanceof IAnalysisModule)) continue;
                ((IAnalysisModule)provider2).schedule();
            }
            job = new Job(Messages.FlameGraphView_RetrievingData){

                protected IStatus run(IProgressMonitor monitor) {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (TraceCompassLogUtils.FlowScopeLog runLog = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:GettingFlameGraphs", new Object[0]).setParentScope(log).build();){
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        FlameGraphView.this.fDirty.incrementAndGet();
                        FlameGraphView.this.fLock.release();
                        HashSet<CallGraph> callgraphs = new HashSet<CallGraph>();
                        ICallStackGroupDescriptor group = FlameGraphView.this.fGroupBy;
                        for (ICallGraphProvider provider : callGraphProviders) {
                            if (provider instanceof IAnalysisModule) {
                                ((IAnalysisModule)provider).waitForCompletion(monitor);
                            }
                            CallGraph callGraph = selStart == null || selEnd == null ? provider.getCallGraph() : provider.getCallGraph(selStart, selEnd);
                            if (group == null) {
                                callgraphs.add(callGraph);
                                continue;
                            }
                            callgraphs.add(CallGraphGroupBy.groupCallGraphBy((ICallStackGroupDescriptor)group, (CallGraph)callGraph));
                        }
                        if (monitor.isCanceled()) {
                            FlameGraphView.this.fDirty.decrementAndGet();
                            return Status.CANCEL_STATUS;
                        }
                        Display.getDefault().asyncExec(() -> {
                            try {
                                Throwable throwable = null;
                                Object var4_5 = null;
                                try (TraceCompassLogUtils.FlowScopeLog asyncLog = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:SettingInput", new Object[0]).setParentScope(runLog).build();){
                                    FlameGraphView.this.fTimeGraphViewer.setInput((Object)callgraphs);
                                    FlameGraphView.this.fTimeGraphViewer.resetStartFinishTime();
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            finally {
                                FlameGraphView.this.fDirty.decrementAndGet();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            };
            IWorkbenchSiteProgressService service = null;
            IWorkbenchPartSite site = this.getSite();
            if (site != null) {
                service = (IWorkbenchSiteProgressService)site.getService(IWorkbenchSiteProgressService.class);
            }
            this.fJob = job;
            if (service != null) {
                service.schedule(job);
            } else {
                job.schedule();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    public boolean isDirty() throws InterruptedException {
        this.fLock.acquire();
        this.fLock.release();
        return this.fDirty.get() != 0;
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            this.fTimeGraphViewer.setInput(null);
        }
    }

    public void setFocus() {
        this.fTimeGraphViewer.setFocus();
    }

    private void createTimeEventContextMenu() {
        this.fEventMenuManager.setRemoveAllWhenShown(true);
        final TimeGraphControl timeGraphControl = this.fTimeGraphViewer.getTimeGraphControl();
        final Menu timeEventMenu = this.fEventMenuManager.createContextMenu((Control)timeGraphControl);
        timeGraphControl.addTimeGraphEntryMenuListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                timeGraphControl.setMenu(null);
                event.doit = false;
            }
        });
        timeGraphControl.addTimeEventMenuListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                Menu menu = timeEventMenu;
                if (event.data instanceof FlamegraphEvent) {
                    timeGraphControl.setMenu(menu);
                    return;
                }
                timeGraphControl.setMenu(null);
                event.doit = false;
            }
        });
        this.fEventMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FlameGraphView.this.fillTimeEventContextMenu((IMenuManager)FlameGraphView.this.fEventMenuManager);
                FlameGraphView.this.fEventMenuManager.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        this.getSite().registerContextMenu(this.fEventMenuManager, this.fTimeGraphViewer.getSelectionProvider());
    }

    protected void fillTimeEventContextMenu(@NonNull IMenuManager menuManager) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object object : ((IStructuredSelection)selection).toList()) {
                ICalledFunction minSeg;
                if (!(object instanceof FlamegraphEvent)) continue;
                FlamegraphEvent flamegraphEvent = (FlamegraphEvent)((Object)object);
                final ICalledFunction maxSeg = flamegraphEvent.getMaxObject();
                if (maxSeg != null) {
                    menuManager.add((IAction)new Action(Messages.FlameGraphView_GotoMaxDuration){

                        public void run() {
                            TmfSelectionRangeUpdatedSignal sig = new TmfSelectionRangeUpdatedSignal((Object)this, TmfTimestamp.fromNanos((long)maxSeg.getStart()), TmfTimestamp.fromNanos((long)maxSeg.getEnd()), FlameGraphView.this.fTrace);
                            FlameGraphView.this.broadcast((TmfSignal)sig);
                        }
                    });
                }
                if ((minSeg = flamegraphEvent.getMinObject()) == null) continue;
                menuManager.add((IAction)new Action(Messages.FlameGraphView_GotoMinDuration){

                    public void run() {
                        TmfSelectionRangeUpdatedSignal sig = new TmfSelectionRangeUpdatedSignal((Object)this, TmfTimestamp.fromNanos((long)minSeg.getStart()), TmfTimestamp.fromNanos((long)minSeg.getEnd()), FlameGraphView.this.fTrace);
                        FlameGraphView.this.broadcast((TmfSignal)sig);
                    }
                });
            }
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.getConfigureSymbolsAction());
        manager.add((IAction)this.getAggregateByAction());
        manager.add((IAction)this.getSortByNameAction());
        manager.add((IAction)this.getSortByIdAction());
        manager.add((IContributionItem)new Separator());
    }

    private Action getAggregateByAction() {
        if (this.fAggregateByAction == null) {
            this.fAggregateByAction = new Action(Messages.FlameGraphView_GroupByName, 4){

                public void run() {
                    SortOption sortOption = FlameGraphView.this.fTimeGraphContentProvider.getSortOption();
                    if (sortOption == SortOption.BY_NAME) {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME_REV);
                    } else {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME);
                    }
                }
            };
            this.fAggregateByAction.setToolTipText(Messages.FlameGraphView_GroupByTooltip);
            this.fAggregateByAction.setImageDescriptor(AGGREGATE_BY_ICON);
            this.fAggregateByAction.setMenuCreator(new IMenuCreator(){
                Menu menu = null;

                public void dispose() {
                    if (this.menu != null) {
                        this.menu.dispose();
                        this.menu = null;
                    }
                }

                public Menu getMenu(Control parent) {
                    if (this.menu != null) {
                        this.menu.dispose();
                    }
                    this.menu = new Menu(parent);
                    Iterable<ICallGraphProvider> callgraphModules = FlameGraphView.this.getCallgraphModules();
                    Iterator<ICallGraphProvider> iterator = callgraphModules.iterator();
                    if (!iterator.hasNext()) {
                        return this.menu;
                    }
                    ICallGraphProvider provider = iterator.next();
                    Action allGroupAction = FlameGraphView.this.createActionForGroup(provider, AllGroupDescriptor.getInstance());
                    new ActionContributionItem((IAction)allGroupAction).fill(this.menu, -1);
                    Collection series = provider.getGroupDescriptors();
                    series.forEach(group -> {
                        ICallStackGroupDescriptor subGroup = group;
                        do {
                            Action groupAction = FlameGraphView.this.createActionForGroup(provider, subGroup);
                            new ActionContributionItem((IAction)groupAction).fill(this.menu, -1);
                        } while ((subGroup = subGroup.getNextGroup()) != null);
                    });
                    return this.menu;
                }

                public Menu getMenu(Menu parent) {
                    return null;
                }
            });
        }
        return this.fAggregateByAction;
    }

    private Action createActionForGroup(final ICallGraphProvider provider, final ICallStackGroupDescriptor descriptor) {
        return new Action(descriptor.getName(), 8){

            public void run() {
                FlameGraphView.this.fGroupBy = descriptor;
                FlameGraphView.this.buildFlameGraph(Collections.singleton(provider), null, null);
            }
        };
    }

    private Action getSortByNameAction() {
        if (this.fSortByNameAction == null) {
            this.fSortByNameAction = new Action(Messages.FlameGraph_SortByThreadName, 2){

                public void run() {
                    SortOption sortOption = FlameGraphView.this.fTimeGraphContentProvider.getSortOption();
                    if (sortOption == SortOption.BY_NAME) {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME_REV);
                    } else {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME);
                    }
                }
            };
            this.fSortByNameAction.setToolTipText(Messages.FlameGraph_SortByThreadName);
            this.fSortByNameAction.setImageDescriptor(SORT_BY_NAME_ICON);
        }
        return this.fSortByNameAction;
    }

    private Action getSortByIdAction() {
        if (this.fSortByIdAction == null) {
            this.fSortByIdAction = new Action(Messages.FlameGraph_SortByThreadId, 2){

                public void run() {
                    SortOption sortOption = FlameGraphView.this.fTimeGraphContentProvider.getSortOption();
                    if (sortOption == SortOption.BY_ID) {
                        FlameGraphView.this.setSortOption(SortOption.BY_ID_REV);
                    } else {
                        FlameGraphView.this.setSortOption(SortOption.BY_ID);
                    }
                }
            };
            this.fSortByIdAction.setToolTipText(Messages.FlameGraph_SortByThreadId);
            this.fSortByIdAction.setImageDescriptor(SORT_BY_ID_ICON);
        }
        return this.fSortByIdAction;
    }

    private Action getConfigureSymbolsAction() {
        if (this.fConfigureSymbolsAction != null) {
            return this.fConfigureSymbolsAction;
        }
        this.fConfigureSymbolsAction = new Action(Messages.FlameGraphView_ConfigureSymbolProvidersText){

            public void run() {
                SymbolProviderConfigDialog dialog = new SymbolProviderConfigDialog(FlameGraphView.this.getSite().getShell(), FlameGraphView.this.getProviderPages());
                dialog.open();
            }
        };
        this.fConfigureSymbolsAction.setToolTipText(Messages.FlameGraphView_ConfigureSymbolProvidersTooltip);
        this.fConfigureSymbolsAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(SYMBOL_MAPPING_ICON_PATH));
        this.fConfigureSymbolsAction.setEnabled(true);
        return this.fConfigureSymbolsAction;
    }

    private ISymbolProviderPreferencePage[] getProviderPages() {
        ArrayList<ISymbolProviderPreferencePage> pages = new ArrayList<ISymbolProviderPreferencePage>();
        ITmfTrace trace = this.fTrace;
        if (trace != null) {
            for (ITmfTrace subTrace : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                for (ISymbolProvider provider : SymbolProviderManager.getInstance().getSymbolProviders(subTrace)) {
                    org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider provider2;
                    ISymbolProviderPreferencePage page;
                    if (!(provider instanceof org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider) || (page = (provider2 = (org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider)provider).createPreferencePage()) == null) continue;
                    pages.add(page);
                }
            }
        }
        return pages.toArray(new ISymbolProviderPreferencePage[pages.size()]);
    }

    private void setSortOption(SortOption sortOption) {
        this.getSortByNameAction().setChecked(false);
        this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_ICON);
        this.getSortByIdAction().setChecked(false);
        this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_ICON);
        if (sortOption.equals((Object)SortOption.BY_NAME)) {
            this.fTimeGraphContentProvider.setSortOption(SortOption.BY_NAME);
            this.getSortByNameAction().setChecked(true);
        } else if (sortOption.equals((Object)SortOption.BY_NAME_REV)) {
            this.fTimeGraphContentProvider.setSortOption(SortOption.BY_NAME_REV);
            this.getSortByNameAction().setChecked(true);
            this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_REV_ICON);
        } else if (sortOption.equals((Object)SortOption.BY_ID)) {
            this.fTimeGraphContentProvider.setSortOption(SortOption.BY_ID);
            this.getSortByIdAction().setChecked(true);
        } else if (sortOption.equals((Object)SortOption.BY_ID_REV)) {
            this.fTimeGraphContentProvider.setSortOption(SortOption.BY_ID_REV);
            this.getSortByIdAction().setChecked(true);
            this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_REV_ICON);
        }
        this.saveSortOption();
        this.fTimeGraphViewer.refresh();
    }

    private void saveSortOption() {
        SortOption sortOption = this.fTimeGraphContentProvider.getSortOption();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        section.put(SORT_OPTION_KEY, sortOption.name());
    }

    private void loadSortOption() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            return;
        }
        String sortOption = section.get(SORT_OPTION_KEY);
        if (sortOption == null) {
            return;
        }
        this.setSortOption(SortOption.fromName(sortOption));
    }

    @TmfSignalHandler
    public void symbolMapUpdated(TmfSymbolProviderUpdatedSignal signal) {
        this.fTimeGraphViewer.refresh();
    }

    protected @Nullable IAction createSaveAction() {
        return SaveImageUtil.createSaveAction((String)this.getName(), this::getTimeGraphViewer);
    }
}

