/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.util.Collection;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractPartitionAction;

public class GroupingAction
extends AbstractPartitionAction {
    private final TracePart part;

    public GroupingAction(TraceView view, TracePart part) {
        super(view);
        this.part = part;
        this.setText(String.valueOf(part.toString().toLowerCase()) + " grouping");
    }

    public boolean isEnabled() {
        if (!this.viewCfg.isActivityView()) {
            return false;
        }
        switch (this.part) {
            case CLAIM: {
                return this.view.hasClaims(true);
            }
            case EVENT: {
                return this.view.hasEvents(false, true);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected TracePart getPart() {
        return this.part;
    }

    @Override
    protected String getDialogMessage() {
        return "Select the attributes for grouping the swimlanes";
    }

    @Override
    protected Collection<String> getSelectedAttributes() throws TraceException {
        return this.viewCfg.getGroupingAttributes(this.part);
    }

    @Override
    protected void updateSelection(Collection<String> newSelection) throws TraceException {
        this.viewCfg.setGroupingAttributes(this.part, newSelection);
    }
}

