/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import java.util.Map;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.impl.AttributeAware;
import org.eclipse.trace4cps.core.impl.ClaimEvent;

public class Claim
extends AttributeAware
implements IClaim {
    private final Number startTime;
    private final Number endTime;
    private final IResource resource;
    private final Number offset;
    private final Number amount;
    private final ClaimEvent startEvent;
    private final ClaimEvent stopEvent;

    public Claim(double t0, double t1, IResource r, Number amount) {
        this(t0, t1, r, Double.NaN, amount, null);
    }

    public Claim(double t0, double t1, IResource r, Number amount, Map<String, String> attMap) {
        this(t0, t1, r, Double.NaN, amount, attMap);
    }

    public Claim(Number t0, Number t1, IResource r, Number offset, Number amount) {
        this(t0, t1, r, offset, amount, null);
    }

    public Claim(Number t0, Number t1, IResource r, Number offset, Number amount, Map<String, String> attMap) {
        this.startTime = t0;
        this.endTime = t1;
        this.resource = r;
        if (r.useOffset() && Double.isNaN(offset.doubleValue()) || !r.useOffset() && !Double.isNaN(offset.doubleValue())) {
            throw new IllegalArgumentException("offset must be specified if and only if the resource uses an offset");
        }
        this.offset = offset;
        this.amount = amount;
        if (this.startTime.doubleValue() > this.endTime.doubleValue()) {
            throw new IllegalArgumentException("start time cannot be larger than end time");
        }
        if (offset.doubleValue() + amount.doubleValue() > r.getCapacity().doubleValue()) {
            throw new IllegalArgumentException("offset + amount cannot be larger than resource capacity");
        }
        this.setAttributes(attMap);
        this.startEvent = new ClaimEvent(this.startTime, this, ClaimEventType.START);
        this.stopEvent = new ClaimEvent(this.endTime, this, ClaimEventType.END);
    }

    @Override
    public Number getStartTime() {
        return this.startTime;
    }

    @Override
    public Number getEndTime() {
        return this.endTime;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public Number getOffset() {
        return this.offset;
    }

    @Override
    public Number getAmount() {
        return this.amount;
    }

    @Override
    public IClaimEvent getStartEvent() {
        return this.startEvent;
    }

    @Override
    public IClaimEvent getEndEvent() {
        return this.stopEvent;
    }

    @Override
    public String toString() {
        return "Claim[" + this.startTime + "-" + this.endTime + ", amount=" + this.amount + ", offset=" + this.offset + ", resoure=" + this.resource + ", attributes=" + this.getAttributes() + "]";
    }
}

