/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.ui.internal.themes.AbstractThemeManager;
import org.eclipse.tm4e.ui.internal.themes.WorkingCopyThemeManager;
import org.eclipse.tm4e.ui.internal.utils.PreferenceUtils;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.Theme;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;
import org.osgi.service.prefs.BackingStoreException;

public final class ThemeManager
extends AbstractThemeManager {
    private static final String EXTENSION_THEMES = "themes";
    private static final String THEME_ELT = "theme";
    private static final String THEME_ASSOCIATION_ELT = "themeAssociation";

    public static ThemeManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener themeChangeListener) {
        IEclipsePreferences prefs = PreferenceUtils.getE4ThemesPreferenceStore();
        if (prefs != null) {
            prefs.addPreferenceChangeListener(themeChangeListener);
        }
        if ((prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui")) != null) {
            prefs.addPreferenceChangeListener(themeChangeListener);
        }
    }

    public static void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener themeChangeListener) {
        IEclipsePreferences prefs = PreferenceUtils.getE4ThemesPreferenceStore();
        if (prefs != null) {
            prefs.removePreferenceChangeListener(themeChangeListener);
        }
        if ((prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui")) != null) {
            prefs.removePreferenceChangeListener(themeChangeListener);
        }
    }

    private ThemeManager() {
    }

    private void load() {
        this.loadThemesFromExtensionPoints();
        this.loadThemesFromPreferences();
    }

    private void loadThemesFromExtensionPoints() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.ui", EXTENSION_THEMES);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            switch (elem.getName()) {
                case "theme": {
                    super.registerTheme(new Theme(elem));
                    break;
                }
                case "themeAssociation": {
                    super.registerThemeAssociation(new ThemeAssociation(elem));
                }
            }
            ++n2;
        }
    }

    private void loadThemesFromPreferences() {
        int n;
        String json = TMUIPlugin.getPreference("org.eclipse.tm4e.ui.themes", null);
        if (json != null) {
            JsonObject[] jsonObjectArray = (JsonObject[])new Gson().fromJson(json, JsonObject[].class);
            n = jsonObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                JsonObject jsonElem = jsonObjectArray[n2];
                String name = jsonElem.get("id").getAsString();
                super.registerTheme(new Theme(name, jsonElem.get("path").getAsString(), name, jsonElem.get("dark").getAsBoolean()));
                ++n2;
            }
        }
        if ((json = TMUIPlugin.getPreference("org.eclipse.tm4e.ui.themeAssociations", null)) != null) {
            IThemeAssociation[] themeAssociations;
            IThemeAssociation[] iThemeAssociationArray = themeAssociations = PreferenceHelper.loadThemeAssociations(json);
            int n3 = themeAssociations.length;
            n = 0;
            while (n < n3) {
                IThemeAssociation association = iThemeAssociationArray[n];
                super.registerThemeAssociation(association);
                ++n;
            }
        }
        this.defaultDarkThemeId = TMUIPlugin.getPreference("org.eclipse.tm4e.ui.themes.defaultDarkTheme", null);
        this.defaultLightThemeId = TMUIPlugin.getPreference("org.eclipse.tm4e.ui.themes.defaultLightTheme", null);
    }

    void save() throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui");
        prefs.put("org.eclipse.tm4e.ui.themes", Arrays.stream(this.getThemes()).filter(t -> t.getPluginId() == null).map(theme -> {
            JsonObject json = new JsonObject();
            json.addProperty("id", theme.getId());
            json.addProperty("path", theme.getPath());
            json.addProperty("dark", Boolean.valueOf(theme.isDark()));
            return json;
        }).collect(JsonArray::new, JsonArray::add, (r, r1) -> {}).toString());
        String json = PreferenceHelper.toJsonThemeAssociations(Arrays.stream(this.getAllThemeAssociations()).filter(t -> t.getPluginId() == null).toList());
        prefs.put("org.eclipse.tm4e.ui.themeAssociations", json);
        if (this.defaultDarkThemeId != null) {
            prefs.put("org.eclipse.tm4e.ui.themes.defaultDarkTheme", this.defaultDarkThemeId);
        } else {
            prefs.remove("org.eclipse.tm4e.ui.themes.defaultDarkTheme");
        }
        if (this.defaultLightThemeId != null) {
            prefs.put("org.eclipse.tm4e.ui.themes.defaultLightTheme", this.defaultLightThemeId);
        } else {
            prefs.remove("org.eclipse.tm4e.ui.themes.defaultLightTheme");
        }
        prefs.flush();
    }

    @Override
    public IThemeManager.EditSession newEditSession() {
        return new WorkingCopyThemeManager(this);
    }

    private static final class InstanceHolder {
        static final ThemeManager INSTANCE = new ThemeManager();

        static {
            INSTANCE.load();
        }

        private InstanceHolder() {
        }
    }
}

