/********************************************************************************
 * Copyright (c) 2007 IBM Corporation. All rights reserved.
 * This program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Initial Contributors:
 * The following IBM employees contributed to the Remote System Explorer
 * component that contains this file: David McKnight.
 * 
 * Contributors:
 * {Name} (company) - description of contribution.
 ********************************************************************************/
package org.eclipsecon.tmtutorial.nm;

import java.util.List;

import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipsecon.tmtutorial.Activator;

public class SymbolDialog extends SystemPromptDialog {

	protected class SymbolTableContentProvider implements
			IStructuredContentProvider, ITableLabelProvider 
	{
		private Image _localsymbolImage;
		private Image _symbolImage;
		
		public SymbolTableContentProvider()
		{
			_localsymbolImage = Activator.imageDescriptorFromPlugin("org.eclipsecon.tmtutorial", "icons/obj16/symbol_local_obj.gif").createImage();
			_symbolImage = Activator.imageDescriptorFromPlugin("org.eclipsecon.tmtutorial", "icons/obj16/symbol_obj.gif").createImage();
		}
		
		/**
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {
		}

		/**
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(Viewer,
		 *      Object, Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}

		/**
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(Object)
		 */
		public Object[] getElements(Object inputElement) {
			return _symbols.toArray();
		}

		/**
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(Object,
		 *      int)
		 */
		public Image getColumnImage(Object element, int columnIndex) 
		{
			if (columnIndex == 0)
			{
				Symbol symbol = (Symbol)element;
				String type = symbol.getType();
				char c = type.charAt(0);
				boolean isUpper = Character.isUpperCase(c);
				
				if (isUpper)
				{
					return _symbolImage;
				}
				else
				{
					return _localsymbolImage;
				}
			}
			else
			{
				
			}
			
			return null;
		}

		/**
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(Object,
		 *      int)
		 */
		public String getColumnText(Object element, int columnIndex) {
			if (columnIndex == 0) {
				return ((Symbol) element).getValue();
			} else {
				return ((Symbol) element).getType();
			}
		}

		/**
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(ILabelProviderListener)
		 */
		public void addListener(ILabelProviderListener listener) {
		}

		/**
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(Object,
		 *      String)
		 */
		public boolean isLabelProperty(Object element, String property) {
			return false;
		}

		/**
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(ILabelProviderListener)
		 */
		public void removeListener(ILabelProviderListener listener) {
		}

		

	}

	private List _symbols;
	private TableViewer _viewer;

	public SymbolDialog(Shell shell, List symbols) {
		super(shell, "Symbols");
		_symbols = symbols;
	}

	protected Control createInner(Composite parent) {

		Table table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.BORDER | SWT.HIDE_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		TableLayout tableLayout = new TableLayout();
		tableLayout.addColumnData(new ColumnWeightData(300, true));
		tableLayout.addColumnData(new ColumnWeightData(100, true));
		table.setLayout(tableLayout);

		_viewer = new TableViewer(table);

		parent.setLayoutData(new GridData(GridData.FILL_BOTH));

		GridData gd = new GridData(GridData.FILL_BOTH);
	    gd.grabExcessHorizontalSpace = true;
		gd.grabExcessVerticalSpace = true;		  
		gd.heightHint = 200;
		gd.widthHint = 350;
		table.setLayoutData(gd);
		
		// Name column
		TableColumn valueColumn = new TableColumn(table, SWT.NONE);
		valueColumn.setText("Value");

		// Value column
		TableColumn typeColumn = new TableColumn(table, SWT.NONE);
		typeColumn.setText("Type");

		SymbolTableContentProvider provider = new SymbolTableContentProvider();
		_viewer.setContentProvider(provider);
		_viewer.setLabelProvider(provider);
		displaySymbols();

		return _viewer.getControl();
	}

	protected void displaySymbols() {
		for (int i = 0; i < _symbols.size(); i++) {
			Symbol symbol = (Symbol) _symbols.get(i);
			_viewer.add(symbol);
		}
	}

	protected Control getInitialFocusControl() {
		return _viewer.getControl();
	}

}
