/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LinkerFlagsOptionsData {
    public static final String USE_GOLD_LINKER_PROPERTY = "useGoldLinker";
    public static final String FREE_TEXT_OPTIONS_PROPERTY = "freeTextLinkerOptions";
    public static final String[] PROPERTIES = new String[]{"useGoldLinker", "freeTextLinkerOptions"};
    public static final String[] TAGS = PROPERTIES;
    public static final String[] DEFAULT_VALUES = new String[]{"false", ""};

    private LinkerFlagsOptionsData() {
    }

    public static String getLinkerFlags(IProject project) {
        StringBuilder builder = new StringBuilder(30);
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", USE_GOLD_LINKER_PROPERTY));
            builder.append("true".equals(temp) ? "-fuse-ld=gold " : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", FREE_TEXT_OPTIONS_PROPERTY));
            builder.append(temp);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting Linker options of `" + project.getName() + "'"), (Throwable)e);
        }
        return builder.toString();
    }

    public static void removeTITANAttributes(IProject project) {
        for (int i = 0; i < PROPERTIES.length; ++i) {
            try {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]), null);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While removing attributes of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void loadMakefileSettings(Node root, IProject project) {
        int i;
        NodeList resourceList = root.getChildNodes();
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            String name = resourceList.item(i).getNodeName();
            for (int j = 0; j < TAGS.length; ++j) {
                if (!TAGS[j].equals(name)) continue;
                newValues[j] = resourceList.item(i).getTextContent();
            }
        }
        for (i = 0; i < TAGS.length; ++i) {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]);
            try {
                String oldValue = project.getPersistentProperty(qualifiedName);
                if (newValues[i] == null || newValues[i].equals(oldValue)) continue;
                project.setPersistentProperty(qualifiedName, newValues[i]);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading tag `" + TAGS[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void saveMakefileSettings(Element makefileSettings, Document document, IProject project) {
        for (int i = 0; i < TAGS.length; ++i) {
            try {
                String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]));
                if (temp == null || DEFAULT_VALUES[i].equals(temp)) continue;
                Element element = document.createElement(TAGS[i]);
                makefileSettings.appendChild(element);
                element.appendChild(document.createTextNode(temp));
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While saving tag `" + TAGS[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void copyMakefileSettings(Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        if (source != null) {
            NodeList resourceList = source.getChildNodes();
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                String name = resourceList.item(i).getNodeName();
                for (int j = 0; j < TAGS.length; ++j) {
                    if (!TAGS[j].equals(name)) continue;
                    newValues[j] = resourceList.item(i).getTextContent();
                }
            }
        }
        for (int i = 0; i < TAGS.length; ++i) {
            String temp = newValues[i];
            if (temp == null || !saveDefaultValues && DEFAULT_VALUES[i].equals(temp)) continue;
            Element node = document.createElement(TAGS[i]);
            node.appendChild(document.createTextNode(temp));
            makefileSettings.appendChild(node);
        }
    }
}

