/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.decorators.TITANDecorator;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.preferences.pages.ExcludeRegexpEditor;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ExcludedResourcesPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "The list of java regular expressions used to exclude resources from build and on-the-fly analysis";
    private boolean changed = false;

    public ExcludedResourcesPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    public void dispose() {
    }

    protected void createFieldEditors() {
        ExcludeRegexpEditor editor = new ExcludeRegexpEditor("org.eclipse.titan.designer.excludedResources", "regular expressions", this.getFieldEditorParent());
        editor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ExcludedResourcesPreferencePage.this.changed = true;
            }
        });
        this.addField(editor);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.changed = true;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.titan.designer");
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        if (this.changed && this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            IProject[] projects;
            this.changed = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning(null, (String)"Resource exclusion settings changed", (String)"Resource exclusion settings have changed, the known projects have to be re-analyzed completly.\nThis might take some time.");
                }
            });
            GlobalParser.clearSemanticInformation();
            TITANDecorator.resetExclusion();
            for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
                PropertyNotificationManager.firePropertyChange((IResource)project);
            }
        }
        return result;
    }
}

