/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions.runconfiggenerator;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class GenerateRunConfigBase
extends AbstractHandler
implements IObjectActionDelegate {
    public static final String SINGLE_RUNCONFIG_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<launchConfiguration type=\"org.eclipse.jdt.launching.localJavaApplication\">\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS\">\n        <listEntry value=\"/{0}/java_src/org/eclipse/titan/{0}/generated/Single_main.java\"/>\n    </listAttribute>\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES\">\n        <listEntry value=\"1\"/>\n    </listAttribute>\n    <listAttribute key=\"org.eclipse.debug.ui.favoriteGroups\">\n        <listEntry value=\"org.eclipse.debug.ui.launchGroup.run\"/>\n    </listAttribute>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_ATTR_USE_ARGFILE\" value=\"false\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_SHOW_CODEDETAILS_IN_EXCEPTION_MESSAGES\" value=\"true\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_USE_CLASSPATH_ONLY_JAR\" value=\"false\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_USE_START_ON_FIRST_THREAD\" value=\"true\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.MAIN_TYPE\" value=\"org.eclipse.titan.{0}.generated.Single_main\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.MODULE_NAME\" value=\"{0}\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.PROGRAM_ARGUMENTS\" value=\"{1}\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.PROJECT_ATTR\" value=\"{0}\"/>\n</launchConfiguration>\r\n";
    public static final String PARALLEL_RUNCONFIG_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<launchConfiguration type=\"org.eclipse.jdt.launching.localJavaApplication\">\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS\">\n        <listEntry value=\"/{0}/java_src/org/eclipse/titan/{0}/generated/Parallel_main.java\"/>\n    </listAttribute>\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES\">\n        <listEntry value=\"1\"/>\n    </listAttribute>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_ATTR_USE_ARGFILE\" value=\"false\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_SHOW_CODEDETAILS_IN_EXCEPTION_MESSAGES\" value=\"true\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_USE_CLASSPATH_ONLY_JAR\" value=\"false\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_USE_START_ON_FIRST_THREAD\" value=\"true\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.MAIN_TYPE\" value=\"org.eclipse.titan.{0}.generated.Parallel_main\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.MODULE_NAME\" value=\"{0}\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.PROGRAM_ARGUMENTS\" value=\"{1} {2,number,#}\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.PROJECT_ATTR\" value=\"{0}\"/>\n</launchConfiguration>\n";
    public static final String TITAN_RUNCONFIG_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<launchConfiguration type=\"org.eclipse.titan.executor.executors.java_mctr.LaunchConfigurationDelegate\">\r\n    <stringAttribute key=\"bad_container_name\" value=\"\\consume\"/>\r\n    <stringAttribute key=\"lastTimeSelection\" value=\"configuration file\"/>\r\n    <intAttribute key=\"lastTimeSelectionTime\" value=\"1\"/>\r\n    <intAttribute key=\"lastTimeSelectionType\" value=\"4\"/>\r\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS\">\r\n        <listEntry value=\"/{0}\"/>\r\n    </listAttribute>\r\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES\">\r\n        <listEntry value=\"4\"/>\r\n    </listAttribute>\r\n    <intAttribute key=\"org.eclipse.titan.executor.MainControllerStateRefreshTimeout\" value=\"5\"/>\r\n    <stringAttribute key=\"org.eclipse.titan.executor.configurationFilePath\" value=\"{1}\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.consoleLogging\" value=\"true\"/>\r\n    <stringAttribute key=\"org.eclipse.titan.executor.executableFilePath\" value=\"\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.executeConfigurationFileOnLaunch\" value=\"true\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.keepTemporarilyGeneratedConfigurationFiles\" value=\"true\"/>\r\n    <intAttribute key=\"org.eclipse.titan.executor.maximumNotificationLineCount\" value=\"1000\"/>\r\n    <stringAttribute key=\"org.eclipse.titan.executor.projectName\" value=\"{0}\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.severityLevelExtraction\" value=\"true\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.testcaseRefreshOnStart\" value=\"true\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.verdictExtraction\" value=\"true\"/>\r\n    <stringAttribute key=\"org.eclipse.titan.executor.workingdirectoryPath\" value=\"\"/>\r\n</launchConfiguration>\r\n";
    public static final String LAUNCH_GROUP_CONFIG_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<launchConfiguration type=\"org.eclipse.debug.core.groups.GroupLaunchConfigurationType\">\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.0.action\" value=\"NONE\"/>\r\n    <booleanAttribute key=\"org.eclipse.debug.core.launchGroup.0.adoptIfRunning\" value=\"false\"/>\r\n    <booleanAttribute key=\"org.eclipse.debug.core.launchGroup.0.enabled\" value=\"true\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.0.mode\" value=\"inherit\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.0.name\" value=\"{0}\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.1.action\" value=\"OUTPUT_REGEXP\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.1.actionParam\" value=\"Listening on IP address\"/>    <booleanAttribute key=\"org.eclipse.debug.core.launchGroup.1.adoptIfRunning\" value=\"false\"/>\r\n    <booleanAttribute key=\"org.eclipse.debug.core.launchGroup.1.enabled\" value=\"true\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.1.mode\" value=\"inherit\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.1.name\" value=\"{1}\"/>\r\n    <listAttribute key=\"org.eclipse.debug.ui.favoriteGroups\">\r\n        <listEntry value=\"org.eclipse.debug.ui.launchGroup.run\"/>\r\n    </listAttribute>\r\n</launchConfiguration>";
    public static final String RUN_CONFIG_FOLDER = "launch";
    private ISelection selection;

    private void invokeGeneration() {
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        for (Object selected : structSelection.toList()) {
            if (!(selected instanceof IFile)) continue;
            IFile tempFile = (IFile)selected;
            try {
                this.generateRunConfig(tempFile);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
    }

    protected abstract void generateRunConfig(IFile var1) throws CoreException;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (!(this.selection instanceof IStructuredSelection)) {
            return null;
        }
        this.invokeGeneration();
        return null;
    }

    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        this.invokeGeneration();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public boolean validateFile(IFile file) throws CoreException {
        String configFileName = file.getLocation().toOSString();
        if (StringUtils.isNullOrEmpty((String)configFileName)) {
            ErrorReporter.logError((String)"Error during processing the Titan configuration file");
            return false;
        }
        String projectName = file.getProject().getName();
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            ErrorReporter.logError((String)"Error during processing the project name");
            return false;
        }
        String projectLocation = file.getProject().getLocation().toOSString();
        if (StringUtils.isNullOrEmpty((String)projectLocation)) {
            ErrorReporter.logError((String)"Error during processing the project location");
            return false;
        }
        return true;
    }
}

