/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SingleArrayDimension
extends ArrayDimension {
    private static final String INTEGERVALUEEXPECTED = "Integer value was expected";
    private static final String OPERANDERROR = "A positive integer value was expected";
    private static final String LARGEINTEGERERROR = "Using a large integer value ({0}) as an array dimension is not supported";
    private final Value value;
    private long size;

    public SingleArrayDimension(Value value) {
        this.value = value;
        this.size = 0L;
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public long getOffset() {
        return 0L;
    }

    @Override
    public long getSize() {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.size;
    }

    @Override
    public String createStringRepresentation() {
        this.check(CompilationTimeStamp.getBaseTimestamp());
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        if (this.value == null) {
            builder.append("<erroneous>");
        } else {
            builder.append(this.value.createStringRepresentation());
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.setIsErroneous(false);
        if (this.value == null) {
            return;
        }
        IValue last = this.value.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_CONSTANT, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        IType.Type_type ttype = this.value.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_CONSTANT);
        switch (ttype) {
            case TYPE_INTEGER: {
                if (last.isUnfoldable(timestamp)) {
                    this.value.getLocation().reportSemanticError(OPERANDERROR);
                    this.setIsErroneous(true);
                } else if (IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) {
                    if (!((Integer_Value)last).isNative()) {
                        this.value.getLocation().reportSemanticError(MessageFormat.format(LARGEINTEGERERROR, ((Integer_Value)last).getValueValue()));
                        this.setIsErroneous(true);
                    } else {
                        this.size = ((Integer_Value)last).getValue();
                        if (this.size < 0L) {
                            this.value.getLocation().reportSemanticError(OPERANDERROR);
                            this.setIsErroneous(true);
                        }
                    }
                }
                return;
            }
        }
        this.value.getLocation().reportSemanticError(INTEGERVALUEEXPECTED);
        this.value.setIsErroneous(true);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }

    @Override
    public String getValueType(JavaGenData aData, StringBuilder source, IType elementType, Scope scope) {
        if (this.isErroneous) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for `" + this.getFullName() + "''"));
            return "FATAL ERROR in SingleArrayDImension:getValueType";
        }
        aData.addBuiltinTypeImport("TitanValue_Array");
        return MessageFormat.format("TitanValue_Array<{0}>", elementType.getGenNameValue(aData, source));
    }

    @Override
    public String getTemplateType(JavaGenData aData, StringBuilder source, IType elementType, Scope scope) {
        if (this.isErroneous) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for `" + this.getFullName() + "''"));
            return "FATAL ERROR in SingleArrayDImension:getTemplateType";
        }
        aData.addBuiltinTypeImport("TitanTemplate_Array");
        return MessageFormat.format("TitanTemplate_Array<{0}, {1}>", elementType.getGenNameValue(aData, source), elementType.getGenNameTemplate(aData, source));
    }
}

