/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.titan.designer.AST.ASN1.types.Open_Type;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class CompFieldMap
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    public static final String DUPLICATEFIELDNAMEFIRST = "Duplicate field name `{0}'' was first declared here";
    public static final String DUPLICATEFIELDNAMEREPEATED = "Duplicate field name `{0}'' was declared here again";
    final ArrayList<CompField> fields;
    private WeakReference<Type> myType;
    Map<String, CompField> componentFieldMap;
    private List<CompField> doubleComponents;
    private CompilationTimeStamp lastCompilationTimeStamp;
    private CompilationTimeStamp lastUniquenessCheck;
    private Location location = NULL_Location.INSTANCE;
    private static final Comparator<CompField> FIELD_INSERTION_COMPARATOR = new Comparator<CompField>(){

        @Override
        public int compare(CompField o1, CompField o2) {
            return o1.getLocation().getOffset() - o2.getLocation().getOffset();
        }
    };

    public CompFieldMap() {
        this.fields = new ArrayList();
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void addComp(CompField field) {
        if (field != null && field.getIdentifier() != null && field.getIdentifier().getName() != null) {
            this.fields.add(field);
            field.setFullNameParent(this);
            this.lastCompilationTimeStamp = null;
            this.lastUniquenessCheck = null;
        }
    }

    protected void addFieldsOrdered(List<CompField> fields) {
        for (CompField field : fields) {
            int position;
            if (field == null || field.getIdentifier() == null || field.getIdentifier().getName() == null || (position = Collections.binarySearch(this.fields, field, FIELD_INSERTION_COMPARATOR)) >= 0) continue;
            this.fields.add((position + 1) * -1, field);
            field.setMyScope(this.getMyScope());
            field.setFullNameParent(this);
            this.lastCompilationTimeStamp = null;
            this.lastUniquenessCheck = null;
        }
    }

    public Map<String, CompField> getComponentFieldMap(CompilationTimeStamp timestamp) {
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(timestamp);
        }
        return this.componentFieldMap;
    }

    public void setMyType(Type type) {
        this.myType = new WeakReference<Type>(type);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.fields.trimToSize();
        for (CompField field : this.fields) {
            field.setMyScope(scope);
        }
    }

    protected void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.lastUniquenessCheck != null && !this.lastUniquenessCheck.isLess(timestamp)) {
            return;
        }
        if (this.doubleComponents != null) {
            this.doubleComponents.clear();
        }
        this.componentFieldMap = new HashMap<String, CompField>(this.fields.size());
        if (this.fields.isEmpty()) {
            return;
        }
        this.lastUniquenessCheck = timestamp;
        for (CompField field : this.fields) {
            Identifier fieldIdentifier = field.getIdentifier();
            if (fieldIdentifier == null) continue;
            String fieldName = fieldIdentifier.getName();
            if (this.componentFieldMap.containsKey(fieldName)) {
                if (this.doubleComponents == null) {
                    this.doubleComponents = new ArrayList<CompField>();
                }
                this.doubleComponents.add(field);
                continue;
            }
            this.componentFieldMap.put(fieldName, field);
        }
        if (this.doubleComponents != null) {
            INamedNode p = this.getNameParent();
            if (p instanceof Open_Type) {
                return;
            }
            for (CompField field : this.doubleComponents) {
                Identifier fieldIdentifier = field.getIdentifier();
                String fieldName = fieldIdentifier.getName();
                this.componentFieldMap.get(fieldName).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEFIELDNAMEFIRST, fieldIdentifier.getDisplayName()));
                fieldIdentifier.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEFIELDNAMEREPEATED, fieldIdentifier.getDisplayName()));
            }
        }
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.checkUniqueness(timestamp);
        if (this.myType == null) {
            return;
        }
        Type parentType = (Type)this.myType.get();
        this.lastCompilationTimeStamp = timestamp;
        for (CompField field : this.fields) {
            Type fieldType = field.getType();
            if (fieldType == null) continue;
            fieldType.setGenName(parentType.getGenNameOwn(), field.getIdentifier().getName());
            fieldType.setParentType(parentType);
            field.check(timestamp);
        }
    }

    public final int getNofComponents() {
        return this.fields.size();
    }

    public final CompField getComponentByIndex(int index) {
        return this.fields.get(index);
    }

    public CompField getCompWithName(Identifier id) {
        this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        if (this.componentFieldMap != null && this.componentFieldMap.containsKey(id.getName())) {
            return this.componentFieldMap.get(id.getName());
        }
        return null;
    }

    public CompField getCompWithName(String name) {
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.componentFieldMap != null && this.componentFieldMap.containsKey(name)) {
            return this.componentFieldMap.get(name);
        }
        return null;
    }

    public List<CompField> getComponentsWithPrefix(String prefix) {
        this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        ArrayList<CompField> compFields = new ArrayList<CompField>();
        Identifier id = null;
        for (int i = 0; i < this.fields.size(); ++i) {
            id = this.fields.get(i).getIdentifier();
            if (id == null || !id.getName().startsWith(prefix)) continue;
            compFields.add(this.fields.get(i));
        }
        return compFields;
    }

    public List<CompField> getComponentsWithPrefixCaseInsensitive(String prefix) {
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        }
        ArrayList<CompField> compFields = new ArrayList<CompField>();
        for (int i = 0; i < this.fields.size(); ++i) {
            String componentName = this.fields.get(i).getIdentifier().getName();
            if (!componentName.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH))) continue;
            compFields.add(this.fields.get(i));
        }
        return compFields;
    }

    public Object[] getOutlineChildren() {
        return this.fields.toArray();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            List<Integer> temp;
            boolean isBeingExtended;
            this.lastCompilationTimeStamp = null;
            if (this.doubleComponents != null) {
                this.fields.addAll(this.doubleComponents);
                this.doubleComponents = null;
                this.lastUniquenessCheck = null;
            }
            boolean enveloped = false;
            int nofDamaged = 0;
            int leftBoundary = this.location.getOffset();
            int rightBoundary = this.location.getEndOffset();
            int damageOffset = reparser.getDamageStart();
            IAppendableSyntax lastAppendableBeforeChange = null;
            IAppendableSyntax lastPrependableBeforeChange = null;
            int size = this.fields.size();
            for (int i = 0; i < size && !enveloped; ++i) {
                CompField field = this.fields.get(i);
                Location tempLocation = field.getLocation();
                if (field.getCommentLocation() != null) {
                    tempLocation.setOffset(field.getCommentLocation().getOffset());
                }
                if (reparser.envelopsDamage(tempLocation)) {
                    enveloped = true;
                    leftBoundary = tempLocation.getOffset();
                    rightBoundary = tempLocation.getEndOffset();
                    continue;
                }
                if (reparser.isDamaged(tempLocation)) {
                    ++nofDamaged;
                    if (reparser.getDamageStart() == tempLocation.getEndOffset()) {
                        lastAppendableBeforeChange = field;
                        continue;
                    }
                    if (reparser.getDamageEnd() != tempLocation.getOffset()) continue;
                    lastPrependableBeforeChange = field;
                    continue;
                }
                if (tempLocation.getEndOffset() < damageOffset && tempLocation.getEndOffset() > leftBoundary) {
                    leftBoundary = tempLocation.getEndOffset();
                    lastAppendableBeforeChange = field;
                }
                if (tempLocation.getOffset() < damageOffset || tempLocation.getOffset() >= rightBoundary) continue;
                rightBoundary = tempLocation.getOffset();
                lastPrependableBeforeChange = field;
            }
            if (!enveloped) {
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            }
            if (lastAppendableBeforeChange != null && (isBeingExtended = reparser.startsWithFollow(lastAppendableBeforeChange.getPossibleExtensionStarterTokens()))) {
                leftBoundary = lastAppendableBeforeChange.getLocation().getOffset();
                ++nofDamaged;
                enveloped = false;
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            }
            if (lastPrependableBeforeChange != null && (temp = lastPrependableBeforeChange.getPossiblePrefixTokens()) != null && reparser.endsWithToken(temp)) {
                rightBoundary = lastPrependableBeforeChange.getLocation().getEndOffset();
                ++nofDamaged;
                enveloped = false;
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            }
            if (nofDamaged != 0) {
                this.removeStuffInRange(reparser);
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                CompField field = this.fields.get(i);
                Location tempLocation = field.getLocation();
                if (!reparser.isAffectedAppended(tempLocation)) continue;
                try {
                    field.updateSyntax(reparser, enveloped && reparser.envelopsDamage(tempLocation));
                    reparser.updateLocation(field.getLocation());
                    continue;
                }
                catch (ReParseException e) {
                    if (e.getDepth() == 1) {
                        enveloped = false;
                        this.fields.remove(i);
                        --i;
                        reparser.extendDamagedRegion(tempLocation);
                        continue;
                    }
                    e.decreaseDepth();
                    throw e;
                }
            }
            if (!enveloped) {
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
                int result = this.reparse(reparser);
                if (result == 0) {
                    return;
                }
                throw new ReParseException(Math.max(--result, 0));
            }
            return;
        }
        for (CompField field : this.fields) {
            field.updateSyntax(reparser, false);
            reparser.updateLocation(field.getLocation());
        }
        if (this.doubleComponents != null) {
            for (CompField field : this.doubleComponents) {
                field.updateSyntax(reparser, false);
                reparser.updateLocation(field.getLocation());
            }
        }
    }

    private int reparse(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                Ttcn3Reparser.Pr_reparse_StructFieldDefsContext root = parser.pr_reparse_StructFieldDefs();
                ParserUtilities.logParseTree((ParseTree)root, parser);
                List<CompField> tempFields = root.fields;
                CompFieldMap.this.lastUniquenessCheck = null;
                if (parser.isErrorListEmpty() && tempFields != null) {
                    CompFieldMap.this.addFieldsOrdered(tempFields);
                }
            }
        });
    }

    private void removeStuffInRange(TTCN3ReparseUpdater reparser) {
        for (int i = this.fields.size() - 1; i >= 0; --i) {
            Location temp = this.fields.get(i).getLocation();
            if (!reparser.isDamaged(temp)) continue;
            reparser.extendDamagedRegion(temp);
            this.fields.remove(i);
        }
    }

    public void getEnclosingField(int offset, ReferenceFinder rf) {
        for (CompField field : this.fields) {
            if (!field.getLocation().containsOffset(offset)) continue;
            rf.type = (IType)this.myType.get();
            rf.fieldId = field.getIdentifier();
            field.getType().getEnclosingField(offset, rf);
            return;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.fields == null) {
            return;
        }
        for (CompField cf : this.fields) {
            cf.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.fields != null) {
            for (CompField cf : this.fields) {
                if (cf.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

