/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Code;
import org.eclipse.titan.designer.AST.TTCN3.statements.LogArgument;
import org.eclipse.titan.designer.AST.TTCN3.statements.LogArguments;
import org.eclipse.titan.designer.AST.TTCN3.statements.Macro_InternalLogArgument;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.String_InternalLogArgument;
import org.eclipse.titan.designer.AST.TTCN3.values.Macro_Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Log_Statement
extends Statement {
    private static final String FULLNAMEPART = ".logagruments";
    private static final String STATEMENT_NAME = "log";
    private final LogArguments logArguments;

    public Log_Statement(LogArguments logArguments) {
        this.logArguments = logArguments;
        if (logArguments != null) {
            logArguments.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_LOG;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.logArguments == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.logArguments != null) {
            this.logArguments.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.logArguments != null) {
            this.logArguments.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.logArguments != null) {
            this.logArguments.check(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.logArguments != null) {
            this.logArguments.updateSyntax(reparser, false);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.logArguments != null) {
            this.logArguments.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.logArguments == null || this.logArguments.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.logArguments != null) {
            aData.addCommonLibraryImport("TTCN_Logger");
            boolean bufferedMode = true;
            if (this.logArguments.getNofLogArguments() == 1) {
                LogArgument firstArgument = this.logArguments.getLogArgumentByIndex(0);
                switch (firstArgument.getRealArgument().getArgumentType()) {
                    case String: {
                        String escaped = Code.translate_string(((String_InternalLogArgument)firstArgument.getRealArgument()).getString());
                        source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.USER_UNQUALIFIED, \"{0}\");\n", escaped));
                        bufferedMode = false;
                        break;
                    }
                    case Macro: {
                        Macro_Value value = ((Macro_InternalLogArgument)firstArgument.getRealArgument()).getMacro();
                        if (!value.canGenerateSingleExpression()) break;
                        String escaped = Code.translate_string(value.generateSingleExpression(aData).toString());
                        source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.USER_UNQUALIFIED, \"{0}\");\n", escaped));
                        bufferedMode = false;
                        break;
                    }
                }
            }
            if (bufferedMode) {
                source.append("try {\n");
                source.append("TTCN_Logger.begin_event(TTCN_Logger.Severity.USER_UNQUALIFIED);\n");
                this.logArguments.generateCode(aData, source);
                source.append("TTCN_Logger.end_event();\n");
                source.append("} finally {\n");
                source.append("TTCN_Logger.finish_event();\n");
                source.append("}\n");
            }
        } else {
            source.append("TTCN_Logger.log_str(Severity.USER_UNQUALIFIED,\"<empty log statement>\");\n");
        }
    }
}

