/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.For_Loop_Definitions;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Assignment_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Boolean_Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class For_Statement
extends Statement {
    private static final String OPERANDERROR = "The final expression of a for statement should be a boolean value";
    private static final String FULLNAMEPART1 = ".init";
    private static final String FULLNAMEPART2 = ".final";
    private static final String FULLNAMEPART3 = ".step";
    private static final String FULLNAMEPART4 = ".block";
    private static final String STATEMENT_NAME = "for";
    private final For_Loop_Definitions definitions;
    private final Assignment_Statement initialAssignment;
    private final Value finalExpression;
    private final Assignment_Statement stepAssignment;
    private final StatementBlock statementblock;

    public For_Statement(For_Loop_Definitions definitions, Value finalExpression, Assignment_Statement incrementStep, StatementBlock statementblock) {
        this.definitions = definitions;
        this.initialAssignment = null;
        this.finalExpression = finalExpression;
        this.stepAssignment = incrementStep;
        this.statementblock = statementblock;
        this.init();
    }

    public For_Statement(Assignment_Statement initialAssignment, Value finalExpression, Assignment_Statement incrementStep, StatementBlock statementblock) {
        this.definitions = null;
        this.initialAssignment = initialAssignment;
        this.finalExpression = finalExpression;
        this.stepAssignment = incrementStep;
        this.statementblock = statementblock;
        this.init();
    }

    private void init() {
        if (this.definitions != null) {
            this.definitions.setFullNameParent(this);
        }
        if (this.initialAssignment != null) {
            this.initialAssignment.setFullNameParent(this);
        }
        if (this.finalExpression != null) {
            this.finalExpression.setFullNameParent(this);
        }
        if (this.stepAssignment != null) {
            this.stepAssignment.setFullNameParent(this);
        }
        if (this.statementblock != null) {
            this.statementblock.setFullNameParent(this);
            this.statementblock.setOwnerIsLoop();
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_WHILE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.definitions == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.initialAssignment == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.finalExpression == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.stepAssignment == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.statementblock == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.definitions == null) {
            if (this.initialAssignment != null) {
                this.initialAssignment.setMyScope(scope);
            }
            if (this.finalExpression != null) {
                this.finalExpression.setMyScope(scope);
            }
            if (this.stepAssignment != null) {
                this.stepAssignment.setMyScope(scope);
            }
            if (this.statementblock != null) {
                this.statementblock.setMyScope(scope);
                scope.addSubScope(this.statementblock.getLocation(), this.statementblock);
            }
        } else {
            this.definitions.setParentScope(scope);
            Location startLoc = this.definitions.getLocation();
            Location endLoc = null;
            if (this.finalExpression != null) {
                this.finalExpression.setMyScope(this.definitions);
                endLoc = this.finalExpression.getLocation();
            }
            if (this.stepAssignment != null) {
                this.stepAssignment.setMyScope(this.definitions);
                endLoc = this.stepAssignment.getLocation();
            }
            scope.addSubScope(endLoc == null ? startLoc : Location.interval(startLoc, endLoc), this.definitions);
            if (this.statementblock != null) {
                this.statementblock.setMyScope(this.definitions);
                scope.addSubScope(this.statementblock.getLocation(), this.statementblock);
            }
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.definitions == null && this.initialAssignment != null) {
            this.initialAssignment.setCodeSection(codeSection);
        }
        if (this.finalExpression != null) {
            this.finalExpression.setCodeSection(codeSection);
        }
        if (this.stepAssignment != null) {
            this.stepAssignment.setCodeSection(codeSection);
        }
        if (this.statementblock != null) {
            this.statementblock.setCodeSection(codeSection);
        }
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        if (this.statementblock != null) {
            this.statementblock.setMyStatementBlock(statementBlock, index);
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.statementblock != null) {
            this.statementblock.setMyDefinition(definition);
        }
    }

    @Override
    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementblock != null) {
            this.statementblock.setMyAltguards(altGuards);
        }
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.statementblock != null) {
            if (StatementBlock.ReturnStatus_type.RS_NO.equals((Object)this.statementblock.hasReturn(timestamp))) {
                return StatementBlock.ReturnStatus_type.RS_NO;
            }
            return StatementBlock.ReturnStatus_type.RS_MAYBE;
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    @Override
    public boolean hasReceivingStatement() {
        if (this.statementblock != null) {
            return this.statementblock.hasReceivingStatement(0);
        }
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.definitions != null) {
            this.definitions.check(timestamp);
        }
        if (this.initialAssignment != null) {
            this.initialAssignment.check(timestamp);
        }
        if (this.finalExpression != null) {
            this.finalExpression.setLoweridToReference(timestamp);
            IValue lastValue = this.finalExpression.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type temp = lastValue.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (temp) {
                case TYPE_BOOL: {
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR);
                    this.finalExpression.setIsErroneous(true);
                }
            }
            if (this.finalExpression.getMyGovernor() == null) {
                this.finalExpression.setMyGovernor(new Boolean_Type());
            }
        }
        if (this.stepAssignment != null) {
            this.stepAssignment.check(timestamp);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyLaicStmt(null, this);
            this.statementblock.check(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        if (this.statementblock != null) {
            this.statementblock.checkAllowedInterleave();
        }
    }

    @Override
    public void postCheck() {
        if (this.definitions != null) {
            this.definitions.postCheck();
        }
        if (this.statementblock != null) {
            this.statementblock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            if (this.definitions != null) {
                if (enveloped) {
                    this.definitions.updateSyntax(reparser, false);
                    reparser.updateLocation(this.definitions.getLocation());
                } else if (reparser.envelopsDamage(this.definitions.getLocation())) {
                    this.definitions.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.definitions.getLocation());
                }
            }
            if (this.initialAssignment != null) {
                if (enveloped) {
                    this.initialAssignment.updateSyntax(reparser, false);
                    reparser.updateLocation(this.initialAssignment.getLocation());
                } else if (reparser.envelopsDamage(this.initialAssignment.getLocation())) {
                    this.initialAssignment.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.initialAssignment.getLocation());
                }
            }
            if (this.finalExpression != null) {
                if (enveloped) {
                    this.finalExpression.updateSyntax(reparser, false);
                    reparser.updateLocation(this.finalExpression.getLocation());
                } else if (reparser.envelopsDamage(this.finalExpression.getLocation())) {
                    this.finalExpression.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.finalExpression.getLocation());
                }
            }
            if (this.stepAssignment != null) {
                if (enveloped) {
                    this.stepAssignment.updateSyntax(reparser, false);
                    reparser.updateLocation(this.stepAssignment.getLocation());
                } else if (reparser.envelopsDamage(this.stepAssignment.getLocation())) {
                    this.stepAssignment.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.stepAssignment.getLocation());
                }
            }
            if (this.statementblock != null) {
                if (enveloped) {
                    this.statementblock.updateSyntax(reparser, false);
                    reparser.updateLocation(this.statementblock.getLocation());
                } else if (reparser.envelopsDamage(this.statementblock.getLocation())) {
                    this.statementblock.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.statementblock.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        if (this.definitions != null) {
            this.definitions.updateSyntax(reparser, false);
            reparser.updateLocation(this.definitions.getLocation());
        }
        if (this.initialAssignment != null) {
            this.initialAssignment.updateSyntax(reparser, false);
            reparser.updateLocation(this.initialAssignment.getLocation());
        }
        if (this.finalExpression != null) {
            this.finalExpression.updateSyntax(reparser, false);
            reparser.updateLocation(this.finalExpression.getLocation());
        }
        if (this.stepAssignment != null) {
            this.stepAssignment.updateSyntax(reparser, false);
            reparser.updateLocation(this.stepAssignment.getLocation());
        }
        if (this.statementblock != null) {
            this.statementblock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementblock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.definitions != null) {
            this.definitions.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.initialAssignment != null) {
            this.initialAssignment.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.finalExpression != null) {
            this.finalExpression.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.stepAssignment != null) {
            this.stepAssignment.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementblock != null) {
            this.statementblock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.definitions != null && !this.definitions.accept(v)) {
            return false;
        }
        if (this.initialAssignment != null && !this.initialAssignment.accept(v)) {
            return false;
        }
        if (this.finalExpression != null && !this.finalExpression.accept(v)) {
            return false;
        }
        if (this.stepAssignment != null && !this.stepAssignment.accept(v)) {
            return false;
        }
        return this.statementblock == null || this.statementblock.accept(v);
    }

    public Value getFinalExpression() {
        return this.finalExpression;
    }

    public StatementBlock getStatementBlock() {
        return this.statementblock;
    }

    public void generateCodeStepAssigment(JavaGenData aData, StringBuilder source) {
        this.stepAssignment.generateCode(aData, source);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        source.append("\t\t{\n");
        if (this.definitions != null) {
            this.definitions.generateCode(aData, source);
        } else if (this.initialAssignment != null) {
            this.initialAssignment.getLocation().update_location_object(aData, source);
            this.initialAssignment.generateCode(aData, source);
        }
        source.append("\t\t\tfor( ; ; ) {\n");
        this.getLocation().update_location_object(aData, source);
        AtomicInteger blockCount = new AtomicInteger(0);
        if (this.finalExpression.returnsNative()) {
            this.finalExpression.generateCodeTmp(aData, source, "if (!", blockCount);
            source.append(") {\n");
        } else {
            aData.addBuiltinTypeImport("TitanBoolean");
            this.finalExpression.generateCodeTmp(aData, source, "if (!TitanBoolean.get_native(", blockCount);
            source.append(")) {\n");
        }
        source.append("break;\n");
        source.append("}\n");
        for (int i = 0; i < blockCount.get(); ++i) {
            source.append("}\n");
        }
        this.statementblock.generateCode(aData, source);
        if (!StatementBlock.ReturnStatus_type.RS_YES.equals((Object)this.statementblock.hasReturn(CompilationTimeStamp.getBaseTimestamp()))) {
            this.stepAssignment.getLocation().update_location_object(aData, source);
            this.stepAssignment.generateCode(aData, source);
        }
        source.append("\t\t\t}\n");
        source.append("\t\t}\n");
    }
}

