/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.values.Altstep_Reference_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Altstep_Applied_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".reference";
    private static final String FULLNAMEPART2 = ".<parameters>";
    private static final String STATEMENT_NAME = "altstep type application";
    private final Value dereferredValue;
    private final ParsedActualParameters actualParameterList;
    private final ActualParameterList actualParameterList2;

    public Altstep_Applied_Statement(Value dereferredValue, ParsedActualParameters actualParameterList, ActualParameterList actualParameterList2) {
        this.dereferredValue = dereferredValue;
        this.actualParameterList = actualParameterList;
        this.actualParameterList2 = actualParameterList2;
        if (dereferredValue != null) {
            dereferredValue.setFullNameParent(this);
        }
        if (actualParameterList != null) {
            actualParameterList.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_ALTSTEP_APPLIED;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.dereferredValue == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.actualParameterList == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.dereferredValue != null) {
            this.dereferredValue.setMyScope(scope);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.dereferredValue != null) {
            this.dereferredValue.setCodeSection(codeSection);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean hasReceivingStatement() {
        return true;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        this.location.reportSemanticError("Invocation of an altstep type is not allowed within an interleave statement");
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.dereferredValue != null) {
            this.dereferredValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.dereferredValue.getLocation());
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.actualParameterList.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.dereferredValue != null) {
            this.dereferredValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.dereferredValue != null && !this.dereferredValue.accept(v)) {
            return false;
        }
        return this.actualParameterList == null || this.actualParameterList.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        IValue last = this.dereferredValue.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        if (last.getValuetype().equals((Object)IValue.Value_type.ALTSTEP_REFERENCE_VALUE)) {
            Altstep_Reference_Value refdValue = (Altstep_Reference_Value)last;
            Def_Altstep definition = refdValue.getReferredAltstep();
            expression.expression.append(definition.getGenNameFromScope(aData, source, ""));
            expression.expression.append("(");
            if (this.actualParameterList2 != null && this.actualParameterList2.getNofParameters() > 0) {
                this.actualParameterList2.generateCodeAlias(aData, expression, null);
            }
            expression.expression.append(')');
            expression.mergeExpression(source);
            return;
        }
        this.dereferredValue.generateCodeExpressionMandatory(aData, expression, true);
        expression.expression.append(".invoke_standalone(");
        if (this.actualParameterList2 != null && this.actualParameterList2.getNofParameters() > 0) {
            this.actualParameterList2.generateCodeAlias(aData, expression, null);
        }
        expression.expression.append(')');
        expression.mergeExpression(source);
    }
}

