/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class TypeMappingTargets
extends ASTNode
implements IIncrementallyUpdateable {
    private final List<TypeMappingTarget> targets = new ArrayList<TypeMappingTarget>();

    public void addMappingTarget(TypeMappingTarget mappingTarget) {
        this.targets.add(mappingTarget);
        mappingTarget.setFullNameParent(this);
    }

    public int getNofTargets() {
        return this.targets.size();
    }

    public TypeMappingTarget getTargetByIndex(int index) {
        return this.targets.get(index);
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.targets.size();
        for (int i = 0; i < size; ++i) {
            TypeMappingTarget target = this.targets.get(i);
            if (target != child) continue;
            return builder.append(".<target ").append(i + 1).append('>');
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (TypeMappingTarget tmt : this.targets) {
            tmt.setMyScope(scope);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (TypeMappingTarget tmt : this.targets) {
            tmt.updateSyntax(reparser, false);
            reparser.updateLocation(tmt.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.targets == null) {
            return;
        }
        for (TypeMappingTarget tmt : this.targets) {
            tmt.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.targets != null) {
            for (TypeMappingTarget tmt : this.targets) {
                if (tmt.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

