/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;

public final class FileUtils {
    private FileUtils() {
    }

    public static void delete(File file) throws IOException {
        if (FileUtils.deleteIfExists(file)) {
            throw new IOException("The file cannot be deleted: " + file.getAbsolutePath());
        }
    }

    public static boolean deleteQuietly(File file) {
        boolean failed = FileUtils.deleteIfExists(file);
        if (failed) {
            ErrorReporter.logError("Cannot delete file: " + file.getPath());
        }
        return !failed;
    }

    private static boolean deleteIfExists(File file) {
        return file.exists() && !file.delete();
    }

    public static void createDir(IFolder aFolder) throws CoreException {
        FileUtils.createDir(aFolder, null);
    }

    public static void createDir(IFolder aFolder, IProgressMonitor monitor) throws CoreException {
        if (!aFolder.exists()) {
            IContainer parent = aFolder.getParent();
            if (parent instanceof IFolder) {
                FileUtils.createDir((IFolder)parent);
            }
            aFolder.create(true, true, monitor);
        }
    }
}

