/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.ConfigTextEditor;
import org.eclipse.titan.designer.editors.configeditor.PairMatcher;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class GotoMatchingBracketAction
extends AbstractHandler
implements IEditorActionDelegate {
    private ConfigEditor targetEditor = null;
    private ISelection selection = TextSelection.emptySelection();

    public final void run(IAction action) {
        int carretOffset;
        TextSelection tSelection;
        if (this.targetEditor == null) {
            return;
        }
        if (this.targetEditor.getActiveEditor() != this.targetEditor.getEditor()) {
            return;
        }
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && (tSelection = (TextSelection)this.selection).getLength() != 0) {
            return;
        }
        PairMatcher pairMatcher = new PairMatcher();
        ConfigTextEditor textEditor = this.targetEditor.getEditor();
        IDocument document = textEditor.getDocument();
        IRegion region = pairMatcher.match(document, carretOffset = textEditor.getCarretOffset());
        if (region == null) {
            return;
        }
        int targetOffset = region.getOffset() + 1 == carretOffset ? region.getOffset() + region.getLength() : region.getOffset() + 1;
        textEditor.setCarretOffset(targetOffset);
        textEditor.selectAndReveal(targetOffset, 0);
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public final void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor instanceof ConfigEditor ? (ConfigEditor)targetEditor : null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int carretOffset;
        TextSelection tSelection;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.targetEditor = activeEditor instanceof ConfigEditor ? (ConfigEditor)activeEditor : null;
        if (activeEditor == null) {
            return null;
        }
        if (this.targetEditor.getActiveEditor() != this.targetEditor.getEditor()) {
            return null;
        }
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && (tSelection = (TextSelection)this.selection).getLength() != 0) {
            return null;
        }
        PairMatcher pairMatcher = new PairMatcher();
        ConfigTextEditor textEditor = this.targetEditor.getEditor();
        IDocument document = textEditor.getDocument();
        IRegion region = pairMatcher.match(document, carretOffset = textEditor.getCarretOffset());
        if (region == null) {
            return null;
        }
        int targetOffset = region.getOffset() + 1 == carretOffset ? region.getOffset() + region.getLength() : region.getOffset() + 1;
        textEditor.setCarretOffset(targetOffset);
        textEditor.selectAndReveal(targetOffset, 0);
        return null;
    }
}

