/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class AnyOrOmit_Template
extends TTCN3Template {
    private static final String MANDATORYWARNING = "Using `*' for a mandatory field";
    private static final String SIGNATUREERROR = "Generic wildcard `*'' cannot be used for signature `{0}''";

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.ANY_OR_OMIT;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous any or omit";
        }
        return "any or omit";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("*");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of an any or omit");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public boolean checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit, Assignment lhs) {
        IType last;
        if (!allowAnyOrOmit) {
            this.location.reportSemanticWarning(MANDATORYWARNING);
        }
        if (!this.getIsErroneous(timestamp) && IType.Type_type.TYPE_SIGNATURE.equals((Object)(last = type.getTypeRefdLast(timestamp)).getTypetype())) {
            this.location.reportSemanticError(MessageFormat.format(SIGNATUREERROR, last.getFullName()));
            this.setIsErroneous(true);
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
        return false;
    }

    @Override
    public boolean chkRestrictionNamedListBaseTemplate(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Set<String> checkedNames, int neededCheckedCnt, Location usageLocation) {
        usageLocation.reportSemanticError(MessageFormat.format("Restriction ''value'' or ''omit'' on {0} does not allow usage of `{1}''", definitionName, this.getTemplateTypeName()));
        return false;
    }

    @Override
    public boolean checkPresentRestriction(CompilationTimeStamp timestamp, String definitionName, Location usageLocation) {
        this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_PRESENT, usageLocation);
        usageLocation.reportSemanticError(MessageFormat.format("Restriction ''present'' on {0} does not allow usage of `{1}''", definitionName, this.getTemplateTypeName()));
        return false;
    }

    @Override
    public boolean hasSingleExpression() {
        return this.lengthRestriction == null && !this.isIfpresent && !this.get_needs_conversion();
    }

    @Override
    public StringBuilder getSingleExpression(JavaGenData aData, boolean castIsNeeded) {
        StringBuilder result = new StringBuilder();
        if (castIsNeeded && (this.lengthRestriction != null || this.isIfpresent)) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing any value or omit template `" + this.getFullName() + "''"));
            return result;
        }
        aData.addBuiltinTypeImport("Base_Template.template_sel");
        result.append(MessageFormat.format("new {0}(template_sel.ANY_OR_OMIT)", this.myGovernor.getGenNameTemplate(aData, result)));
        return result;
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, this.getSingleExpression(aData, false)));
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
    }
}

