/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.tuple.Tuples;

public class AbstractImmutableEntry<K, V>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final PairFunction<?, ?> TO_PAIR = new PairFunction();
    protected final K key;
    protected final V value;

    public AbstractImmutableEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Deprecated
    public static <K> Function<Map.Entry<K, ?>, K> getKeyFunction() {
        return Functions.getKeyFunction();
    }

    @Deprecated
    public static <V> Function<Map.Entry<?, V>, V> getValueFunction() {
        return Functions.getValueFunction();
    }

    public static <K, V> Function<Map.Entry<K, V>, Pair<K, V>> getPairFunction() {
        return TO_PAIR;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException("Cannot call setValue() on " + this.getClass().getSimpleName());
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    @Deprecated
    private static class KeyFunction<K>
    implements Function<Map.Entry<K, ?>, K> {
        private static final long serialVersionUID = 1L;

        private KeyFunction() {
        }

        @Override
        public K valueOf(Map.Entry<K, ?> entry) {
            return entry.getKey();
        }
    }

    private static class PairFunction<K, V>
    implements Function<Map.Entry<K, V>, Pair<K, V>> {
        private static final long serialVersionUID = 1L;

        private PairFunction() {
        }

        @Override
        public Pair<K, V> valueOf(Map.Entry<K, V> entry) {
            return Tuples.pairFrom(entry);
        }
    }

    @Deprecated
    private static class ValueFunction<V>
    implements Function<Map.Entry<?, V>, V> {
        private static final long serialVersionUID = 1L;

        private ValueFunction() {
        }

        @Override
        public V valueOf(Map.Entry<?, V> entry) {
            return entry.getValue();
        }
    }
}

