/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;
import java.util.List;
import org.eclipse.swtbot.generator.client.RecorderClientCodeListener;
import org.eclipse.swtbot.generator.client.RecorderClientStatusListener;

public class RecorderClient
extends Thread {
    private static final int REFRESH_TIME = 1000;
    private List<RecorderClientCodeListener> codeListeners;
    private List<RecorderClientStatusListener> statusListeners;
    private int port;
    private Socket socket;

    public RecorderClient(List<RecorderClientCodeListener> codeListeners, List<RecorderClientStatusListener> statusListeners, int port) {
        this.codeListeners = codeListeners;
        this.statusListeners = statusListeners;
        this.port = port;
    }

    public void closeSocket() {
        if (this.socket == null || this.socket.isClosed()) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.socket = this.connect("localhost", this.port);
        if (this.socket == null) {
            for (RecorderClientStatusListener listener : this.statusListeners) {
                listener.connectionEnded();
            }
            throw new RuntimeException("Could not create socket for client");
        }
        for (RecorderClientStatusListener listener : this.statusListeners) {
            listener.connectionStarted();
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            while ((line = in.readLine()) != null && !RecorderClient.interrupted()) {
                for (RecorderClientCodeListener recorderClientCodeListener : this.codeListeners) {
                    recorderClientCodeListener.codeGenerated(line);
                }
            }
            for (RecorderClientStatusListener recorderClientStatusListener : this.statusListeners) {
                recorderClientStatusListener.connectionEnded();
            }
            this.socket.close();
        }
        catch (IOException iOException) {
            return;
        }
    }

    private Socket connect(String host, int port) {
        while (true) {
            try {
                Socket socket = new Socket(host, port);
                return socket;
            }
            catch (ConnectException connectException) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public int getPort() {
        return this.port;
    }
}

