/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.BranchTagSelectionComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;

public class ReplaceBranchTagPanel
extends AbstractDialogPanel {
    protected IRepositoryResource baseResource;
    protected int type;
    protected IRepositoryResource[] branchTagResources;
    protected long currentRevision;
    protected String historyKey;
    protected BranchTagSelectionComposite selectionComposite;
    protected Label resultText;
    protected IRepositoryResource resourceToReplaceWith;

    public ReplaceBranchTagPanel(IRepositoryResource baseResource, long currentRevision, int type, IRepositoryResource[] branchTagResources) {
        this.baseResource = baseResource;
        this.type = type;
        this.branchTagResources = branchTagResources;
        if (type == 0) {
            this.dialogTitle = SVNUIMessages.Replace_Branch_Title;
            this.dialogDescription = SVNUIMessages.Replace_Branch_Description;
            this.defaultMessage = SVNUIMessages.Replace_Branch_Message;
            this.historyKey = "branchReplace";
        } else {
            this.dialogTitle = SVNUIMessages.Replace_Tag_Title;
            this.dialogDescription = SVNUIMessages.Replace_Tag_Description;
            this.defaultMessage = SVNUIMessages.Replace_Tag_Message;
            this.historyKey = "tagReplace";
        }
    }

    protected void createControlsImpl(Composite parent) {
        GridData data = null;
        this.selectionComposite = new BranchTagSelectionComposite(parent, 0, this.baseResource, this.historyKey, this, this.type, this.branchTagResources);
        data = new GridData(768);
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.setCurrentRevision(this.currentRevision);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        Label label = new Label(parent, 0);
        data = new GridData(768);
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.ReplaceBranchTagPanel_ResultDescription);
        Composite resultComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        resultComposite.setLayout((Layout)layout);
        data = new GridData(768);
        resultComposite.setLayoutData((Object)data);
        resultComposite.setBackground(UIMonitorUtility.getDisplay().getSystemColor(1));
        this.resultText = new Label(resultComposite, 68);
        this.resultText.setLayoutData((Object)new GridData(768));
        this.resultText.setBackground(UIMonitorUtility.getDisplay().getSystemColor(1));
        this.selectionComposite.addUrlModifyListener(new Listener(){

            public void handleEvent(Event event) {
                ReplaceBranchTagPanel.this.setResultLabel();
            }
        });
        this.selectionComposite.addUrlVerifier(new AbstractVerifier(){

            protected String getErrorMessage(Control input) {
                if (BranchTagSelectionComposite.getResourceToCompareWith(ReplaceBranchTagPanel.this.baseResource, ReplaceBranchTagPanel.this.getSelectedResource()) == null) {
                    return SVNUIMessages.ReplaceBranchTagPanel_ConstructResultVerifierError;
                }
                return null;
            }

            protected String getWarningMessage(Control input) {
                return null;
            }
        });
        this.setResultLabel();
    }

    protected void setResultLabel() {
        String text = "";
        this.resourceToReplaceWith = null;
        if (this.getSelectedResource() != null) {
            this.resourceToReplaceWith = BranchTagSelectionComposite.getResourceToCompareWith(this.baseResource, this.getSelectedResource());
            text = this.resourceToReplaceWith != null ? this.resourceToReplaceWith.getUrl() : SVNUIMessages.ReplaceBranchTagPanel_ResultNone;
        }
        this.resultText.setText(text);
    }

    private IRepositoryResource getSelectedResource() {
        return this.selectionComposite.getSelectedResource();
    }

    public IRepositoryResource getResourceToReplaceWith() {
        return this.resourceToReplaceWith;
    }

    protected void saveChangesImpl() {
        this.selectionComposite.saveChanges();
    }

    protected void cancelChangesImpl() {
    }
}

