/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.mapping;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.svn.ui.extension.impl.synchronize.OptionsActionGroup;
import org.eclipse.team.svn.ui.mapping.AbstractSVNModelParticipant;
import org.eclipse.team.svn.ui.mapping.SVNModelParticipantChangeSetCapability;
import org.eclipse.team.svn.ui.mapping.UpdateSubscriberContext;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.synchronize.UpdateModelActionGroup;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateModelParticipant
extends AbstractSVNModelParticipant
implements IChangeSetProvider {
    private static final String CTX_CONSULT_CHANGE_SETS = "consultChangeSets";
    protected ChangeSetCapability capability;
    protected boolean isConsultChangeSets;

    public UpdateModelParticipant() {
    }

    public UpdateModelParticipant(SynchronizationContext context) {
        super(context);
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor("org.eclipse.team.svn.ui.synchronize.update.SynchronizeModelParticipant"));
        }
        catch (CoreException e) {
            UILoggedOperation.reportError(((Object)((Object)this)).getClass().getName(), e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
        this.isConsultChangeSets = this.isConsultChangeSets(context.getScopeManager());
    }

    @Override
    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)"org.eclipse.team.svn.ui.workspaceSynchronization");
        super.initializeConfiguration(configuration);
    }

    @Override
    protected Collection<AbstractSynchronizeActionGroup> getActionGroups() {
        ArrayList<AbstractSynchronizeActionGroup> actionGroups = new ArrayList<AbstractSynchronizeActionGroup>();
        actionGroups.add(new OptionsActionGroup());
        return actionGroups;
    }

    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new UpdateModelActionGroup();
    }

    @Override
    protected int getSupportedModes() {
        return 15;
    }

    @Override
    protected int getDefaultMode() {
        return 4;
    }

    public ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = new SVNModelParticipantChangeSetCapability();
        }
        return this.capability;
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) {
        return UpdateSubscriberContext.createContext(manager, 3);
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        return UpdateSubscriberContext.createWorkspaceScopeManager(mappings, true, this.isConsultChangeSets);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(CTX_CONSULT_CHANGE_SETS, Boolean.toString(this.isConsultChangeSets));
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        try {
            String consult = memento.getString(CTX_CONSULT_CHANGE_SETS);
            if (consult != null) {
                this.isConsultChangeSets = Boolean.valueOf(consult);
            }
        }
        finally {
            super.init(secondaryId, memento);
        }
    }

    protected boolean isConsultChangeSets(ISynchronizationScopeManager manager) {
        if (manager instanceof UpdateSubscriberContext.ChangeSetSubscriberScopeManager) {
            UpdateSubscriberContext.ChangeSetSubscriberScopeManager man = (UpdateSubscriberContext.ChangeSetSubscriberScopeManager)manager;
            return man.isConsultSets();
        }
        return false;
    }
}

