/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractview;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.actions.STCollapseAllTreeAction;
import org.eclipse.linuxtools.dataviewers.actions.STCollapseSelectionAction;
import org.eclipse.linuxtools.dataviewers.actions.STCopyAction;
import org.eclipse.linuxtools.dataviewers.actions.STDataViewersSortAction;
import org.eclipse.linuxtools.dataviewers.actions.STExpandAllTreeAction;
import org.eclipse.linuxtools.dataviewers.actions.STExpandSelectionAction;
import org.eclipse.linuxtools.dataviewers.actions.STExportToCSVAction;
import org.eclipse.linuxtools.dataviewers.actions.STHideShowColAction;
import org.eclipse.linuxtools.dataviewers.findreplace.ISTFindReplaceTarget;
import org.eclipse.linuxtools.dataviewers.findreplace.STFindReplaceAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ViewPreferencesAction;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public abstract class AbstractSTDataView
extends ViewPart {
    private AbstractSTViewer stViewer = null;
    private IAction sortAction = null;
    private IAction preferencesAction = null;
    private IAction hideShowColAction = null;
    private IAction expandAllAction = null;
    private IAction collapseAllAction = null;
    private IAction expandSelectionAction = null;
    private IAction collapseSelectionAction = null;
    private IAction exportToCSVAction = null;
    private IAction copyToAction = null;
    private ISTFindReplaceTarget fTarget = null;

    protected void createTitle(Composite parent) {
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout(1, true);
        parent.setLayout((Layout)gridLayout);
        this.createTitle(parent);
        this.stViewer = this.createAbstractSTViewer(parent);
        this.createActions();
        MenuManager mgr = this.initContextMenu();
        Menu menu = mgr.createContextMenu((Control)parent);
        this.stViewer.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(mgr, this.getSelectionProvider());
        this.getSite().setSelectionProvider(this.getSelectionProvider());
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.initMenu(actionBars.getMenuManager());
        this.initToolBar(actionBars.getToolBarManager());
        this.registerGlobalActions(this.getViewSite().getActionBars());
    }

    protected void createActions() {
        this.expandAllAction = this.createExpandAllAction();
        this.collapseAllAction = this.createCollapseAllAction();
        this.sortAction = this.createSortAction();
        this.hideShowColAction = this.createHideShowColumnAction();
        this.exportToCSVAction = this.createExportToCSVAction();
        this.expandSelectionAction = this.createExpandSelectionAction();
        this.collapseSelectionAction = this.createCollapseSelectionAction();
        this.copyToAction = this.createCopyToAction();
    }

    protected IAction createCopyToAction() {
        return new STCopyAction(this.getSTViewer());
    }

    protected IAction createExportToCSVAction() {
        return new STExportToCSVAction(this.getSTViewer());
    }

    protected IAction createCollapseSelectionAction() {
        if (this.getSTViewer() instanceof AbstractSTTreeViewer) {
            AbstractSTTreeViewer stTreeViewer = (AbstractSTTreeViewer)this.getSTViewer();
            return new STCollapseSelectionAction(stTreeViewer);
        }
        return null;
    }

    protected IAction createExpandSelectionAction() {
        if (this.getSTViewer() instanceof AbstractSTTreeViewer) {
            AbstractSTTreeViewer stTreeViewer = (AbstractSTTreeViewer)this.getSTViewer();
            return new STExpandSelectionAction(stTreeViewer);
        }
        return null;
    }

    protected IAction createHideShowColumnAction() {
        return new STHideShowColAction(this.getSTViewer());
    }

    protected IAction createSortAction() {
        return new STDataViewersSortAction(this.getSTViewer());
    }

    protected IAction createCollapseAllAction() {
        if (this.getSTViewer() instanceof AbstractSTTreeViewer) {
            AbstractSTTreeViewer stTreeViewer = (AbstractSTTreeViewer)this.getSTViewer();
            return new STCollapseAllTreeAction(stTreeViewer);
        }
        return null;
    }

    protected IAction createExpandAllAction() {
        if (this.getSTViewer() instanceof AbstractSTTreeViewer) {
            AbstractSTTreeViewer stTreeViewer = (AbstractSTTreeViewer)this.getSTViewer();
            return new STExpandAllTreeAction(stTreeViewer);
        }
        return null;
    }

    protected MenuManager initContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractSTDataView.this.getSTViewer().getViewer().cancelEditing();
                AbstractSTDataView.this.fillContextMenu(mgr);
            }
        });
        return mgr;
    }

    protected void initToolBar(IToolBarManager manager) {
        if (this.expandAllAction != null) {
            manager.add(this.expandAllAction);
        }
        if (this.collapseAllAction != null) {
            manager.add(this.collapseAllAction);
        }
        if (this.hideShowColAction != null) {
            manager.add(this.hideShowColAction);
        }
        if (this.exportToCSVAction != null) {
            manager.add(this.exportToCSVAction);
        }
        if (this.sortAction != null) {
            manager.add(this.sortAction);
        }
        this.contributeToToolbar(manager);
        manager.update(true);
    }

    protected void initMenu(IMenuManager menu) {
        if (this.sortAction != null) {
            menu.add(this.sortAction);
        }
        if (this.hideShowColAction != null) {
            menu.add(this.hideShowColAction);
        }
        if (this.preferencesAction != null) {
            menu.add(this.preferencesAction);
        }
        if (this.exportToCSVAction != null) {
            menu.add(this.exportToCSVAction);
        }
        this.contributeToDropDownMenu(menu);
    }

    public void setFocus() {
        ColumnViewer viewer = this.getSTViewer().getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().setFocus();
        }
    }

    public AbstractSTViewer getSTViewer() {
        return this.stViewer;
    }

    public Control getControl() {
        return this.stViewer.getViewer().getControl();
    }

    public void setInput(Object input) {
        this.stViewer.getViewer().setInput(input);
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        IWorkbenchSiteProgressService service = null;
        Object siteService = this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }

    protected IAction getPreferencesAction() {
        return this.preferencesAction;
    }

    protected void setPreferencesAction(ViewPreferencesAction preferencesAction) {
        this.preferencesAction = preferencesAction;
    }

    protected ISelectionProvider getSelectionProvider() {
        return this.stViewer.getViewer();
    }

    public Object getViewerInput() {
        return this.stViewer.getViewer().getInput();
    }

    protected void setSelection(IStructuredSelection selection) {
        this.getSelectionProvider().setSelection((ISelection)selection);
    }

    protected void fillContextMenu(IMenuManager manager) {
        Tree tree;
        TreeItem[] selection;
        if (this.getControl() != null && this.getControl() instanceof Tree && (selection = (tree = (Tree)this.getControl()).getSelection()) != null && selection.length > 0) {
            if (this.collapseSelectionAction != null) {
                manager.add(this.collapseSelectionAction);
            }
            if (this.expandSelectionAction != null) {
                manager.add(this.expandSelectionAction);
            }
            manager.add((IContributionItem)new Separator("additions"));
            if (this.copyToAction != null) {
                manager.add(this.copyToAction);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void contributeToDropDownMenu(IMenuManager menu) {
    }

    protected void contributeToToolbar(IToolBarManager manager) {
    }

    protected void registerGlobalActions(IActionBars actionBars) {
        this.fTarget = this.createSTFindReplaceTarget();
        if (this.fTarget == null) {
            return;
        }
        STFindReplaceAction action = new STFindReplaceAction(this.getSite().getShell(), this.fTarget);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.FIND, (IAction)action);
    }

    public ISTFindReplaceTarget createSTFindReplaceTarget() {
        return null;
    }

    protected ISTDataViewersField[] getSortingFields() {
        return null;
    }

    protected abstract AbstractSTViewer createAbstractSTViewer(Composite var1);

    public void dispose() {
        super.dispose();
    }
}

