/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AbstractMakefileCodeScanner;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MacroDefinitionRule;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MacroReferenceRule;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MakefileWordDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakefileCodeScanner
extends AbstractMakefileCodeScanner {
    private static final String[] keywords = new String[]{"define", "endef", "ifdef", "ifndef", "ifeq", "ifneq", "else", "endif", "include", "-include", "sinclude", "override", "endef", "export", "unexport", "vpath"};
    private static final String[] functions = new String[]{"subst", "patsubst", "strip", "findstring", "filter", "sort", "dir", "notdir", "suffix", "basename", "addsuffix", "addprefix", "join", "word", "words", "wordlist", "firstword", "wildcard", "error", "warning", "shell", "origin", "foreach", "call"};
    static final String[] fTokenProperties = new String[]{"org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.comment", "org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.keyword", "org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.function", "org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.macro_ref", "org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.macro_def", "org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.default"};

    public MakefileCodeScanner() {
        this.initialize();
    }

    @Override
    protected List<IRule> createRules() {
        Token keyword = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.keyword");
        Token function = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.function");
        Token comment = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.comment");
        Token macroRef = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.macro_ref");
        Token macroDef = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.macro_def");
        Token other = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.automake.editor.default");
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new EndOfLineRule("#", (IToken)comment, '\\', true));
        rules.add((IRule)new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char character) {
                return Character.isWhitespace(character);
            }
        }));
        MultiLineRule defineRule = new MultiLineRule("define", "endef", (IToken)macroDef);
        defineRule.setColumnConstraint(0);
        rules.add((IRule)defineRule);
        rules.add((IRule)new MacroDefinitionRule((IToken)macroDef, (IToken)other));
        WordRule keyWordRule = new WordRule((IWordDetector)new MakefileWordDetector(), (IToken)other);
        int i = 0;
        while (i < keywords.length) {
            keyWordRule.addWord(keywords[i], (IToken)keyword);
            ++i;
        }
        keyWordRule.setColumnConstraint(0);
        rules.add((IRule)keyWordRule);
        WordRule functionRule = new WordRule((IWordDetector)new MakefileWordDetector(), (IToken)other);
        int i2 = 0;
        while (i2 < functions.length) {
            functionRule.addWord(functions[i2], (IToken)function);
            ++i2;
        }
        rules.add((IRule)functionRule);
        rules.add((IRule)new MacroReferenceRule((IToken)macroRef, "$(", ")"));
        rules.add((IRule)new MacroReferenceRule((IToken)macroRef, "${", "}"));
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }

    @Override
    protected String[] getTokenProperties() {
        return fTokenProperties;
    }
}

