/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.statesystem.HistoryBuilder;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateChangeInput;

class StateSystemBuildRequest
extends TmfEventRequest<CtfTmfEvent> {
    private static final int chunkSize = 50000;
    private final HistoryBuilder builder;
    private final IStateChangeInput sci;

    StateSystemBuildRequest(HistoryBuilder builder) {
        super(builder.getInputPlugin().getExpectedEventType().getClass(), TmfTimeRange.ETERNITY, Integer.MAX_VALUE, 50000, ITmfDataRequest.ExecutionType.BACKGROUND);
        this.builder = builder;
        this.sci = builder.getInputPlugin();
    }

    @Override
    public void handleData(CtfTmfEvent event) {
        super.handleData(event);
        if (event != null) {
            this.sci.processEvent(event);
        }
    }

    @Override
    public void handleSuccess() {
        super.handleSuccess();
        this.builder.finish(false);
    }

    @Override
    public void handleCancel() {
        super.handleCancel();
        this.builder.finish(true);
    }

    @Override
    public void handleFailure() {
        super.handleFailure();
        this.builder.finish(true);
    }
}

