/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;

public class CtfTmfTimestamp
extends TmfTimestamp {
    private TimestampType type;

    public CtfTmfTimestamp(long timestamp) {
        this.setValue(timestamp, -9, 0);
        this.type = TimestampType.DAY;
    }

    public void setType(TimestampType value) {
        this.type = value;
    }

    public TimestampType getType() {
        return this.type;
    }

    @Override
    public ITmfTimestamp getDelta(ITmfTimestamp ts) {
        TmfTimestamp parent = (TmfTimestamp)super.getDelta(ts);
        long value = parent.getValue();
        long exp = parent.getScale();
        long diff = exp + 9L;
        int i = 0;
        while ((long)i < diff) {
            value *= 10L;
            ++i;
        }
        CtfTmfTimestamp retVal = new CtfTmfTimestamp(value);
        retVal.type = value > 100000000L ? TimestampType.SECONDS : TimestampType.NANOS;
        return retVal;
    }

    @Override
    public String toString() {
        switch (this.type) {
            case DAY: {
                return this.dateToString();
            }
            case FULL_DATE: {
                return this.toFullDateString();
            }
            case NANOS: {
                return this.nanoToString();
            }
            case SECONDS: {
                return this.secondsToString();
            }
        }
        return super.toString();
    }

    private String secondsToString() {
        double timestamp = this.getValue();
        StringBuilder retVal = new StringBuilder();
        retVal.append(timestamp /= 1.0E9);
        retVal.append(" s");
        return retVal.toString();
    }

    private String nanoToString() {
        long timestamp = this.getValue();
        StringBuilder retVal = new StringBuilder();
        retVal.append(timestamp);
        retVal.append(" ns");
        return retVal.toString();
    }

    private String dateToString() {
        long timestamp = this.getValue();
        Date d = new Date(timestamp / 1000000L);
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.");
        long nanos = timestamp % 1000000000L;
        StringBuilder output = new StringBuilder();
        output.append(df.format(d));
        output.append(String.format("%09d", nanos));
        return output.toString();
    }

    private String toFullDateString() {
        long timestamp = this.getValue();
        Date d = new Date(timestamp / 1000000L);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
        long nanos = timestamp % 1000000000L;
        StringBuilder output = new StringBuilder();
        output.append(df.format(d));
        output.append(String.format("%09d", nanos));
        return output.toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() * 31;
        return result += this.type == null ? 0 : this.type.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CtfTmfTimestamp)) {
            return false;
        }
        CtfTmfTimestamp other = (CtfTmfTimestamp)obj;
        return this.type == other.type;
    }

    public static enum TimestampType {
        FULL_DATE,
        DAY,
        NANOS,
        SECONDS;

    }
}

