/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.findreplace;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.linuxtools.dataviewers.STDataViewersActivator;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.findreplace.EditorMessages;
import org.eclipse.linuxtools.dataviewers.findreplace.ISTFindReplaceTarget;
import org.eclipse.linuxtools.dataviewers.findreplace.RegExContentProposalProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.texteditor.IEditorStatusLine;

class STFindReplaceDialog
extends Dialog {
    private ViewerCell index;
    private ViewerCell findReplacePosition;
    private static final int HISTORY_SIZE = 5;
    private ViewerCell fIncrementalBaseLocation;
    private boolean fWrapInit = false;
    private boolean fCaseInit = false;
    private boolean fWholeWordInit = false;
    private boolean fForwardInit = true;
    private boolean fGlobalInit = true;
    private boolean fIncrementalInit = false;
    private boolean fNeedsInitialFindBeforeReplace;
    boolean fIsRegExInit = false;
    private List<String> fFindHistory;
    private List<String> fReplaceHistory;
    private boolean fIsTargetEditable;
    private ISTFindReplaceTarget fTarget = null;
    private Shell fParentShell = null;
    private Shell fActiveShell;
    private final ActivationListener fActivationListener = new ActivationListener();
    private final ModifyListener fFindModifyListener = new FindModifyListener();
    private Label fReplaceLabel;
    private Label fStatusLabel;
    private Button fForwardRadioButton;
    private Button fGlobalRadioButton;
    private Button fSelectedRangeRadioButton;
    private Button fCaseCheckBox;
    private Button fWrapCheckBox;
    private Button fWholeWordCheckBox;
    private Button fIncrementalCheckBox;
    private Button fIsRegExCheckBox;
    private Button fReplaceSelectionButton;
    private Button fReplaceFindButton;
    private Button fFindNextButton;
    private Button fReplaceAllButton;
    private Combo fFindField;
    private Combo fReplaceField;
    private ContentAssistCommandAdapter fContentAssistFindField;
    private ContentAssistCommandAdapter fContentAssistReplaceField;
    private Rectangle fDialogPositionInit = null;
    private IDialogSettings fDialogSettings;
    private boolean fIsTargetSupportingRegEx;
    private boolean fUseSelectedLines;
    private boolean fGiveFocusToFindField = true;

    public STFindReplaceDialog(Shell parentShell) {
        super(parentShell);
        this.fFindHistory = new ArrayList<String>(4);
        this.fReplaceHistory = new ArrayList<String>(4);
        this.readConfiguration();
        this.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }

    private boolean okToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.addShellListener((ShellListener)this.fActivationListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.find_replace_dialog_context");
        this.fFindField.removeModifyListener(this.fFindModifyListener);
        this.updateCombo(this.fFindField, this.fFindHistory);
        this.fFindField.addModifyListener(this.fFindModifyListener);
        this.updateCombo(this.fReplaceField, this.fReplaceHistory);
        this.initFindStringFromSelection();
        if (this.fDialogPositionInit != null) {
            shell.setBounds(this.fDialogPositionInit);
        }
        shell.setText(EditorMessages.FindReplace_title);
    }

    private Composite createButtonSection(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = -2;
        panel.setLayout((Layout)layout);
        this.fFindNextButton = this.makeButton(panel, EditorMessages.FindReplace_FindNextButton_label, 102, true, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (STFindReplaceDialog.this.isIncrementalSearch() && !STFindReplaceDialog.this.isRegExSearchAvailableAndChecked()) {
                    STFindReplaceDialog.this.initIncrementalBaseLocation();
                }
                STFindReplaceDialog.this.fNeedsInitialFindBeforeReplace = false;
                STFindReplaceDialog.this.performSearch();
                STFindReplaceDialog.this.updateFindHistory();
                STFindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fFindNextButton, 4, true, 4, false);
        this.fReplaceFindButton = this.makeButton(panel, EditorMessages.FindReplace_ReplaceFindButton_label, 103, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.setGridData((Control)this.fReplaceFindButton, 4, false, 4, false);
        this.fReplaceSelectionButton = this.makeButton(panel, EditorMessages.FindReplace_ReplaceSelectionButton_label, 104, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.setGridData((Control)this.fReplaceSelectionButton, 4, false, 4, false);
        this.fReplaceAllButton = this.makeButton(panel, EditorMessages.FindReplace_ReplaceAllButton_label, 105, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.setGridData((Control)this.fReplaceAllButton, 4, true, 4, false);
        this.fReplaceAllButton.setEnabled(this.isEditable());
        return panel;
    }

    private Composite createConfigPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        Composite directionGroup = this.createDirectionGroup(panel);
        this.setGridData((Control)directionGroup, 4, true, 4, false);
        Composite scopeGroup = this.createScopeGroup(panel);
        this.setGridData((Control)scopeGroup, 4, true, 4, false);
        Composite optionsGroup = this.createOptionsGroup(panel);
        this.setGridData((Control)optionsGroup, 4, true, 4, true);
        ((GridData)optionsGroup.getLayoutData()).horizontalSpan = 2;
        return panel;
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite inputPanel = this.createInputPanel(panel);
        this.setGridData((Control)inputPanel, 4, true, 128, false);
        Composite configPanel = this.createConfigPanel(panel);
        this.setGridData((Control)configPanel, 4, true, 128, true);
        Composite buttonPanelB = this.createButtonSection(panel);
        this.setGridData((Control)buttonPanelB, 131072, true, 1024, false);
        Composite statusBar = this.createStatusAndCloseButton(panel);
        this.setGridData((Control)statusBar, 4, true, 1024, false);
        this.updateButtonState();
        STFindReplaceDialog.applyDialogFont((Control)panel);
        return panel;
    }

    private void setContentAssistsEnablement(boolean enable) {
        this.fContentAssistFindField.setEnabled(enable);
        this.fContentAssistReplaceField.setEnabled(enable);
    }

    private Composite createDirectionGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText(EditorMessages.FindReplace_Direction);
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                STFindReplaceDialog.this.calcolateIndex(STFindReplaceDialog.this.fForwardRadioButton.getSelection());
                if (STFindReplaceDialog.this.isIncrementalSearch() && !STFindReplaceDialog.this.isRegExSearchAvailableAndChecked()) {
                    STFindReplaceDialog.this.initIncrementalBaseLocation();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fForwardRadioButton = new Button((Composite)group, 16400);
        this.fForwardRadioButton.setText(EditorMessages.FindReplace_ForwardRadioButton_label);
        this.setGridData((Control)this.fForwardRadioButton, 16384, false, 0x1000000, false);
        this.fForwardRadioButton.addSelectionListener(selectionListener);
        Button backwardRadioButton = new Button((Composite)group, 16400);
        backwardRadioButton.setText(EditorMessages.FindReplace_BackwardRadioButton_label);
        this.setGridData((Control)backwardRadioButton, 16384, false, 0x1000000, false);
        backwardRadioButton.addSelectionListener(selectionListener);
        backwardRadioButton.setSelection(!this.fForwardInit);
        backwardRadioButton.setEnabled(true);
        this.fForwardRadioButton.setSelection(this.fForwardInit);
        return panel;
    }

    private Composite createScopeGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText(EditorMessages.FindReplace_Scope);
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fGlobalRadioButton = new Button((Composite)group, 16400);
        this.fGlobalRadioButton.setText(EditorMessages.FindReplace_GlobalRadioButton_label);
        this.setGridData((Control)this.fGlobalRadioButton, 16384, false, 0x1000000, false);
        this.fGlobalRadioButton.setSelection(this.fGlobalInit);
        this.fGlobalRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!STFindReplaceDialog.this.fGlobalRadioButton.getSelection() || !STFindReplaceDialog.this.fUseSelectedLines) {
                    return;
                }
                STFindReplaceDialog.this.fUseSelectedLines = false;
                STFindReplaceDialog.this.useSelectedLines(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fSelectedRangeRadioButton = new Button((Composite)group, 16400);
        this.fSelectedRangeRadioButton.setText(EditorMessages.FindReplace_SelectedRangeRadioButton_label);
        this.setGridData((Control)this.fSelectedRangeRadioButton, 16384, false, 0x1000000, false);
        this.fSelectedRangeRadioButton.setSelection(!this.fGlobalInit);
        this.fUseSelectedLines = !this.fGlobalInit;
        this.fSelectedRangeRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!STFindReplaceDialog.this.fSelectedRangeRadioButton.getSelection() || STFindReplaceDialog.this.fUseSelectedLines) {
                    return;
                }
                STFindReplaceDialog.this.fUseSelectedLines = true;
                STFindReplaceDialog.this.useSelectedLines(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return panel;
    }

    private void useSelectedLines(boolean selectedLines) {
        if (this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked()) {
            this.initIncrementalBaseLocation();
        }
        if (this.fTarget == null) {
            return;
        }
        this.fTarget.useSelectedLines(selectedLines);
    }

    private Composite createInputPanel(Composite parent) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                STFindReplaceDialog.this.updateButtonState();
            }
        };
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label findLabel = new Label(panel, 16384);
        findLabel.setText(EditorMessages.FindReplace_Find_label);
        this.setGridData((Control)findLabel, 16384, false, 0x1000000, false);
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        RegExContentProposalProvider findProposer = new RegExContentProposalProvider(true);
        this.fFindField = new Combo(panel, 2052);
        this.fContentAssistFindField = new ContentAssistCommandAdapter((Control)this.fFindField, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[]{'\\', '[', '('}, true);
        this.setGridData((Control)this.fFindField, 4, true, 0x1000000, false);
        this.addDecorationMargin((Control)this.fFindField);
        this.fFindField.addModifyListener(this.fFindModifyListener);
        this.fReplaceLabel = new Label(panel, 16384);
        this.fReplaceLabel.setText(EditorMessages.FindReplace_Replace_label);
        this.setGridData((Control)this.fReplaceLabel, 16384, false, 0x1000000, false);
        RegExContentProposalProvider replaceProposer = new RegExContentProposalProvider(false);
        this.fReplaceField = new Combo(panel, 2052);
        this.fContentAssistReplaceField = new ContentAssistCommandAdapter((Control)this.fReplaceField, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)replaceProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[]{'$'}, true);
        this.setGridData((Control)this.fReplaceField, 4, true, 0x1000000, false);
        this.addDecorationMargin((Control)this.fReplaceField);
        this.fReplaceField.addModifyListener(listener);
        return panel;
    }

    private Composite createOptionsGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 32);
        group.setText(EditorMessages.FindReplace_Options);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        groupLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                STFindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fCaseCheckBox = new Button((Composite)group, 16416);
        this.fCaseCheckBox.setText(EditorMessages.FindReplace_CaseCheckBox_label);
        this.setGridData((Control)this.fCaseCheckBox, 16384, false, 0x1000000, false);
        this.fCaseCheckBox.setSelection(this.fCaseInit);
        this.fCaseCheckBox.addSelectionListener(selectionListener);
        this.fWrapCheckBox = new Button((Composite)group, 16416);
        this.fWrapCheckBox.setText(EditorMessages.FindReplace_WrapCheckBox_label);
        this.setGridData((Control)this.fWrapCheckBox, 16384, false, 0x1000000, false);
        this.fWrapCheckBox.setSelection(this.fWrapInit);
        this.fWrapCheckBox.addSelectionListener(selectionListener);
        this.fWholeWordCheckBox = new Button((Composite)group, 16416);
        this.fWholeWordCheckBox.setText(EditorMessages.FindReplace_WholeWordCheckBox_label);
        this.setGridData((Control)this.fWholeWordCheckBox, 16384, false, 0x1000000, false);
        this.fWholeWordCheckBox.setSelection(this.fWholeWordInit);
        this.fWholeWordCheckBox.addSelectionListener(selectionListener);
        this.fIncrementalCheckBox = new Button((Composite)group, 16416);
        this.fIncrementalCheckBox.setText(EditorMessages.FindReplace_IncrementalCheckBox_label);
        this.setGridData((Control)this.fIncrementalCheckBox, 16384, false, 0x1000000, false);
        this.fIncrementalCheckBox.setSelection(this.fIncrementalInit);
        this.fIncrementalCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (STFindReplaceDialog.this.isIncrementalSearch() && !STFindReplaceDialog.this.isRegExSearch()) {
                    STFindReplaceDialog.this.initIncrementalBaseLocation();
                }
                STFindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fIncrementalCheckBox.setEnabled(false);
        this.fIsRegExCheckBox = new Button((Composite)group, 16416);
        this.fIsRegExCheckBox.setText(EditorMessages.FindReplace_RegExCheckbox_label);
        this.setGridData((Control)this.fIsRegExCheckBox, 16384, false, 0x1000000, false);
        ((GridData)this.fIsRegExCheckBox.getLayoutData()).horizontalSpan = 2;
        this.fIsRegExCheckBox.setSelection(this.fIsRegExInit);
        this.fIsRegExCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newState = STFindReplaceDialog.this.fIsRegExCheckBox.getSelection();
                STFindReplaceDialog.this.fIncrementalCheckBox.setEnabled(!newState);
                STFindReplaceDialog.this.updateButtonState();
                STFindReplaceDialog.this.storeSettings();
                STFindReplaceDialog.this.setContentAssistsEnablement(newState);
            }
        });
        this.fWholeWordCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        this.fWholeWordCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                STFindReplaceDialog.this.updateButtonState();
            }
        });
        this.fIncrementalCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        return panel;
    }

    private Composite createStatusAndCloseButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        this.fStatusLabel = new Label(panel, 16384);
        this.setGridData((Control)this.fStatusLabel, 4, true, 0x1000000, false);
        String label = EditorMessages.FindReplace_CloseButton_label;
        Button closeButton = this.createButton(panel, 101, label, false);
        this.setGridData((Control)closeButton, 131072, false, 1024, false);
        return panel;
    }

    protected void buttonPressed(int buttonID) {
        if (buttonID == 101) {
            this.close();
        }
    }

    private ViewerCell findIndex(String findString, ViewerCell startPosition, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean regExSearch) {
        if (forwardSearch) {
            if (wrapSearch) {
                ViewerCell index = this.findAndSelect(startPosition, findString, true, caseSensitive, wholeWord, regExSearch, wrapSearch);
                if (index == null) {
                    if (this.okToUse((Control)this.getShell()) && !this.isIncrementalSearch()) {
                        this.getShell().getDisplay().beep();
                    }
                    index = this.findAndSelect(this.fTarget.getFirstCell(startPosition, 1), findString, true, caseSensitive, wholeWord, regExSearch, wrapSearch);
                }
                return index;
            }
            return this.findAndSelect(startPosition, findString, true, caseSensitive, wholeWord, regExSearch, wrapSearch);
        }
        if (wrapSearch) {
            ViewerCell index = this.findAndSelect(startPosition, findString, false, caseSensitive, wholeWord, regExSearch, wrapSearch);
            if (index == null) {
                if (this.okToUse((Control)this.getShell()) && !this.isIncrementalSearch()) {
                    this.getShell().getDisplay().beep();
                }
                index = this.findAndSelect(this.fTarget.getFirstCell(startPosition, 2), findString, false, caseSensitive, wholeWord, regExSearch, wrapSearch);
            }
            return index;
        }
        return this.findAndSelect(startPosition, findString, false, caseSensitive, wholeWord, regExSearch, wrapSearch);
    }

    private ViewerCell findAndSelect(ViewerCell offset, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch, boolean wrapSearch) {
        if (this.fTarget != null) {
            return this.fTarget.findAndSelect(offset, findString, forwardSearch, caseSensitive, wholeWord, wrapSearch, regExSearch);
        }
        return null;
    }

    ViewerCell replaceSelection(String replaceString, boolean regExReplace) {
        return this.fTarget.getSelection(this.index);
    }

    private boolean findNext(String findString, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean incremental, boolean regExSearch) {
        if (this.fTarget == null) {
            return false;
        }
        ViewerCell r = null;
        r = incremental ? this.fIncrementalBaseLocation : this.fTarget.getSelection(this.index);
        if (this.findReplacePosition != null) {
            AbstractSTViewer target = (AbstractSTViewer)((Object)this.fTarget);
            if (target.getAllFields()[this.findReplacePosition.getColumnIndex()].getSpecialDrawer(this.findReplacePosition.getElement()) != null) {
                this.findReplacePosition.setBackground(target.getAllFields()[this.findReplacePosition.getColumnIndex()].getBackground(this.findReplacePosition.getElement()));
            } else {
                this.fTarget.getViewer().refresh(this.findReplacePosition.getElement());
            }
        }
        this.findReplacePosition = r;
        this.findReplacePosition = this.findIndex(findString, this.findReplacePosition, forwardSearch, caseSensitive, wrapSearch, wholeWord, regExSearch);
        if (this.findReplacePosition != null) {
            this.findReplacePosition.setBackground(this.findReplacePosition.getControl().getShell().getDisplay().getSystemColor(5));
            this.calcolateIndex(forwardSearch);
            this.fNeedsInitialFindBeforeReplace = false;
            return true;
        }
        return false;
    }

    private void calcolateIndex(boolean forwardSearch) {
        if (forwardSearch) {
            if (this.findReplacePosition.getNeighbor(ViewerCell.RIGHT, true) != null) {
                this.index = this.findReplacePosition.getNeighbor(ViewerCell.RIGHT, true);
            } else {
                ViewerRow row = this.findReplacePosition.getViewerRow();
                this.index = row.getNeighbor(2, true).getCell(0);
            }
        } else if (this.findReplacePosition.getNeighbor(ViewerCell.LEFT, true) != null) {
            this.index = this.findReplacePosition.getNeighbor(ViewerCell.LEFT, true);
        } else {
            ViewerRow row = this.findReplacePosition.getViewerRow();
            this.index = row.getNeighbor(1, true).getCell(0);
        }
    }

    private Rectangle getDialogBoundaries() {
        if (this.okToUse((Control)this.getShell())) {
            return this.getShell().getBounds();
        }
        return this.fDialogPositionInit;
    }

    private List<String> getFindHistory() {
        return this.fFindHistory;
    }

    private String getFindString() {
        if (this.okToUse((Control)this.fFindField)) {
            return this.fFindField.getText();
        }
        return "";
    }

    private List<String> getReplaceHistory() {
        return this.fReplaceHistory;
    }

    private String getReplaceString() {
        if (this.okToUse((Control)this.fReplaceField)) {
            return this.fReplaceField.getText();
        }
        return "";
    }

    private String getSelectionString() {
        String selection = this.fTarget.getSelectionText(this.index);
        if (selection != null && selection.length() > 0) {
            int[] info = TextUtilities.indexOf((String[])TextUtilities.DELIMITERS, (String)selection, (int)0);
            if (info[0] > 0) {
                return selection.substring(0, info[0]);
            }
            if (info[0] == -1) {
                return selection;
            }
        }
        return null;
    }

    public boolean close() {
        this.handleDialogClose();
        return super.close();
    }

    private void handleDialogClose() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener(this.fFindModifyListener);
        }
        if (this.fParentShell != null) {
            this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            this.fParentShell = null;
        }
        this.getShell().removeShellListener((ShellListener)this.fActivationListener);
        this.storeSettings();
        this.fActiveShell = null;
        this.fTarget = null;
    }

    private void writeSelection() {
        if (this.fTarget == null) {
            return;
        }
        String selection = this.fTarget.getSelectionText(this.index);
        if (selection == null) {
            selection = "";
        }
        IDialogSettings s = this.getDialogSettings();
        s.put("selection", selection);
    }

    private void storeSettings() {
        this.fDialogPositionInit = this.getDialogBoundaries();
        this.fWrapInit = this.isWrapSearch();
        this.fWholeWordInit = this.isWholeWordSetting();
        this.fCaseInit = this.isCaseSensitiveSearch();
        this.fIsRegExInit = this.isRegExSearch();
        this.fIncrementalInit = this.isIncrementalSearch();
        this.fForwardInit = this.isForwardSearch();
        this.writeConfiguration();
    }

    private void initFindStringFromSelection() {
        if (this.fTarget != null && this.okToUse((Control)this.fFindField)) {
            String selection = this.getSelectionString();
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            if (selection != null) {
                this.fFindField.setText(selection);
                if (!selection.equals(this.fTarget.getSelectionText(this.index))) {
                    this.useSelectedLines(true);
                    this.fGlobalRadioButton.setSelection(false);
                    this.fSelectedRangeRadioButton.setSelection(true);
                    this.fUseSelectedLines = true;
                }
            } else if ("".equals(this.fFindField.getText())) {
                if (this.fFindHistory.size() > 0) {
                    this.fFindField.setText(this.fFindHistory.get(0));
                } else {
                    this.fFindField.setText("");
                }
            }
            this.fFindField.setSelection(new Point(0, this.fFindField.getText().length()));
            this.fFindField.addModifyListener(this.fFindModifyListener);
        }
    }

    private void initIncrementalBaseLocation() {
        this.fIncrementalBaseLocation = this.fTarget != null && this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked() ? this.fTarget.getSelection(this.index) : null;
    }

    private boolean isCaseSensitiveSearch() {
        if (this.okToUse((Control)this.fCaseCheckBox)) {
            return this.fCaseCheckBox.getSelection();
        }
        return this.fCaseInit;
    }

    private boolean isRegExSearch() {
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            return this.fIsRegExCheckBox.getSelection();
        }
        return this.fIsRegExInit;
    }

    private boolean isRegExSearchAvailableAndChecked() {
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            return this.fIsTargetSupportingRegEx && this.fIsRegExCheckBox.getSelection();
        }
        return this.fIsRegExInit;
    }

    private boolean isForwardSearch() {
        if (this.okToUse((Control)this.fForwardRadioButton)) {
            return this.fForwardRadioButton.getSelection();
        }
        return this.fForwardInit;
    }

    private boolean isWholeWordSetting() {
        if (this.okToUse((Control)this.fWholeWordCheckBox)) {
            return this.fWholeWordCheckBox.getSelection();
        }
        return this.fWholeWordInit;
    }

    private boolean isWholeWordSearch() {
        return this.isWholeWordSetting() && !this.isRegExSearchAvailableAndChecked() && (!this.okToUse((Control)this.fWholeWordCheckBox) || this.fWholeWordCheckBox.isEnabled());
    }

    private boolean isWrapSearch() {
        if (this.okToUse((Control)this.fWrapCheckBox)) {
            return this.fWrapCheckBox.getSelection();
        }
        return this.fWrapInit;
    }

    private boolean isIncrementalSearch() {
        if (this.okToUse((Control)this.fIncrementalCheckBox)) {
            return this.fIncrementalCheckBox.getSelection();
        }
        return this.fIncrementalInit;
    }

    private Button makeButton(Composite parent, String label, int id, boolean dfltButton, SelectionListener listener) {
        Button b = this.createButton(parent, id, label, dfltButton);
        b.addSelectionListener(listener);
        return b;
    }

    private IEditorStatusLine getStatusLineManager() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
        IEditorStatusLine statusLine = this.getStatusLineManager();
        if (statusLine != null) {
            statusLine.setMessage(error, message, null);
        }
        if (error) {
            this.getShell().getDisplay().beep();
        }
    }

    private void statusError(String message) {
        this.statusMessage(true, message);
    }

    private void statusMessage(String message) {
        this.statusMessage(false, message);
    }

    private void performSearch() {
        this.performSearch(this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked());
    }

    private void performSearch(boolean mustInitIncrementalBaseLocation) {
        if (mustInitIncrementalBaseLocation) {
            this.initIncrementalBaseLocation();
        }
        String findString = this.getFindString();
        if (this.fIncrementalBaseLocation != null) {
            findString = String.valueOf(findString) + this.fIncrementalBaseLocation.getText();
        }
        boolean somethingFound = false;
        if (findString != null && findString.length() > 0) {
            try {
                somethingFound = this.findNext(findString, this.isForwardSearch(), this.isCaseSensitiveSearch(), this.isWrapSearch(), this.isWholeWordSearch(), this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked(), this.isRegExSearchAvailableAndChecked());
                if (somethingFound) {
                    this.statusMessage("");
                } else {
                    this.statusMessage(EditorMessages.FindReplace_Status_noMatch_label);
                }
            }
            catch (PatternSyntaxException ex) {
                this.statusError(ex.getLocalizedMessage());
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.writeSelection();
        this.updateButtonState(!somethingFound);
    }

    private void setGridData(Control component, int horizontalAlignment, boolean grabExcessHorizontalSpace, int verticalAlignment, boolean grabExcessVerticalSpace) {
        GridData gd;
        if (component instanceof Button && (((Button)component).getStyle() & 8) != 0) {
            gd = (GridData)component.getLayoutData();
            gd.horizontalAlignment = 4;
        } else {
            gd = new GridData();
            component.setLayoutData((Object)gd);
            gd.horizontalAlignment = horizontalAlignment;
            gd.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        }
        gd.verticalAlignment = verticalAlignment;
        gd.grabExcessVerticalSpace = grabExcessVerticalSpace;
    }

    private void addDecorationMargin(Control control) {
        Object layoutData = control.getLayoutData();
        if (!(layoutData instanceof GridData)) {
            return;
        }
        GridData gd = (GridData)layoutData;
        FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        gd.horizontalIndent = dec.getImage().getBounds().width;
    }

    private void updateButtonState() {
        this.updateButtonState(false);
    }

    private void updateButtonState(boolean disableReplace) {
        if (this.okToUse((Control)this.getShell()) && this.okToUse((Control)this.fFindNextButton)) {
            boolean enable = this.fTarget != null && (this.fActiveShell == this.fParentShell || this.fActiveShell == this.getShell());
            String str = this.getFindString();
            boolean findString = str != null && str.length() > 0;
            this.fWholeWordCheckBox.setEnabled(this.isWord(str) && !this.isRegExSearchAvailableAndChecked());
            this.fFindNextButton.setEnabled(enable && findString);
            this.fReplaceSelectionButton.setEnabled(false);
            this.fReplaceFindButton.setEnabled(false);
            this.fReplaceAllButton.setEnabled(false);
        }
    }

    private boolean isWord(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void updateCombo(Combo combo, List<String> content) {
        combo.removeAll();
        int i = 0;
        while (i < content.size()) {
            combo.add(content.get(i).toString());
            ++i;
        }
    }

    private void updateFindHistory() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            this.updateHistory(this.fFindField, this.fFindHistory);
            this.fFindField.addModifyListener(this.fFindModifyListener);
        }
    }

    private void updateHistory(Combo combo, List<String> history) {
        String findString = combo.getText();
        int index = history.indexOf(findString);
        if (index != 0) {
            if (index != -1) {
                history.remove(index);
            }
            history.add(0, findString);
            this.updateCombo(combo, history);
            combo.setText(findString);
        }
    }

    private boolean isEditable() {
        boolean isEditable;
        boolean bl = isEditable = this.fTarget == null ? false : this.fTarget.isEditable();
        return this.fIsTargetEditable && isEditable;
    }

    public void updateTarget(ISTFindReplaceTarget target, boolean isTargetEditable, boolean initializeFindString) {
        this.fIsTargetEditable = isTargetEditable;
        this.fNeedsInitialFindBeforeReplace = true;
        if (target != this.fTarget) {
            this.fTarget = target;
            if (this.fTarget != null) {
                this.fIsTargetSupportingRegEx = true;
                this.fGlobalInit = true;
                this.fGlobalRadioButton.setSelection(this.fGlobalInit);
                this.fSelectedRangeRadioButton.setSelection(!this.fGlobalInit);
                boolean bl = this.fUseSelectedLines = !this.fGlobalInit;
            }
        }
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            this.fIsRegExCheckBox.setEnabled(this.fIsTargetSupportingRegEx);
        }
        if (this.okToUse((Control)this.fWholeWordCheckBox)) {
            this.fWholeWordCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        }
        if (this.okToUse((Control)this.fReplaceLabel)) {
            this.fReplaceLabel.setEnabled(this.isEditable());
            this.fReplaceField.setEnabled(this.isEditable());
            if (initializeFindString) {
                this.initFindStringFromSelection();
                this.fGiveFocusToFindField = true;
            }
            this.initIncrementalBaseLocation();
            this.updateButtonState();
        }
        this.setContentAssistsEnablement(this.isRegExSearchAvailableAndChecked());
    }

    public void setParentShell(Shell shell) {
        if (shell != this.fParentShell) {
            if (this.fParentShell != null) {
                this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fParentShell = shell;
            this.fParentShell.addShellListener((ShellListener)this.fActivationListener);
        }
        this.fActiveShell = shell;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = STDataViewersActivator.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.fDialogSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
        IDialogSettings settings = STDataViewersActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    private void readConfiguration() {
        String[] replaceHistory;
        IDialogSettings s = this.getDialogSettings();
        this.fWrapInit = s.getBoolean("wrap");
        this.fCaseInit = s.getBoolean("casesensitive");
        this.fWholeWordInit = s.getBoolean("wholeword");
        this.fIncrementalInit = s.getBoolean("incremental");
        this.fIsRegExInit = s.getBoolean("isRegEx");
        String[] findHistory = s.getArray("findhistory");
        if (findHistory != null) {
            List<String> history = this.getFindHistory();
            history.clear();
            int i = 0;
            while (i < findHistory.length) {
                history.add(findHistory[i]);
                ++i;
            }
        }
        if ((replaceHistory = s.getArray("replacehistory")) != null) {
            List<String> history = this.getReplaceHistory();
            history.clear();
            int i = 0;
            while (i < replaceHistory.length) {
                history.add(replaceHistory[i]);
                ++i;
            }
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put("wrap", this.fWrapInit);
        s.put("casesensitive", this.fCaseInit);
        s.put("wholeword", this.fWholeWordInit);
        s.put("incremental", this.fIncrementalInit);
        s.put("isRegEx", this.fIsRegExInit);
        List<String> history = this.getFindHistory();
        String findString = this.getFindString();
        if (findString.length() > 0) {
            history.add(0, findString);
        }
        this.writeHistory(history, s, "findhistory");
        history = this.getReplaceHistory();
        String replaceString = this.getReplaceString();
        if (replaceString.length() > 0) {
            history.add(0, replaceString);
        }
        this.writeHistory(history, s, "replacehistory");
    }

    private void writeHistory(List<String> history, IDialogSettings settings, String sectionName) {
        int itemCount = history.size();
        HashSet<String> distinctItems = new HashSet<String>(itemCount);
        int i = 0;
        while (i < itemCount) {
            String item = history.get(i);
            if (distinctItems.contains(item)) {
                history.remove(i--);
                --itemCount;
            } else {
                distinctItems.add(item);
            }
            ++i;
        }
        while (history.size() > 8) {
            history.remove(8);
        }
        String[] names = new String[history.size()];
        history.toArray(names);
        settings.put(sectionName, names);
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent e) {
            STFindReplaceDialog.this.fActiveShell = (Shell)e.widget;
            STFindReplaceDialog.this.updateButtonState();
            if (STFindReplaceDialog.this.fGiveFocusToFindField && STFindReplaceDialog.this.getShell() == STFindReplaceDialog.this.fActiveShell && STFindReplaceDialog.this.okToUse((Control)STFindReplaceDialog.this.fFindField)) {
                STFindReplaceDialog.this.fFindField.setFocus();
            }
        }

        public void shellDeactivated(ShellEvent e) {
            STFindReplaceDialog.this.fGiveFocusToFindField = false;
            STFindReplaceDialog.this.storeSettings();
            STFindReplaceDialog.this.fGlobalRadioButton.setSelection(true);
            STFindReplaceDialog.this.fSelectedRangeRadioButton.setSelection(false);
            STFindReplaceDialog.this.fUseSelectedLines = false;
            STFindReplaceDialog.this.fActiveShell = null;
            STFindReplaceDialog.this.updateButtonState();
        }
    }

    private class FindModifyListener
    implements ModifyListener {
        private FindModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (STFindReplaceDialog.this.isIncrementalSearch() && !STFindReplaceDialog.this.isRegExSearchAvailableAndChecked()) {
                if (STFindReplaceDialog.this.fFindField.getText().equals("") && STFindReplaceDialog.this.fTarget != null) {
                    ViewerCell start = STFindReplaceDialog.this.fIncrementalBaseLocation;
                    if ((STFindReplaceDialog.this.isForwardSearch() && !STFindReplaceDialog.this.fNeedsInitialFindBeforeReplace || !STFindReplaceDialog.this.isForwardSearch() && STFindReplaceDialog.this.fNeedsInitialFindBeforeReplace) && start.getNeighbor(ViewerCell.RIGHT, true) == null) {
                        start.getNeighbor(ViewerCell.BELOW, true);
                    }
                    STFindReplaceDialog.this.fNeedsInitialFindBeforeReplace = false;
                    STFindReplaceDialog.this.findAndSelect(start, "", STFindReplaceDialog.this.isForwardSearch(), STFindReplaceDialog.this.isCaseSensitiveSearch(), STFindReplaceDialog.this.isWholeWordSearch(), STFindReplaceDialog.this.isRegExSearchAvailableAndChecked(), STFindReplaceDialog.this.isWrapSearch());
                } else {
                    STFindReplaceDialog.this.performSearch(false);
                }
            }
            STFindReplaceDialog.this.updateButtonState(!STFindReplaceDialog.this.isIncrementalSearch());
        }
    }
}

