/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.util.Collection;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Vector;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputPacketReader;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;
import org.eclipse.linuxtools.internal.ctf.core.Activator;
import org.eclipse.linuxtools.internal.ctf.core.trace.Stream;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInput;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputReaderTimestampComparator;

public class CTFTraceReader {
    private final CTFTrace trace;
    private final Vector<StreamInputReader> streamInputReaders = new Vector();
    protected PriorityQueue<StreamInputReader> prio;
    private int[] eventCountPerTraceFile;
    private long startTime;
    private long endTime;
    private long fIndex;
    private final HashMap<Integer, Long> startIndex;

    protected void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public CTFTraceReader(CTFTrace trace) {
        this.trace = trace;
        this.createStreamInputReaders();
        this.populateStreamInputReaderHeap();
        this.startTime = 0L;
        if (this.hasMoreEvents()) {
            this.startTime = this.prio.peek().getCurrentEvent().getTimestamp();
            this.setEndTime(this.startTime);
            this.fIndex = 0L;
        }
        this.startIndex = new HashMap();
    }

    public CTFTraceReader copyFrom() {
        CTFTraceReader newReader = null;
        newReader = new CTFTraceReader(this.trace);
        newReader.startTime = this.startTime;
        newReader.setEndTime(this.endTime);
        return newReader;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getIndex() {
        return this.fIndex;
    }

    private void createStreamInputReaders() {
        Collection<Stream> streams = this.trace.getStreams().values();
        for (Stream stream : streams) {
            Set<StreamInput> streamInputs = stream.getStreamInputs();
            for (StreamInput streamInput : streamInputs) {
                StreamInputReader streamInputReader = new StreamInputReader(streamInput);
                this.streamInputReaders.add(streamInputReader);
            }
        }
        this.eventCountPerTraceFile = new int[this.streamInputReaders.size()];
    }

    private void populateStreamInputReaderHeap() {
        this.prio = new PriorityQueue<StreamInputReader>(this.streamInputReaders.size() * 2, new StreamInputReaderTimestampComparator());
        int pos = 0;
        for (StreamInputReader reader : this.streamInputReaders) {
            if (!reader.readNextEvent()) continue;
            this.prio.add(reader);
            this.eventCountPerTraceFile[pos] = 0;
            reader.setName(pos);
            ++pos;
        }
    }

    public EventDefinition getCurrentEventDef() {
        StreamInputReader top = this.getTopStream();
        return top != null ? top.getCurrentEvent() : null;
    }

    public boolean advance() {
        StreamInputReader top = this.prio.poll();
        if (top == null) {
            return false;
        }
        if (this.hasMoreEvents()) {
            StreamInputPacketReader packetReader = top.getPacketReader();
            boolean packetHasMoreEvents = packetReader.hasMoreEvents();
            StreamInputPacketIndexEntry currentPacket = packetReader.getCurrentPacket();
            if (!packetHasMoreEvents) {
                int n = this.streamInputReaders.indexOf(top);
                if (!this.startIndex.containsKey(n)) {
                    this.startIndex.put(n, 0L);
                }
                currentPacket.setIndexBegin(this.startIndex.get(n));
                currentPacket.setIndexEnd(this.fIndex);
                this.startIndex.put(n, this.fIndex + 1L);
            }
        }
        if (top.readNextEvent()) {
            this.prio.add(top);
            long topEnd = top.getCurrentEvent().getTimestamp() + this.getTrace().getOffset();
            this.setEndTime(Math.max(topEnd, this.getEndTime()));
            int n = top.getName();
            this.eventCountPerTraceFile[n] = this.eventCountPerTraceFile[n] + 1;
            ++this.fIndex;
        }
        boolean hasMoreEvents = this.hasMoreEvents();
        return hasMoreEvents;
    }

    public void goToLastEvent() throws CTFReaderException {
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            streamInputReader.goToLastEvent();
        }
        int count = this.prio.size();
        int i = 0;
        while (i < count - 1) {
            this.prio.poll();
            ++i;
        }
    }

    public boolean seek(long timestamp) {
        this.prio.clear();
        this.fIndex = 0L;
        long offset = 0L;
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            offset += streamInputReader.seek(timestamp);
        }
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            if (streamInputReader.getCurrentEvent() == null) continue;
            this.prio.add(streamInputReader);
            this.fIndex = Math.max(this.fIndex, streamInputReader.getPacketReader().getCurrentPacket().getIndexBegin() + offset);
        }
        return this.hasMoreEvents();
    }

    public boolean seekIndex(long index) {
        this.prio.clear();
        long tempIndex = Long.MIN_VALUE;
        long tempTimestamp = Long.MIN_VALUE;
        try {
            for (StreamInputReader streamInputReader : this.streamInputReaders) {
                long streamIndex = streamInputReader.seekIndex(index);
                if (streamInputReader.getCurrentEvent() == null) continue;
                tempIndex = Math.max(tempIndex, streamIndex);
                EventDefinition currentEvent = streamInputReader.getCurrentEvent();
                if (currentEvent == null) {
                    streamInputReader.readNextEvent();
                    currentEvent = streamInputReader.getCurrentEvent();
                }
                if (currentEvent != null) {
                    tempTimestamp = Math.max(tempTimestamp, currentEvent.getTimestamp());
                    continue;
                }
                tempIndex = this.goToZero();
            }
        }
        catch (CTFReaderException cTFReaderException) {
            tempIndex = this.goToZero();
        }
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            if (streamInputReader.getCurrentEvent() == null) continue;
            this.prio.add(streamInputReader);
        }
        if (tempIndex == Long.MAX_VALUE) {
            tempIndex = 0L;
        }
        long pos = tempIndex;
        if (index > tempIndex) {
            while (this.prio.peek().getCurrentEvent().getTimestamp() < tempTimestamp && this.hasMoreEvents()) {
                this.advance();
            }
            pos = tempIndex;
            while (pos < index && this.hasMoreEvents()) {
                this.advance();
                ++pos;
            }
        }
        this.fIndex = pos;
        return this.hasMoreEvents();
    }

    private long goToZero() {
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            streamInputReader.seek(0L);
        }
        long tempIndex = 0L;
        return tempIndex;
    }

    public StreamInputReader getTopStream() {
        return this.prio.peek();
    }

    public boolean hasMoreEvents() {
        return this.prio.size() > 0;
    }

    public void printStats() {
        this.printStats(60);
    }

    public void printStats(int width) {
        int numEvents = 0;
        if (width == 0) {
            return;
        }
        int[] nArray = this.eventCountPerTraceFile;
        int n = this.eventCountPerTraceFile.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            numEvents += i;
            ++n2;
        }
        int j = 0;
        while (j < this.eventCountPerTraceFile.length) {
            StreamInputReader se = this.streamInputReaders.get(j);
            int len = width * this.eventCountPerTraceFile[se.getName()] / numEvents;
            StringBuilder sb = new StringBuilder(String.valueOf(se.getFilename()) + "\t[");
            int i = 0;
            while (i < len) {
                sb.append('+');
                ++i;
            }
            i = len;
            while (i < width) {
                sb.append(' ');
                ++i;
            }
            sb.append("]\t" + this.eventCountPerTraceFile[se.getName()] + " Events");
            Activator.getDefault().log(sb.toString());
            ++j;
        }
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (this.streamInputReaders == null ? 0 : this.streamInputReaders.hashCode());
        result = 31 * result + (this.trace == null ? 0 : this.trace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CTFTraceReader)) {
            return false;
        }
        CTFTraceReader other = (CTFTraceReader)obj;
        if (this.endTime != other.endTime) {
            return false;
        }
        if (this.startTime != other.startTime) {
            return false;
        }
        if (this.streamInputReaders == null ? other.streamInputReaders != null : !this.streamInputReaders.equals(other.streamInputReaders)) {
            return false;
        }
        return !(this.trace == null ? other.trace != null : !this.trace.equals(other.trace));
    }

    public String toString() {
        return "CTFTraceReader [trace=" + this.trace + ']';
    }

    public CTFTrace getTrace() {
        return this.trace;
    }
}

