/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramDataModel;

public class HistogramRequest
extends TmfEventRequest<ITmfEvent> {
    protected final HistogramDataModel fHistogram;

    public HistogramRequest(HistogramDataModel histogram, TmfTimeRange range, int rank, int nbEvents, ITmfDataRequest.ExecutionType execType) {
        super(ITmfEvent.class, range, rank, nbEvents, 10000, execType);
        this.fHistogram = histogram;
    }

    public HistogramRequest(HistogramDataModel histogram, TmfTimeRange range, ITmfDataRequest.ExecutionType execType) {
        this(histogram, range, 0, Integer.MAX_VALUE, execType);
    }

    public HistogramRequest(HistogramDataModel histogram, TmfTimeRange range, int rank, ITmfDataRequest.ExecutionType execType) {
        this(histogram, range, rank, Integer.MAX_VALUE, execType);
    }

    public void handleData(ITmfEvent event) {
        super.handleData(event);
        if (event != null) {
            long timestamp = event.getTimestamp().getValue();
            this.fHistogram.countEvent(this.getNbRead(), timestamp);
        }
    }

    public void handleCompleted() {
        this.fHistogram.complete();
        super.handleCompleted();
    }

    public void handleCancel() {
        super.handleCancel();
    }
}

